/******************************** Linear Regression ******************************************/
#if !defined(_IM_LINEAR_REGRESSION_H_)
#define _IM_LINEAR_REGRESSION_H_

#include "IMObjects.h"

#ifdef __cplusplus
extern "C" {
#endif

#define IMinerLinearRegressionModel IMinerObject

#define IMINER_LI_R_META_DATA_NUM				0
#define IMINER_LI_R_COEFFICIENTS_NUM			1

/* macro to access a matrix element from IMinerMatrix object*/
#define IMINER_LI_R_PTR(pObj, i)				(pObj)->m_uData.m_ppList[i]
#define IMINER_LI_R_META_DATA(model)			IMINER_LI_R_PTR(model, IMINER_LI_R_META_DATA_NUM)
#define IMINER_LI_R_COEFFICIENTS(model)			IMINER_LI_R_PTR(model, IMINER_LI_R_COEFFICIENTS_NUM)

/* validate the object */
IMCSRC_DLLAPI(long) IMinerLinearRegressionModel_isValid(const IMinerObject* pModel);

/* alloc memory and set content for a Linear Regression Model. */
IMCSRC_DLLAPI(long) IMinerLinearRegressionModel_create(
 IMinerObject* pModel,			/* out: data object */
 IMinerObject* md,			    /* in:  meta data object */
 long nCoefficents,				/* in:  number of coefficients */
 double* pdCoefficents			/* in: if not NULL, elements of coefficents. */
);

/* free memory of type IMinerRectData. */
IMCSRC_DLLAPI(long) IMinerLinearRegressionModel_destroy(IMinerObject* pModel );

/* write to stdout */
IMCSRC_DLLAPI(long) IMinerLinearRegressionModel_print(const IMinerObject* pModel);

/* predict cluster memberships */
IMCSRC_DLLAPI(long) IMinerLinearRegressionModel_predict(IMinerObject* pdOutput,  /* out: output vector data of type double*/
 const IMinerObject* pInput, /* in: input rectangular data */													 
 IMinerObject* pDescr,		 /* in: input description (if NULL, description will be 
                                    created from input data) */
 const IMinerObject* pModel  /* in: the model */
);

#ifdef __cplusplus
}
#endif

#endif /*_IM_LINEAR_REGRESSION_H_ */

