/********************************KMEANS CLUSTER ******************************************/
#if !defined(_IM_PRINCIPAL_COMONENTS_H_)
#define _IM_PRINCIPAL_COMONENTS_H_

#include "IMObjects.h"

#define IMinerPrincipalComponentsModel IMinerObject

/* macro to access a matrix element from IMinerMatrix object*/
#define IMINER_PRINCIPAL_COMPONENTS_META_DATA_NUM	0
#define IMINER_PRINCIPAL_COMPONENTS_CENTER_MEMBER	1
#define IMINER_PRINCIPAL_COMPONENTS_SCALE_MEMBER	2
#define IMINER_PRINCIPAL_COMPONENTS_LOAD_MEMBER		3

#define IMINER_PRINCIPAL_COMPONENTS_META_DATA(pObj)  (pObj)->m_uData.m_ppList[IMINER_PRINCIPAL_COMPONENTS_META_DATA_NUM]
#define IMINER_PRINCIPAL_COMPONENTS_CENTER_PTR(pObj) (pObj)->m_uData.m_ppList[IMINER_PRINCIPAL_COMPONENTS_CENTER_MEMBER]
#define IMINER_PRINCIPAL_COMPONENTS_SCALE_PTR(pObj)  (pObj)->m_uData.m_ppList[IMINER_PRINCIPAL_COMPONENTS_SCALE_MEMBER]
#define IMINER_PRINCIPAL_COMPONENTS_LOAD_PTR(pObj)   (pObj)->m_uData.m_ppList[IMINER_PRINCIPAL_COMPONENTS_LOAD_MEMBER]

#ifdef __cplusplus
extern "C" {
#endif

/* alloc memory and set content for class KMeans Cluster */
IMCSRC_DLLAPI(long) IMinerPrincipalComponentsModel_create(
 IMinerObject* pModel,		   /* out: data object */
 IMinerObject* md,			   /* in:  meta data object */
 long nComponents,             /* in:  number of components */
 long nColumns,                /* in:  number of cols */ 
 const double* pdCenters,      /* in:  center factors of length nColumns */
 const double* pdScale,        /* in:  scaling factors of length nColumns */
 const double* pdLoadings      /* in:  loading factors of length (nComponents*nColumns) */
);

/* validate the object */
IMCSRC_DLLAPI(long) IMinerPrincipalComponentsModel_isValid(const IMinerObject* pModel);

/* free memory */
IMCSRC_DLLAPI(long) IMinerPrincipalComponentsModel_destroy(IMinerObject* pModel );

/* write to stdout */
IMCSRC_DLLAPI(long) IMinerPrincipalComponentsModel_print(const IMinerObject* pModel);

/* predict cluster memberships */
IMCSRC_DLLAPI(long) IMinerPrincipalComponentsModel_predict(
 IMinerObject* pOutput,      /* out: output rectangular data */
 const IMinerObject* pInput, /* in: input rectangular data */													 
 IMinerObject* pDescr,		 /* in: input description (if NULL, description will be 
                                    created from input data) */
 const IMinerObject* pModel  /* in: the model */
);

#ifdef __cplusplus
}
#endif

#endif /*_IM_PRINCIPAL_COMONENTS_H_ */

