/**
 * An SpConnectionCreator object reads a connections.xml
 *   file and creates the S-PLUS sessions described therein.
 * The code parses XML using SAX1, which comes with Tomcat.
 *
 * author Gary Nelson, gnelson@insightful.com
 * version 19 April 2001
 **/

import javax.xml.parsers.*;
import org.xml.sax.*;
import java.io.*;

public class SpConnectionCreator extends org.xml.sax.helpers.DefaultHandler
{
	protected ObjPool m_pool;  // place to store new SpConnections
	protected int m_nCount;    // number of new SpConnections

	// variables for accumulating a new spConnection
	protected StringBuffer m_strbufText = new StringBuffer();
	protected SpConnection m_con;

	public SpConnectionCreator(ObjPool pool) {
		m_pool = pool;
		m_nCount = 0;
	}

	/**
	 * Parse an XML file, construct SpConnection objects as indicated,
	 *   and add them to m_pool.
	 **/
	public int parseFile(File fileXML) 
	{
		try {
			// Create a SAX 1 parser.
			SAXParserFactory spf = SAXParserFactory.newInstance();
			spf.setValidating(false);
			SAXParser sp = spf.newSAXParser();

			// Create the input source.
			InputSource insrc = new InputSource(new FileReader(fileXML));

			// Parse.
			sp.parse(insrc, this);
		}
		catch (ParserConfigurationException ex) {
			System.err.println("Error creating parser: " +
				ex.getMessage());
		}
		catch (SAXException ex) {
			System.err.println("Error parsing: " +
				ex.getMessage());
		}
		catch (IOException ex) {
			System.err.println("Configuration file IO error: " +
				ex.getMessage());
		}

		return m_nCount;
	}

	/* Receive plain text, not in a tag. */
	public void characters(char[] vchBuffer, int nStart, int nLength) {
		StringBuffer bufErase = new StringBuffer();
		bufErase.append(vchBuffer, nStart, nLength);
		m_strbufText.append(vchBuffer, nStart, nLength);
	}

	/* Start a new XML element. */
	public void startElement(String uri, String localName, 
						String qName, Attributes lstAttributes) {
		String strTag = qName;
		if (strTag.equals("connection")) {
			String strName = lstAttributes.getValue("name");
			m_con = new SpConnection(strName);
		}
		else {
			m_strbufText.setLength(0);  // Clear the text buffer.
		}
	}

	/* End an XML element. */
	public void endElement(String uri, String localName, String qName) {
		String strTag = qName;
		if (strTag.equals("splus-connections")) {
			// Do nothing.
		}
		else if (strTag.equals("connection")) {
			// Finish up the current SpConnection object.
			if (m_con.connect()) {
				m_pool.addObj(m_con);
				m_nCount++;
			}
		}
		else if (strTag.equals("host")) {
			String strValue = m_strbufText.toString().trim();
			m_con.setHost(strValue);
		}
		else if (strTag.equals("username")) {
			String strValue = m_strbufText.toString().trim();
			m_con.setUsername(strValue);
		}
		else if (strTag.equals("password")) {
			String strValue = m_strbufText.toString().trim();
			m_con.setPassword(strValue);
		}
		else if (strTag.equals("rmiport")) {
			String strValue = m_strbufText.toString().trim();
			m_con.setRMIPort(strValue);
		}
		else if (strTag.equals("cwd")) {
			String strValue = m_strbufText.toString().trim();
			m_con.setWorkingDirectory(strValue);
		}
		else if (strTag.equals("display")) {
			String strValue = m_strbufText.toString().trim();
			m_con.setXDisplay(strValue);
		}
		else if (strTag.equals("prompt")) {
			String strValue = m_strbufText.toString().trim();
			m_con.setPrompt(strValue);
		}
	}

	public void warning(SAXParseException ex) {
		System.err.println("XML parse warning, line " + ex.getLineNumber() +
			":  " + ex.getMessage());
	}

	public void error(SAXParseException ex) {
		System.err.println("XML parse error, line " + ex.getLineNumber() +
			":  " + ex.getMessage());
	}

	public void fatalError(SAXParseException ex) 
		throws SAXParseException
	{
		System.err.println("XML parse error, line " + ex.getLineNumber() +
			":  " + ex.getMessage());
		throw(ex);
	}
}
