import com.insightful.splus.*;
import java.util.ArrayList;

/**
 * Example of an ArrayList containing the data in a specified S-PLUS 
 * data.frame.
 */

public class DataFrameArrayListExample {

    public static void main(String [] args) {

	try {
	    String dataName = "fuel.frame" ;

	    // The data.frame name can be specified as an argument to main()
	    if (args.length == 1)
		dataName = args[0];

	    // Create the array list from data.frame info in S-PLUS    
	    DataFrameArrayList arrayList = new DataFrameArrayList(dataName);
	    
	    // Print the number of columns
	    System.out.println("Number of columns: " + arrayList.size());
	    
	    // Print the first column name
	    String [] colNames = arrayList.getColumnNames();
	    System.out.println("First column name: " + colNames[0]);

	    // Print the first double value
	    Class doubleArray = Class.forName("[D");
	    Object curObj;
	    for (int i = 0; i < arrayList.size(); i++) {
		curObj = arrayList.get(i);
		if (curObj.getClass() == doubleArray) {
		    double val = ((double []) curObj) [0];
		    System.out.println("First double: " + val);
		    break;
		}
	    }
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
	System.exit(0);
    }

    /**
     * ArrayList containing data from the specified data.frame.  In addition
     * to the ArrayList methods, there is a getColumnNames() method.  The
     * ArrayList methods do not modify the column names.
     */

    public static class DataFrameArrayList extends ArrayList {

	/**
	 * Store the column names.
	 */

	private String [] colNames;

	/**
	 * Create the ArrayList with data in the specified data.frame.
	 */
		
	public DataFrameArrayList(String name) {

	    /* Check that data.frame exists */

	    String expr = "exists(\"" + name + "\") && inherits(" + name +
		", \"data.frame\")\n";

	    SplusDataResult result = SplusUserApp.eval(expr);

	    try {
		if (!result.getBooleanData()[0])
		    throw new RuntimeException("Specified data.frame does not exist.");
	    }
	    catch (Exception e) {
		throw new RuntimeException(e.toString());
	    }

	    /* Get the column names */
	    expr = "names(" + name + ")\n";
	    result = SplusUserApp.eval(expr);

	    try {
		colNames = result.getStringData();
	    }
	    catch (Exception e) {
		throw new RuntimeException(e.toString());
	    }

	    /* Get the data.frame columns. */
	    for (int i = 1; i < colNames.length + 1; i++){
		expr = "as.vector(" + name + "[," + i + "])\n";
		    
		result = SplusUserApp.eval(expr);

		try {
		    /* Add array object to ArrayList */
		    add(result.getData());
		}
		catch (Exception e) {
		    throw new RuntimeException(e.toString());
		}
	    }
	}

	public String [] getColumnNames() {
	    return colNames;
	}
    }
}

