/**
 * Static methods for use testing .JavaField() and .JavaMethod().
 * S-PLUS code calling these methods is included as comments at the
 * end of the file.
 */

public class StaticMethodsExample {

    public static boolean statBoolean = true;
    public static byte statByte = 1;
    public static char statChar = 'A'; 
    public static short statShort = 20;
    public static int statInt = 300;
    public static long statLong = 4000;
    public static float statFloat = 5.5f;
    public static double statDouble = 53.2;
    
    public static String statString = "Static String";

    public static boolean [] arrayBoolean = 	
	new boolean[] {true, false};

    public static byte [] arrayByte =
	new byte[] {2, 4};

    public static char [] arrayChar =
	new char [] {'A', 'B'};

    public static short [] arrayShort =
	new short [] {12, 9};

    public static int [] arrayInt =
	new int [] {100, 200};

    public static long [] arrayLong =
	new long [] {3000, 4000};

    public static float [] arrayFloat =
	new float [] {3.2f, 4.8f};

    public static double [] arrayDouble =
	new double [] {1.1, 2.2};

    public static String [] arrayString =
	new String [] {"Thing 1", "Thing 2"};

    public static Object [] arrayObject =
	new Object [] {arrayInt, arrayDouble, arrayString};


    public static java.util.Collection collection =	
	new java.util.Vector(); 

    static {
	collection.add(arrayBoolean);
	collection.add(arrayChar);
	collection.add(arrayObject);
    }

    // Methods returning primitives
    
    public static void getVoid(){
    }
    
    public static boolean getBoolean() {
	return statBoolean;
    }
    
    public static byte getByte() {
	return statByte;
    }
    
    public static char getChar() {
	return statChar;
    }
    public static short getShort() {
	return statShort;
    }
    
    public static int getInt() {
	return statInt;
    }
    
    public static long getLong() {
	return statLong;
    }
    
    public static float getFloat() {
	return statFloat;
    }
    
    public static double getDouble() {
	return statDouble;
    }

    public static String getString() {
	return statString;
    }
    
    // Methods returning arrays of primitives
    
    public static boolean [] getBooleanArray() {
	return arrayBoolean;
    }
    
    public static byte [] getByteArray() {
	return arrayByte;
    }
    
    public static char [] getCharArray() {
	return arrayChar;
    }

    public static short [] getShortArray() {
	return arrayShort;
    }
    
    public static int [] getIntArray() {
	return arrayInt;
    }
    
    public static long [] getLongArray() {
	return arrayLong;
    }
    
    public static float [] getFloatArray() {
	return arrayFloat;
    }
    
    public static double [] getDoubleArray() {
	return arrayDouble;
    }

    public static String [] getStringArray() {
	return arrayString;
    }

    // Methods returning an S-PLUS list

    public static Object [] getObjectArray() {
	return arrayObject;
    }
    
    public static java.util.Collection getCollection() {
	return collection;
    }

    // Methods returning java.lang.Object
    
    public static Object getVoidObject(){
	// Same behavior as using Method.invoke() with a method of type void  
	return null;
    }
    
    public static Object getBooleanObject() {
	return new Boolean(statBoolean);
    }
    
    public static Object getByteObject() {
	return new Byte (statByte);
    }
    
    public static Object getCharObject() {
	return new Character(statChar);
    }

    public static Object getShortObject() {
	return new Short(statShort);
    }
    
    public static Object getIntObject() {
	return new Integer(statInt);
    }
    
    public static Object getLongObject() {
	return new Long(statLong);
    }
    
    public static Object getFloatObject() {
	return new Float(statFloat);
    }
    
    public static Object getDoubleObject() {
	return new Double(statDouble);
    }
    
    public static Object getStringObject() {
	return statString;
    }
    
    // Methods returning arrays as java.lang.Object
    
    public static Object getBooleanArrayObject() {
	return arrayBoolean;
    }
    
    public static Object getByteArrayObject() {
	return arrayByte;
    }
    
    public static Object getCharArrayObject() {
	return arrayChar;
    }

    public static Object getShortArrayObject() {
	return arrayShort;
    }
    
    public static Object getIntArrayObject() {
	return arrayInt;
    }
    
    public static Object getLongArrayObject() {
	return arrayLong;
    }
    
    public static Object getFloatArrayObject() {
	return arrayFloat;
    }

    public static Object getDoubleArrayObject() {
	return arrayDouble;
    }

    public static Object getStringArrayObject() {
	return arrayString;
    }    

    /* Methods taking single values as arguments */


    public static boolean sendBoolean(boolean val) {
	return val;
    }
    
    public static byte sendByte(byte val) {
	return val;
    }
    
    public static char sendChar(char val) {
	return val;
    }
    public static short sendShort(short val) {
	return val;
    }
    
    public static int sendInt(int val) {
	return val;
    }
    
    public static long sendLong(long val) {
	return val;
    }
    
    public static float sendFloat(float val) {
	return val;
    }
    
    public static double sendDouble(double val) {
	return val;
    }

    public static String sendString(String val) {
	return val;
    }
    


    /* Methods taking arrays as arguments */

    public static boolean sendBooleanArray(boolean [] vals){
	boolean retVal = true;
	for (int i=0; i < vals.length; i++){
	    retVal = retVal || vals[i];
	}
	return retVal;
    }

    public static byte sendByteArray(byte [] vals){
	byte retVal = 0;
	for (int i=0; i < vals.length; i++){
	    retVal += vals[i];
	}
	return retVal;
    }

    public static char sendCharArray(char [] vals){
	return Character.toUpperCase(vals[0]);
    }

    public static short sendShortArray(short [] vals){
	short retVal = 0;
	for (int i=0; i < vals.length; i++){
	    retVal += vals[i];
	}
	return retVal;
    }

    public static int sendIntArray(int [] vals){
	int retVal = 0;
	for (int i=0; i < vals.length; i++){
	    retVal += vals[i];
	}
	return retVal;
    }

    public static long sendLongArray(long [] vals){
	long retVal = 0;
	for (int i=0; i < vals.length; i++){
	    retVal += vals[i];
	}
	return retVal;
    }

    public static float sendFloatArray(float [] vals){
	float retVal = 0.0f;
	for (int i=0; i < vals.length; i++){
	    retVal += vals[i];
	}
	return retVal;
    }

    public static double sendDoubleArray(double [] vals){
	double retVal = 0;
	for (int i=0; i < vals.length; i++){
	    retVal += vals[i];
	}
	return retVal;
    }

    public static String sendStringArray(String [] vals){
	String retVal = "";
	for (int i=0; i < vals.length; i++){
	    retVal += vals[i];
	}
	return retVal;
    }

}

/**
 * Test Code for S-PLUS
 **

 # Getting primitives

 .JavaField("StaticMethodsExample", "statBoolean", "Z")
 .JavaField("StaticMethodsExample", "statByte", "B")
 .JavaField("StaticMethodsExample", "statChar", "C")
 .JavaField("StaticMethodsExample", "statShort", "S")
 .JavaField("StaticMethodsExample", "statInt", "I")
 .JavaField("StaticMethodsExample", "statLong", "J")
 .JavaField("StaticMethodsExample", "statFloat", "F")
 .JavaField("StaticMethodsExample", "statDouble", "D")
 .JavaField("StaticMethodsExample", "statString", "Ljava/lang/String;")

 # Getting arrays of primitives

 .JavaField("StaticMethodsExample", "arrayBoolean", "[Z")
 .JavaField("StaticMethodsExample", "arrayByte", "[B")
 .JavaField("StaticMethodsExample", "arrayChar", "[C")
 .JavaField("StaticMethodsExample", "arrayShort", "[S")
 .JavaField("StaticMethodsExample", "arrayInt", "[I")
 .JavaField("StaticMethodsExample", "arrayLong", "[J")
 .JavaField("StaticMethodsExample", "arrayFloat", "[F")
 .JavaField("StaticMethodsExample", "arrayDouble", "[D")
 .JavaField("StaticMethodsExample", "arrayString", "[Ljava/lang/String;")

 # Getting lists

 .JavaField("StaticMethodsExample", "arrayObject", "[Ljava/lang/Object;")
 .JavaField("StaticMethodsExample", "collection", "Ljava/util/Collection;")

 # Methods getting single values

 .JavaMethod("StaticMethodsExample", "getVoid", "()V")
 .JavaMethod("StaticMethodsExample", "getBoolean", "()Z")
 .JavaMethod("StaticMethodsExample", "getByte", "()B")
 .JavaMethod("StaticMethodsExample", "getChar", "()C")
 .JavaMethod("StaticMethodsExample", "getShort", "()S")
 .JavaMethod("StaticMethodsExample", "getInt", "()I")
 .JavaMethod("StaticMethodsExample", "getLong", "()J")
 .JavaMethod("StaticMethodsExample", "getFloat", "()F")
 .JavaMethod("StaticMethodsExample", "getDouble", "()D")
 .JavaMethod("StaticMethodsExample", "getString", "()Ljava/lang/String;")

 # Methods getting arrays

 .JavaMethod("StaticMethodsExample", "getBooleanArray", "()[Z")
 .JavaMethod("StaticMethodsExample", "getByteArray", "()[B")
 .JavaMethod("StaticMethodsExample", "getCharArray", "()[C")
 .JavaMethod("StaticMethodsExample", "getShortArray", "()[S")
 .JavaMethod("StaticMethodsExample", "getIntArray", "()[I")
 .JavaMethod("StaticMethodsExample", "getLongArray", "()[J")
 .JavaMethod("StaticMethodsExample", "getFloatArray", "()[F")
 .JavaMethod("StaticMethodsExample", "getDoubleArray", "()[D")
 .JavaMethod("StaticMethodsExample", "getStringArray", "()[Ljava/lang/String;")

 # Methods returning an S-PLUS list
 .JavaMethod("StaticMethodsExample", "getObjectArray", 
 "()[Ljava/lang/Object;");
 
 .JavaMethod("StaticMethodsExample", "getCollection", 
   "()Ljava/util/Collection;")
 
 # toString() is used to get a non-primitive object as a string

 .JavaMethod("java/awt/print/PrinterJob", "getPrinterJob",
   "()Ljava/awt/print/PrinterJob;")

 .JavaMethod("java/lang/System", "getProperties",
   "()Ljava/util/Properties;")

 # Get primitives as Objects

 .JavaMethod("StaticMethodsExample", "getVoidObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getBooleanObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getByteObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getCharObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getShortObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getIntObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getLongObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getFloatObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getDoubleObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getStringObject", "()Ljava/lang/Object;")

 # Get arrays as Objects

 .JavaMethod("StaticMethodsExample", "getBooleanArrayObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getByteArrayObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getCharArrayObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getShortArrayObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getIntArrayObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getLongArrayObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getFloatArrayObject", "()Ljava/lang/Object;")
.JavaMethod("StaticMethodsExample", "getDoubleArrayObject", "()Ljava/lang/Object;")
 .JavaMethod("StaticMethodsExample", "getStringArrayObject", "()Ljava/lang/Object;")

 # Sending single value arguments

 .JavaMethod("StaticMethodsExample", "sendBoolean", "(Z)Z", T)
 .JavaMethod("StaticMethodsExample", "sendByte", "(B)B", raw(1))
 .JavaMethod("StaticMethodsExample", "sendChar", "(C)C", "a")
 .JavaMethod("StaticMethodsExample", "sendShort", "(S)S", 1)
 .JavaMethod("StaticMethodsExample", "sendInt", "(I)I", 1)
 .JavaMethod("StaticMethodsExample", "sendLong", "(J)J", 1)
 .JavaMethod("StaticMethodsExample", "sendFloat", "(F)F", 1)
 .JavaMethod("StaticMethodsExample", "sendDouble", "(D)D", 1)
 .JavaMethod("StaticMethodsExample", "sendString",
    "(Ljava/lang/String;)Ljava/lang/String;", "a1")

     
 # Sending array arguments
 
 .JavaMethod("StaticMethodsExample", "sendBooleanArray", "([Z)Z", c(T, T, F))
 .JavaMethod("StaticMethodsExample", "sendByteArray", "([B)B", 1:3)
 .JavaMethod("StaticMethodsExample", "sendCharArray", "([C)C", "abc")
 .JavaMethod("StaticMethodsExample", "sendShortArray", "([S)S", 1:3)
 .JavaMethod("StaticMethodsExample", "sendIntArray", "([I)I", 1:3)
 .JavaMethod("StaticMethodsExample", "sendLongArray", "([J)J", 1:3)
 .JavaMethod("StaticMethodsExample", "sendFloatArray", "([F)F", 1:3)
 .JavaMethod("StaticMethodsExample", "sendDoubleArray", "([D)D", 1:3)
 .JavaMethod("StaticMethodsExample", "sendStringArray",
    "([Ljava/lang/String;)Ljava/lang/String;", c("a1", "b2", "c3"))

*/






