import com.insightful.splus.*;
import com.insightful.splus.util.FileUtilities;
import java.io.FileInputStream;
import java.io.FileOutputStream;

/**
 * Example of creating a graph file on a server and transferring it to a
 * client.  This example is only relevant in client/server mode. 
 */
 
public class TransferGraphExample {

    public static void main(String [] args){
	FileInputStream inStream; 
	FileOutputStream outStream;
	
	try {
	    String serverFile = "test1.bmp";
	    String clientFile = "test2.bmp";
	    
	    System.out.println("Creating the graph");
	    
	    // Start the device
	    SplusUserApp.eval("java.graph(file=\"test1.bmp\", format=\"BMP\")\n");
	    
	    // Make the plot
	    SplusUserApp.eval("plot(rnorm(10))\n");

	    // Close the device to generate the file
	    System.out.println("Saving the plot on the server as test1.bmp");  

	    SplusUserApp.eval("dev.off()\n");

	    System.out.println("Copying the file to the client as test2.bmp");
 
	    // Get a FileInputStream from the server

	    inStream = 
		SplusSystem.getServerFileHandler().getServerFileInputStream(
								serverFile);

	    // Get a local FileOutputStream to write on the client
	    outStream = new FileOutputStream(clientFile);

	    // Transfer the file

	    FileUtilities.transferBytes(inStream, outStream);

	    // Close the file streams
	    inStream.close();
	    outStream.close();
	    
	    System.out.println("File copied.");
	}
	catch (Exception e){
	    System.out.println(e);
	}
	System.exit(0);
    }
}


