## #################################################################
## This Kahan summation algorithm minimizes the error when adding a 
## sequence of finite precision floating point numbers.
## It is of basic use, therefore, on computers. It is also called 
## compensated summation.
##
## kahanSum Example
## kahanSum calls the function, kahanAddNext, which
## is stored in the file kahanAddNext_func.q.
## #################################################################
"kahanSum" <-
function(x)
{
  ## Initialize values
  kahanValues <- list(sum = 0.0, correction = 0.0)

  ## Perform the Kahan summation
  N <- length(x)
  for(i in 1:N) {
    kahanValues <- kahanAddNext(x[i], kahanValues)
  }

  return(kahanValues[["sum"]])
}

##  Put breakpoint at kahanValues <- kahanAddNext(x[i], kahanValues)
##  to track where corrections occur in the for() loop.
##
##  In the Console View, set the option to see numbers:
##  options(digits=17)
##
##  Engage the debugger.
##
##  In the Console View, provide a calculation for kahanSum:
##  kahanSum(rep(1000000000.1, 10))

