gaussSeidel<-
# gaussSeidel solves a linear system using Gauss-Seidel iterative method.
# REQUIRED ARGUMENTS: 
#      A and b are numeric matrix and vector respectively.
# VALUE: 
#      a vector x, solution of A x = b
#
# Usage:
#  A<-matrix(rnorm(100),nrow=10)
#  diag(A)<-seq(ncol(A),ncol(A)) #Make it diagonally dominant
#  b<-rnorm(ncol(A))
#  sys.time({x1<-gaussSeidel(A,b)})
function(A,b)
{	
	# Hard-coded relative tolerance and max iterations
	tol<-1.0e-4
	maxItr<-1e4 

	# Validating
	A <- as.matrix(A)
	b <- as.numeric(b)
	nRows <- nrow(A)
	nCols <- ncol(A)
	if(nRows!=nCols || nCols!=length(b))
		stop("nrow(A)!=ncol(A) || ncol(A)!=length(b)")

	# Begin Gauss-Seidel step	
	x<-b
	for(k in 1:maxItr)
	{
		xOld<-x
		for(i in 1:nRows)
		{    
 			s<- A[i,i]*x[i]
			for(j in 1:nCols)
				s <- s - A[i,j]*x[j]
			x[i] <- (b[i]+s)/A[i,i]
		} 
		# Check convergence; continue if necessary
		if(max(abs((x-xOld)/x)) < tol)
			return(x);
	}	
	warning("Solution does not converge\n")
	return(x)
}

