// spllm.cxx : a simple console application that illustrates how to 
// 1. create a connection to S-PLUS.
// 2. create permanent objects in S database.
// 3. evaluate an S expression.
//
// Under Windows
// Steps to build and test this program from a DOS prompt.
// 1. Change current directory to directory containing this file
//     cd <directory containing this file> 
// 2. Build the program 
//     msdev spllm.dsp /make
// 3. Run the program
//     spllm.exe S_HOME=%SHOME%
// 4. Run the S-PLUS console
//     %SHOME%\cmd\sqpe.exe
// 5. Look for S objects: x, y and z.  For example, 
//     > objects()


// Under Unix
// Steps to build and test this program from a C-shell.
// 1. Change current directory to directory containing this file
//     cd <directory containing this file> 
// 2. Build the program 
//     Splus6 CHAPTER -sconnectapp *.cxx
//     Splus6 make 
// 3. Run the program
//     Splus6 S.app
// 4. Run the S-PLUS console
//    Splus6
// 5. Look for S objects: x, y and z.  For example, 
//     > objects()


#include "sconnect.h"

//A global connection object 
CSPengineConnect g_engineConnect;

int main(int argc, char* argv[])
{
	//Create the connection to S-PLUS
	g_engineConnect.Create( argc, argv); 

	//Create S object with name "x" in the current database. 
	//Same as x<-1:10 at the command line.
	CSPnumeric sx;
	sx.Create("1:10","x"); 

	//Squaring sx, which is the same as S expression sy <- x*x in a local frame, 
	//but here we set it to local C++ variable sy.
	
	CSPnumeric sy = sx * sx; 

	// Assign the result as S object with name "y" in the current database.
	sy.Assign("y"); 

	//Evaluate z<-lm(y~x)
	g_engineConnect.SyncParseEval("z<-lm(y~x)");

	return 1;
}

