/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spalcfrm.h: interface and implementation of the CSPallocFrame class.

	Useful for setting allocated frame via the default constructor.
	And the destructor automatically reset it.
	Commonly use in a scope such as 
	{
		CSPallocFrame sDummy(1) //set allocated frame to 1
    ...
  } //reset to previously allocated frame.
*/

#if !defined(__SCONNECT_SPALCFRM_H_INCLUDED__)
#define __SCONNECT_SPALCFRM_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "S.h"
#include "spdefs.h"

class CSPallocFrame  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	SCONNECT_LIB_EXTERN CSPallocFrame();
	SCONNECT_LIB_EXTERN CSPallocFrame(long lAllocFrame);
	SCONNECT_LIB_EXTERN virtual ~CSPallocFrame();

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
public:
  //Allocate a vector-liked object with len and mode
	SCONNECT_LIB_EXTERN s_object* alcvec(int mode, long len);
  //Set the reference count to be permanent if needed.
	SCONNECT_LIB_EXTERN s_object* SetPermRefIfNeeded(s_object* ps_object);

private:
	long m_lPrevFrame;
	BOOL m_bSetFlag;  //Safer to use a separate member for the flag rather than relying on m_lPrevFrame alone.
};

#endif //#if !defined(__SCONNECT_SPALCFRM_H_INCLUDED__)

