/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spattach.h: interface for the CSPattached class.
*/

#if !defined(__SCONNECT_SPATTACH_H_INCLUDED__)
#define __SCONNECT_SPATTACH_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "spvector.h"
#include "sqpe.h"

#define S_OBJECT_SUMMARY		-256
#define S_OBJECT_DATA				1
#define S_OBJECT_HEADER			0

const size_t ATTACHED_SV3Database = 1 << 0;

class SCONNECT_LIB_EXTERN CSPattached : public CSPobject  
{
public:
	typedef enum 
	{
		typeError = 0,
		directory,
		object,
		table
	} Type;
	typedef enum 
	{
		statusError = 0,
		read,
		readwrite,
		modified
	} Status;

public:
	class SCONNECT_LIB_EXTERN CSObjectItem
	{
	private:
		s_object* m_ps_object;
		const char* m_pszName;

	protected:
		CSObjectItem();
		CSObjectItem(s_object* ps_object, const char* pszName);
		~CSObjectItem(){};

	public:
		BOOL IsValid() const;
		const char* GetName() const {return m_pszName;}
		const s_object* Get() const {return m_ps_object;}

	protected:
		void Init();
		void Set(s_object* ps_object, const char* pszName);

		friend class CSPattached;
	};

protected:

	typedef struct _TIterator
	{
		s_object* ps_names;
		s_object* ps_classes;
		s_class** pFailed;
		s_class** pExtClasses;
		BOOL bExtends;
		BOOL bGetData;
		long lExt, lExtSize;
		long lFail, lFailSize;
		long lClass;
		long lPosition;
		_TIterator(): ps_names(NULL), ps_classes(NULL), pFailed(NULL), 
						  pExtClasses(NULL), bExtends(FALSE),
						  bGetData(FALSE),
                                                  lExt(0), lExtSize(0), 
						  lFail(0), lFailSize(0), lClass(0), lPosition(-1) {};
		~_TIterator()
		{
			if( ::Sqpe_GetCurrentEvaluator()->_eval_open )
			{
				if ( pFailed )
					::S_ok_free(pFailed, ::Sqpe_GetCurrentEvaluator());
				pFailed = NULL;

				if ( pExtClasses )
					::S_ok_free((void*)pExtClasses, ::Sqpe_GetCurrentEvaluator());
				pExtClasses = NULL;
			}
		};
	} TIterator;

//////////////////////////////////////////////////////
// Construction/Destruction/Assignment Operators
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSPattached();
	//Copy constructor: copy appropriate data members
	CSPattached(const CSPattached& sObject);
	//Construct from object of a base class
	CSPattached(const CSPobject& sObject);
	//Construct from a valid S-expression
	explicit CSPattached(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSPattached(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSPattached& operator=(const CSPattached& sObject);
	//Assign from the base class
	CSPattached& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSPattached& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSPattached();

//	s_db_purposes: REGULAR_DB, META_DB, SEARCH_DB, DATA_DB, RELOAD_DB, TEMP_DB, LOCK_DB
	CSPattached(const char* pszName, s_db_purposes dbPurpose);
	CSPattached(long lPos, s_db_purposes dbPurpose);
	//Required overriden to make object of this class instantiable
	virtual  s_object* Eval(void);

  //Return TRUE if the object is a valid 'attached' class
	virtual BOOL IsValid(void) const;

	//---------------------------------------------------------
	// Operations:

	s_object* Assign(s_object* ps_object, const char* pszName);
	void Assign(const char *str,long num)
	{
	  CSPobject::Assign(str, num);
	}

	BOOL DatabaseRequired(BOOL bValiate=TRUE);
	void DetachDatabase(BOOL bValidate=TRUE);
	long GetPosition(BOOL bValidate=TRUE);
	long GetCount(BOOL bValidate=TRUE);
	s_object* GetDatabasePath(BOOL bValidate=TRUE);
	Status GetStatus(BOOL bValidate=TRUE);
	void SetStatus(Status status, BOOL bValidate=TRUE);
	Type GetType(BOOL bValidate=TRUE);
	s_object* GetDatabaseName(BOOL bValidate=TRUE);
	s_db_purposes GetPurpose(BOOL bValidate=TRUE);

	const char* GetFileName(const char* pszName);
	BOOL Exists(const char* pszName);

	/* iType must be either 
			S_OBJECT_DATA - full object.
			S_OBJECT_HEADER - object header. Used to check for existance
			S_OBJECT_SUMMARY - summary object. Recursively read headers. Use with caution. 
	*/
	s_object* Get(const char* pszName, int iType=S_OBJECT_DATA);

	BOOL Remove(const char* pszNames);
	int Remove()
	{
	  return CSPobject::Remove();
	}

	s_object* GetNames(s_object* ps_classes=NULL, BOOL bExtends=FALSE);

	BOOL InitIterator(s_object* ps_classes=NULL, BOOL bExtends=FALSE, BOOL bGetData=FALSE);
	CSObjectItem& Next();

	//---------------------------------------------------------
	// Compare helpers

	BOOL operator == (const CSPobject& sobject) const;
	BOOL operator != (const CSPobject& sobject) const;

protected:
	s_object* SDictionary(int iSysVal);
	long GetTableIndex();
	// Advanced access to reading an object from disk
	s_object* GetSummary(const char* pszName, int iLevel, BOOL bKeep, BOOL bModernize);

	BOOL IsInfoFlag(size_t uiFlag){return ((m_uiFlags&uiFlag)==uiFlag);}
	void SetInfoFlagBit(size_t uiFlag){m_uiFlags |= uiFlag;}
	void SetInfoFlagBitOff(size_t uiFlag){m_uiFlags &= ~uiFlag;}

protected:
	size_t m_uiFlags;

private:
	TIterator* m_pIterator;
	CSObjectItem m_sObjectItem;
};


#endif // !defined(__SCONNECT_SPATTACH_H_INCLUDED__)
