/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
 
	spfunc.h: interface for the CSPfunction wrapping S-PLUS object of class "function".
*/

#if !defined(__SCONNECT_SPFUNC_H_INCLUDED__)
#define __SCONNECT_SPFUNC_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "spvector.h"
#include "spchar.h"
#include "splang.h"
#include "spbrace.h"
#include "splist.h"
#include "spnamed.h"
#include <string.h>

class SCONNECT_LIB_EXTERN CSPfunction : public CSPlanguage  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSPfunction();
	//Copy constructor: copy appropriate data members
	CSPfunction(const CSPfunction& sObject);
	//Construct from object of a base class
	CSPfunction(const CSPobject& sObject);
	//Construct from a valid S-expression: for example: function(x){x*x}
	explicit CSPfunction(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSPfunction(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSPfunction& operator=(const CSPfunction& sObject);
	//Assign from the base class
	CSPfunction& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSPfunction& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSPfunction();

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
  //Return TRUE if the object is a valid numeric class
	virtual BOOL IsValid(void) const;
	//If not valid object, throw execption
	void Validate(void) const;
	//Attach an S object and coerce to appropriate class that override this method
	virtual void Attach(s_object *ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Return the names of the formal arguments of a function definition, as a character vector
	CSPcharacter GetArgNames(BOOL bValidate=TRUE) const;
	inline CSPcharacter functionArgNames(BOOL bValidate=TRUE) const {return GetArgNames(bValidate);}
	//Return an object of (extended) class 'language' representing the body of function 
	virtual CSPbrace GetBody(BOOL bValidate=TRUE) const;
	inline CSPbrace functionBody(BOOL bValidate=TRUE) const { return GetBody(bValidate); }

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
public:
	virtual CSPobject Eval(long lFrame) const     //Eval in lFrame 
	{
		return CSPlanguage::Eval(lFrame);
	}
	virtual CSPobject Eval(const CSPnamed& sArgs) const              //Eval in current eval frame
	{
		return CSPlanguage::Eval(sArgs);
	}
	virtual CSPobject Eval(const CSPnamed& sArgs, long lFrame) const//Eval in current eval frame
	{
		return CSPlanguage::Eval(sArgs, lFrame);
	}
	//Evalute the S-function without any arg.
	CSPobject Eval(void) const;
	//Evalute the S-function with a CSPlist or CSPlistNamed, 'named' of mode S_MODE_LIST, argument
	CSPobject Eval(const CSPlist& slistArgs) const;
	CSPobject Eval(const CSPlistNamed& slistNamedArgs) const
	{
		return Eval(CSPlist(slistNamedArgs));
	}
	//Evaluate the S-funciton call with its 1st, 2nd, ... arguments specified by the input parameter, sArg1, sArg2, ...
	CSPobject Eval(s_object* ps_1,       s_object*  ps_2=NULL, s_object*   ps_3=NULL, s_object*  ps_4=NULL, s_object*  ps_5=NULL,
                 s_object*  ps_6=NULL, s_object*  ps_7=NULL, s_object*   ps_8=NULL, s_object*  ps_9=NULL, s_object* ps_10=NULL,
                 s_object* ps_11=NULL, s_object* ps_12=NULL, s_object*  ps_13=NULL, s_object* ps_14=NULL, s_object* ps_15=NULL,
                 s_object* ps_16=NULL, s_object* ps_17=NULL, s_object*  ps_18=NULL, s_object* ps_19=NULL, s_object* ps_20=NULL,
                 s_object* ps_21=NULL, s_object* ps_22=NULL, s_object*  ps_23=NULL, s_object* ps_24=NULL, s_object* ps_25=NULL,
                 s_object* ps_26=NULL, s_object* ps_27=NULL, s_object*  ps_28=NULL, s_object* ps_29=NULL, s_object* ps_30=NULL,
								 s_object* ps_31=NULL) const;
	inline CSPobject operator()(void) const
	{ 
		return Eval();
	}
	inline CSPobject operator()(const CSPlist& slistArgs) const
	{ 
		return Eval(slistArgs);
	}
	inline CSPobject operator()(const CSPlistNamed& slistNamedArgs) const
	{ 
		return Eval(slistNamedArgs);
	}
	inline CSPobject operator()
								(s_object* ps_1,       s_object*  ps_2=NULL, s_object*   ps_3=NULL, s_object*  ps_4=NULL, s_object*  ps_5=NULL,
                 s_object*  ps_6=NULL, s_object*  ps_7=NULL, s_object*   ps_8=NULL, s_object*  ps_9=NULL, s_object* ps_10=NULL,
                 s_object* ps_11=NULL, s_object* ps_12=NULL, s_object*  ps_13=NULL, s_object* ps_14=NULL, s_object* ps_15=NULL,
                 s_object* ps_16=NULL, s_object* ps_17=NULL, s_object*  ps_18=NULL, s_object* ps_19=NULL, s_object* ps_20=NULL,
                 s_object* ps_21=NULL, s_object* ps_22=NULL, s_object*  ps_23=NULL, s_object* ps_24=NULL, s_object* ps_25=NULL,
                 s_object* ps_26=NULL, s_object* ps_27=NULL, s_object*  ps_28=NULL, s_object* ps_29=NULL, s_object* ps_30=NULL,
								 s_object* ps_31=NULL) const
	{
		return Eval(ps_1,   ps_2,   ps_3,   ps_4,   ps_5,
                ps_6,   ps_7,   ps_8,   ps_9,  ps_10,
                ps_11, ps_12,  ps_13,  ps_14,  ps_15,
                ps_16, ps_17,  ps_18,  ps_19,  ps_20,
                ps_21, ps_22,  ps_23,  ps_24,  ps_25,
                ps_26, ps_27,  ps_28,  ps_29,  ps_30,
								ps_31);	
	}

	inline CSPobject Eval(const CSPobject& sArg1) const
	{ return Eval(&sArg1); }
	inline CSPobject operator()(const CSPobject& sArg1) const
	{ return Eval(&sArg1); }
	inline CSPobject Eval(const CSPobject& sArg1, const CSPobject& sArg2) const
	{ return Eval(&sArg1, &sArg2); }
	inline CSPobject operator()(const CSPobject& sArg1, const CSPobject& sArg2) const
	{ return Eval(&sArg1, &sArg2); }
	inline CSPobject Eval(const CSPobject& sArg1, const CSPobject& sArg2, const CSPobject& sArg3) const
	{ return Eval(&sArg1, &sArg2, &sArg3); }
	inline CSPobject operator()(const CSPobject& sArg1, const CSPobject& sArg2, const CSPobject& sArg3) const
	{ return Eval(&sArg1, &sArg2, &sArg3); }
	inline CSPobject Eval(const CSPobject& sArg1, const CSPobject& sArg2, const CSPobject& sArg3, const CSPobject& sArg4) const
	{ return Eval(&sArg1, &sArg2, &sArg3, &sArg4); }
	inline CSPobject operator()(const CSPobject& sArg1, const CSPobject& sArg2, const CSPobject& sArg3, const CSPobject& sArg4) const
	{ return Eval(&sArg1, &sArg2, &sArg3, &sArg4); }

};


#endif // !defined(__SCONNECT_SPFUNC_H_INCLUDED__)

