/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

// SPint.cxx: implementation of the CSPinteger class.
//
//////////////////////////////////////////////////////////////////////
#include <memory.h>
#include "spint.h"
#include "speval.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//////////////////////// CSPinteger ////////////////////////

//Default constructor
CSPinteger::CSPinteger()
: TSPvector<long, S_MODE_INT>()
{
}
//Copy constructor 
CSPinteger::CSPinteger(const CSPinteger& sObject)
: TSPvector<long, S_MODE_INT>()
{
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
}
//Construct from a base class object
CSPinteger::CSPinteger(const CSPobject& sObject)
: TSPvector<long, S_MODE_INT>()
{	
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
}
//Construct from a valid S-expression
CSPinteger::CSPinteger(const char* pszExpression)
: TSPvector<long, S_MODE_INT>(pszExpression)
{
}
//Construct from a valid S object
CSPinteger::CSPinteger(s_object* ps_object, BOOL bTryToFreeOnDetach)
: TSPvector<long, S_MODE_INT>()
{
	Attach(ps_object, bTryToFreeOnDetach);
}
//Assigment from the same class
CSPinteger& CSPinteger::operator=(const CSPinteger& sObject)
{
	Attach(&sObject, TRUE);
	return *this;
}
//Assigment from the base class
CSPinteger& CSPinteger::operator=(const CSPobject& sObject)
{
	Attach(&sObject, TRUE);
	return *this;
}
//Assigment from the S object
CSPinteger& CSPinteger::operator=(s_object* ps_object)
{
	Attach(ps_object, FALSE);
	return *this;
}
//The destructor
CSPinteger::~CSPinteger()
{
}
//////////////////// Other constructor/destructor and assignment operators

//Construct a 'integer' vector of length nLength
CSPinteger::CSPinteger(long lLength)
: TSPvector<long, S_MODE_INT>( lLength)
{
}
CSPinteger::CSPinteger(int nLength)
: TSPvector<long, S_MODE_INT>( (long) nLength)
{
}
CSPinteger::CSPinteger(long* plValues, long lLength)
: TSPvector<long, S_MODE_INT>( lLength)
{
	SetAtDirect(plValues, 0L, lLength-1, FALSE);
}

CSPinteger::CSPinteger(long* plValues, int nLength)
: TSPvector<long, S_MODE_INT>( (long) nLength)
{
	SetAtDirect(plValues, 0L, (long)(nLength-1), FALSE);
}

CSPinteger::CSPinteger(int* pnValues, long lLength)
: TSPvector<long, S_MODE_INT>( lLength)
{
	SetAtDirect(pnValues, 0L, lLength-1, FALSE);
}

CSPinteger::CSPinteger(int* pnValues, int nLength)
: TSPvector<long, S_MODE_INT>( (long) nLength)
{
	SetAtDirect(pnValues, 0L, (long)(nLength-1), FALSE);
}

CSPinteger& CSPinteger::operator = (const long lRhs)
{
	DecrRef();
	Attach(NewMyType(1));
	(*this)->value.Long[0] = lRhs;
	return *this;
}

CSPinteger& CSPinteger::operator =(const CSPinteger::CProxy& proxyRhs)
{
	long element = (long) proxyRhs.m_vector.GetAt(proxyRhs.m_lIndex);
	s_object* ps_object = NewMyType(1L);
	MyTypeValue(ps_object, 0) = element;
	ReAttachAndAssign(ps_object);
	return *this;
}

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////

//Direct access to elements of character vector (ZERO-BASED INDEX). Use it carefully!
void CSPinteger::SetAtDirect(long lIndex, long lElement, BOOL bValidate)
{
	if(bValidate && (!IsValid()) || (lIndex >= GetLength(FALSE)))
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);  

	//Warning: no ref-count check.
	INTEGER_POINTER(GetPtr())[lIndex] = lElement; 
}

//Direct access to elements of character vector (ZERO-BASED INDEX). Use it carefully!
void CSPinteger::SetAtDirect(long* plValues, long lStartIndex, long lEndIndex, BOOL bValidate)
{
	if(bValidate  
	&& (!IsValid() || (lStartIndex > lEndIndex)
	    || (lStartIndex >= GetLength(FALSE)) || (lEndIndex >= GetLength(FALSE)))
	)
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);  

	if(plValues != NULL)
	{
		long j=0;

		for(long n=lStartIndex; n<= lEndIndex; n++)
			INTEGER_POINTER(GetPtr())[n] = plValues[j++]; //pValues[j] better be valid!
	}
}

//Direct access to elements of character vector (ZERO-BASED INDEX). Use it carefully!
void CSPinteger::SetAtDirect(int* pnValues, long lStartIndex, long lEndIndex, BOOL bValidate)
{
	if(bValidate  
	&& (!IsValid() || (lStartIndex > lEndIndex)
	    || (lStartIndex >= GetLength(FALSE)) || (lEndIndex >= GetLength(FALSE)))
	)
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);  

	if(pnValues != NULL)
	{
		long j=0;

		for(long n=lStartIndex; n<= lEndIndex; n++)
			INTEGER_POINTER(GetPtr())[n] = (long)pnValues[j++]; //pValues[j] better be valid!
	}
}

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
/*
const CSPinteger CSPinteger::BinaryOp( const CSPinteger& sRhs, long lBinOp) const
{
	s_object* ps_lhs=NULL;
	s_object* ps_rhs=NULL;

	if(!IsValid() || !sRhs.IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	//Clone the longer one and add to the shorter one
	ps_lhs = this->Clone();
	ps_rhs = sRhs.GetPtr();

	long lIndex = (this->GetLength() < sRhs.GetLength())? this->GetLength(): sRhs.GetLength();
	
	switch(lBinOp)
	{
		case S_BINOP_PLUS:
			while(--lIndex >= 0)
				INTEGER_POINTER(ps_lhs)[lIndex] += INTEGER_POINTER(ps_rhs)[lIndex];
			break;
		case S_BINOP_MINUS:
			while(--lIndex >= 0)
				INTEGER_POINTER(ps_lhs)[lIndex] -= INTEGER_POINTER(ps_rhs)[lIndex];
			break;
		case S_BINOP_MULTIPLY:
			while(--lIndex >= 0)
				INTEGER_POINTER(ps_lhs)[lIndex] *= INTEGER_POINTER(ps_rhs)[lIndex];
			break;
		case S_BINOP_DIVIDE:
			while(--lIndex >= 0)
				INTEGER_POINTER(ps_lhs)[lIndex] /= INTEGER_POINTER(ps_rhs)[lIndex];
			break;
		default:
			SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);
			break;
	}

	return CSPinteger(ps_lhs);
}
*/

CSPinteger CSPinteger::abs(BOOL bValidate) const
{

	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	s_object* ps_lhs = this->Clone();
	long* x = INTEGER_POINTER(ps_lhs);
	for(long n=0; n< length(FALSE); n++)
			    x[n] = x[n]>=0 ? x[n] : -x[n];
	return CSPinteger(ps_lhs);
			
}

long CSPinteger::Max(BOOL bValidate) const
{
	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	long* x = INTEGER_POINTER(this->GetPtr());
	long lMax= x[0];
	for(long n=0; n< length(FALSE); n++)
	{
		if(lMax < x[n])
			lMax = x[n];
	}

	return lMax;
}

long CSPinteger::Min(BOOL bValidate) const
{
	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	long* x = INTEGER_POINTER(this->GetPtr());
	long lMax= x[0];
	for(long n=0; n< length(FALSE); n++)
	{
		if(lMax > x[n])
			lMax = x[n];
	}

	return lMax;
}

//////////////////////////////////////////////////////
// Proxy implementation
CSPinteger::CProxy::CProxy(CSPinteger& sVector, long lZeroBasedIndex)
:TSPvector<long, S_MODE_INT>::CSPvectorProxy(sVector, lZeroBasedIndex)
{
}		
CSPinteger::CProxy::CProxy(const CProxy& proxyRhs)
:TSPvector<long, S_MODE_INT>::CSPvectorProxy(proxyRhs.m_vector, proxyRhs.m_lIndex)
{
}		
CSPinteger::CProxy& CSPinteger::CProxy::operator =(const CProxy& proxyRhs)
{
	long element = (long) proxyRhs.m_vector.GetAt(proxyRhs.m_lIndex);
	m_vector.SetAt(m_lIndex, element, FALSE);
	return *this;
}
CSPinteger::CProxy& CSPinteger::CProxy::operator =(const long& rhs)
{
	m_vector.SetAt(m_lIndex, rhs, FALSE);
	return *this;
}
CSPinteger::CProxy& CSPinteger::CProxy::operator+=(const long& rhs)
{
	long element = m_vector.GetAt(m_lIndex);
	element += rhs;
	m_vector.SetAt(m_lIndex, element, FALSE);
	return *this;
}
CSPinteger::CProxy& CSPinteger::CProxy::operator-=(const long& rhs)
{
	long element = m_vector.GetAt(m_lIndex);
	element -= rhs;
	m_vector.SetAt(m_lIndex, element, FALSE);
	return *this;
}
CSPinteger::CProxy& CSPinteger::CProxy::operator*=(const long& rhs)
{
	long element = m_vector.GetAt(m_lIndex);
	element *= rhs;
	m_vector.SetAt(m_lIndex, element, FALSE);
	return *this;
}
CSPinteger::CProxy& CSPinteger::CProxy::operator/=(const long& rhs)
{
	long element = m_vector.GetAt(m_lIndex);
	element /= rhs;
	m_vector.SetAt(m_lIndex, element, FALSE);
	return *this;
}
