/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class BasicDynaBean
implements DynaBean,
Serializable {
    protected DynaClass dynaClass = null;
    protected HashMap values = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public BasicDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass;
    }

    public boolean contains(String name, String key) {
        Object value = this.values.get(name);
        if (value == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (value instanceof Map) {
            return ((Map)value).containsKey(key);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
    }

    public Object get(String name) {
        Object value = this.values.get(name);
        if (value != null) {
            return value;
        }
        Class type = this.getDynaProperty(name).getType();
        if (!type.isPrimitive()) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            return new Byte(0);
        }
        if (type == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type == Double.TYPE) {
            return new Double(0.0);
        }
        if (type == Float.TYPE) {
            return new Float(0.0f);
        }
        if (type == Integer.TYPE) {
            return new Integer(0);
        }
        if (type == Long.TYPE) {
            return new Long(0L);
        }
        if (type == Short.TYPE) {
            return new Short(0);
        }
        return null;
    }

    public Object get(String name, int index) {
        Object value = this.values.get(name);
        if (value == null) {
            throw new NullPointerException("No indexed value for '" + name + "[" + index + "]'");
        }
        if (value.getClass().isArray()) {
            return Array.get(value, index);
        }
        if (value instanceof List) {
            return ((List)value).get(index);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]'");
    }

    public Object get(String name, String key) {
        Object value = this.values.get(name);
        if (value == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (value instanceof Map) {
            return ((Map)value).get(key);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public void remove(String name, String key) {
        Object value = this.values.get(name);
        if (value == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
        }
        ((Map)value).remove(key);
    }

    public void set(String name, Object value) {
        DynaProperty descriptor = this.getDynaProperty(name);
        if (value == null) {
            if (descriptor.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + name + "'");
            }
        } else if (!this.isAssignable(descriptor.getType(), value.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + name + "' of type '" + descriptor.getType().getName() + "'");
        }
        this.values.put(name, value);
    }

    public void set(String name, int index, Object value) {
        Object prop = this.values.get(name);
        if (prop == null) {
            throw new NullPointerException("No indexed value for '" + name + "[" + index + "]'");
        }
        if (prop.getClass().isArray()) {
            Array.set(prop, index, value);
        } else if (prop instanceof List) {
            try {
                ((List)prop).set(index, value);
            }
            catch (ClassCastException e) {
                throw new ConversionException(e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]'");
        }
    }

    public void set(String name, String key, Object value) {
        Object prop = this.values.get(name);
        if (prop == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (!(prop instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
        }
        ((Map)prop).put(key, value);
    }

    protected DynaProperty getDynaProperty(String name) {
        DynaProperty descriptor = this.getDynaClass().getDynaProperty(name);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid property name '" + name + "'");
        }
        return descriptor;
    }

    protected boolean isAssignable(Class dest, Class source) {
        block43: {
            block35: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            if (dest.isAssignableFrom(source)) break block35;
                                            if (dest != Boolean.TYPE) break block36;
                                            Class<?> clazz = class$0;
                                            if (clazz == null) {
                                                try {
                                                    clazz = class$0 = Class.forName("java.lang.Boolean");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (source == clazz) break block35;
                                        }
                                        if (dest != Byte.TYPE) break block37;
                                        Class<?> clazz = class$1;
                                        if (clazz == null) {
                                            try {
                                                clazz = class$1 = Class.forName("java.lang.Byte");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (source == clazz) break block35;
                                    }
                                    if (dest != Character.TYPE) break block38;
                                    Class<?> clazz = class$2;
                                    if (clazz == null) {
                                        try {
                                            clazz = class$2 = Class.forName("java.lang.Character");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (source == clazz) break block35;
                                }
                                if (dest != Double.TYPE) break block39;
                                Class<?> clazz = class$3;
                                if (clazz == null) {
                                    try {
                                        clazz = class$3 = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (source == clazz) break block35;
                            }
                            if (dest != Float.TYPE) break block40;
                            Class<?> clazz = class$4;
                            if (clazz == null) {
                                try {
                                    clazz = class$4 = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (source == clazz) break block35;
                        }
                        if (dest != Integer.TYPE) break block41;
                        Class<?> clazz = class$5;
                        if (clazz == null) {
                            try {
                                clazz = class$5 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (source == clazz) break block35;
                    }
                    if (dest != Long.TYPE) break block42;
                    Class<?> clazz = class$6;
                    if (clazz == null) {
                        try {
                            clazz = class$6 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (source == clazz) break block35;
                }
                if (dest != Short.TYPE) break block43;
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (source != clazz) break block43;
            }
            return true;
        }
        return false;
    }
}

