/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaClass;
import org.apache.commons.beanutils.MutableDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyDynaBean
implements DynaBean,
Serializable {
    private static Log logger;
    protected static final BigInteger BigInteger_ZERO;
    protected static final BigDecimal BigDecimal_ZERO;
    protected static final Character Character_SPACE;
    protected static final Byte Byte_ZERO;
    protected static final Short Short_ZERO;
    protected static final Integer Integer_ZERO;
    protected static final Long Long_ZERO;
    protected static final Float Float_ZERO;
    protected static final Double Double_ZERO;
    protected Map values = this.newMap();
    protected MutableDynaClass dynaClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.beanutils.LazyDynaBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog(clazz);
        BigInteger_ZERO = new BigInteger("0");
        BigDecimal_ZERO = new BigDecimal("0");
        Character_SPACE = new Character(' ');
        Byte_ZERO = new Byte(0);
        Short_ZERO = new Short(0);
        Integer_ZERO = new Integer(0);
        Long_ZERO = new Long(0L);
        Float_ZERO = new Float(0.0f);
        Double_ZERO = new Double(0.0);
    }

    public LazyDynaBean() {
        this(new LazyDynaClass());
    }

    public LazyDynaBean(String name) {
        this(new LazyDynaClass(name));
    }

    public LazyDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass instanceof MutableDynaClass ? (MutableDynaClass)dynaClass : new LazyDynaClass(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public Map getMap() {
        return this.values;
    }

    public int size(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Map) {
            return ((Map)value).size();
        }
        if (value instanceof List) {
            return ((List)value).size();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 0;
    }

    public boolean contains(String name, String key) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name);
        if (value == null) {
            return false;
        }
        if (value instanceof Map) {
            return ((Map)value).containsKey(key);
        }
        return false;
    }

    public Object get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name);
        if (value != null) {
            return value;
        }
        if (!this.isDynaProperty(name)) {
            return null;
        }
        value = this.createProperty(name, this.dynaClass.getDynaProperty(name).getType());
        if (value != null) {
            this.set(name, value);
        }
        return value;
    }

    public Object get(String name, int index) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultIndexedProperty(name));
        }
        Object indexedProperty = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]' " + this.dynaClass.getDynaProperty(name).getName());
        }
        if ((indexedProperty = this.growIndexedProperty(name, indexedProperty, index)).getClass().isArray()) {
            return Array.get(indexedProperty, index);
        }
        if (indexedProperty instanceof List) {
            return ((List)indexedProperty).get(index);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]' " + indexedProperty.getClass().getName());
    }

    public Object get(String name, String key) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultMappedProperty(name));
        }
        Object mappedProperty = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")' " + this.dynaClass.getDynaProperty(name).getType().getName());
        }
        if (mappedProperty instanceof Map) {
            return ((Map)mappedProperty).get(key);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'" + mappedProperty.getClass().getName());
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public void remove(String name, String key) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'" + value.getClass().getName());
        }
        ((Map)value).remove(key);
    }

    public void set(String name, Object value) {
        if (!this.isDynaProperty(name)) {
            if (this.dynaClass.isRestricted()) {
                throw new IllegalArgumentException("Invalid property name '" + name + "' (DynaClass is restricted)");
            }
            if (value == null) {
                this.dynaClass.add(name);
            } else {
                this.dynaClass.add(name, value.getClass());
            }
        }
        DynaProperty descriptor = this.dynaClass.getDynaProperty(name);
        if (value == null) {
            if (descriptor.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + name + "'");
            }
        } else if (!this.isAssignable(descriptor.getType(), value.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + name + "' of type '" + descriptor.getType().getName() + "'");
        }
        this.values.put(name, value);
    }

    public void set(String name, int index, Object value) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultIndexedProperty(name));
        }
        Object indexedProperty = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]'" + this.dynaClass.getDynaProperty(name).getType().getName());
        }
        if ((indexedProperty = this.growIndexedProperty(name, indexedProperty, index)).getClass().isArray()) {
            Array.set(indexedProperty, index, value);
        } else if (indexedProperty instanceof List) {
            ((List)indexedProperty).set(index, value);
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]' " + indexedProperty.getClass().getName());
        }
    }

    public void set(String name, String key, Object value) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultMappedProperty(name));
        }
        Object mappedProperty = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'" + this.dynaClass.getDynaProperty(name).getType().getName());
        }
        ((Map)mappedProperty).put(key, value);
    }

    protected Object growIndexedProperty(String name, Object indexedProperty, int index) {
        int length;
        if (indexedProperty instanceof List) {
            List list = (List)indexedProperty;
            while (index >= list.size()) {
                list.add(null);
            }
        }
        if (indexedProperty.getClass().isArray() && index >= (length = Array.getLength(indexedProperty))) {
            Class<?> componentType = indexedProperty.getClass().getComponentType();
            Object newArray = Array.newInstance(componentType, index + 1);
            System.arraycopy(indexedProperty, 0, newArray, 0, length);
            indexedProperty = newArray;
            this.set(name, indexedProperty);
            int newLength = Array.getLength(indexedProperty);
            int i = length;
            while (i < newLength) {
                Array.set(indexedProperty, i, this.createProperty(String.valueOf(name) + "[" + i + "]", componentType));
                ++i;
            }
        }
        return indexedProperty;
    }

    protected Object createProperty(String name, Class type) {
        block24: {
            block23: {
                if (type.isArray()) break block23;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.util.List");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(type)) break block24;
            }
            return this.createIndexedProperty(name, type);
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(type)) {
            return this.createMappedProperty(name, type);
        }
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.apache.commons.beanutils.DynaBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(type)) {
            return this.createDynaBeanProperty(name, type);
        }
        if (type.isPrimitive()) {
            return this.createPrimitiveProperty(name, type);
        }
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(type)) {
            return this.createNumberProperty(name, type);
        }
        return this.createOtherProperty(name, type);
    }

    protected Object createIndexedProperty(String name, Class type) {
        Object indexedProperty = null;
        if (type == null) {
            indexedProperty = this.defaultIndexedProperty(name);
        } else if (type.isArray()) {
            indexedProperty = Array.newInstance(type.getComponentType(), 0);
        } else {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.util.List");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(type)) {
                if (type.isInterface()) {
                    indexedProperty = this.defaultIndexedProperty(name);
                } else {
                    try {
                        indexedProperty = type.newInstance();
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Error instantiating indexed property of type '" + type.getName() + "' for '" + name + "' " + ex);
                    }
                }
            } else {
                throw new IllegalArgumentException("Non-indexed property of type '" + type.getName() + "' for '" + name + "'");
            }
        }
        return indexedProperty;
    }

    protected Object createMappedProperty(String name, Class type) {
        Map mappedProperty = null;
        if (type == null) {
            mappedProperty = this.defaultMappedProperty(name);
        } else if (type.isInterface()) {
            mappedProperty = this.defaultMappedProperty(name);
        } else {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(type)) {
                try {
                    mappedProperty = type.newInstance();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Error instantiating mapped property of type '" + type.getName() + "' for '" + name + "' " + ex);
                }
            } else {
                throw new IllegalArgumentException("Non-mapped property of type '" + type.getName() + "' for '" + name + "'");
            }
        }
        return mappedProperty;
    }

    protected Object createDynaBeanProperty(String name, Class type) {
        try {
            return type.newInstance();
        }
        catch (Exception ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("Error instantiating DynaBean property of type '" + type.getName() + "' for '" + name + "' " + ex);
            }
            return null;
        }
    }

    protected Object createPrimitiveProperty(String name, Class type) {
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Integer.TYPE) {
            return Integer_ZERO;
        }
        if (type == Long.TYPE) {
            return Long_ZERO;
        }
        if (type == Double.TYPE) {
            return Double_ZERO;
        }
        if (type == Float.TYPE) {
            return Float_ZERO;
        }
        if (type == Byte.TYPE) {
            return Byte_ZERO;
        }
        if (type == Short.TYPE) {
            return Short_ZERO;
        }
        if (type == Character.TYPE) {
            return Character_SPACE;
        }
        return null;
    }

    protected Object createNumberProperty(String name, Class type) {
        return null;
    }

    protected Object createOtherProperty(String name, Class type) {
        block23: {
            block22: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz) break block22;
                Class<?> clazz2 = class$6;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$6 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz2) break block22;
                Class<?> clazz3 = class$7;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$7 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz3) break block22;
                Class<?> clazz4 = class$8;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$8 = Class.forName("java.util.Date");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz4.isAssignableFrom(type)) break block23;
            }
            return null;
        }
        try {
            return type.newInstance();
        }
        catch (Exception ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("Error instantiating property of type '" + type.getName() + "' for '" + name + "' " + ex);
            }
            return null;
        }
    }

    protected Object defaultIndexedProperty(String name) {
        return new ArrayList();
    }

    protected Map defaultMappedProperty(String name) {
        return new HashMap();
    }

    protected boolean isDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        if (this.dynaClass instanceof LazyDynaClass) {
            return ((LazyDynaClass)this.dynaClass).isDynaProperty(name);
        }
        return this.dynaClass.getDynaProperty(name) != null;
    }

    protected boolean isAssignable(Class dest, Class source) {
        block43: {
            block35: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            if (dest.isAssignableFrom(source)) break block35;
                                            if (dest != Boolean.TYPE) break block36;
                                            Class<?> clazz = class$6;
                                            if (clazz == null) {
                                                try {
                                                    clazz = class$6 = Class.forName("java.lang.Boolean");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (source == clazz) break block35;
                                        }
                                        if (dest != Byte.TYPE) break block37;
                                        Class<?> clazz = class$9;
                                        if (clazz == null) {
                                            try {
                                                clazz = class$9 = Class.forName("java.lang.Byte");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (source == clazz) break block35;
                                    }
                                    if (dest != Character.TYPE) break block38;
                                    Class<?> clazz = class$7;
                                    if (clazz == null) {
                                        try {
                                            clazz = class$7 = Class.forName("java.lang.Character");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (source == clazz) break block35;
                                }
                                if (dest != Double.TYPE) break block39;
                                Class<?> clazz = class$10;
                                if (clazz == null) {
                                    try {
                                        clazz = class$10 = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (source == clazz) break block35;
                            }
                            if (dest != Float.TYPE) break block40;
                            Class<?> clazz = class$11;
                            if (clazz == null) {
                                try {
                                    clazz = class$11 = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (source == clazz) break block35;
                        }
                        if (dest != Integer.TYPE) break block41;
                        Class<?> clazz = class$12;
                        if (clazz == null) {
                            try {
                                clazz = class$12 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (source == clazz) break block35;
                    }
                    if (dest != Long.TYPE) break block42;
                    Class<?> clazz = class$13;
                    if (clazz == null) {
                        try {
                            clazz = class$13 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (source == clazz) break block35;
                }
                if (dest != Short.TYPE) break block43;
                Class<?> clazz = class$14;
                if (clazz == null) {
                    try {
                        clazz = class$14 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (source != clazz) break block43;
            }
            return true;
        }
        return false;
    }

    protected Map newMap() {
        return new HashMap();
    }
}

