/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.lang.reflect.Array;
import java.util.Locale;
import org.apache.commons.beanutils.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimeLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimestampLocaleConverter;
import org.apache.commons.beanutils.locale.converters.StringLocaleConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleConvertUtilsBean {
    private Locale defaultLocale = Locale.getDefault();
    private boolean applyLocalized = false;
    private Log log;
    private FastHashMap mapConverters;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public static LocaleConvertUtilsBean getInstance() {
        return LocaleBeanUtilsBean.getLocaleBeanUtilsInstance().getLocaleConvertUtils();
    }

    public LocaleConvertUtilsBean() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.beanutils.locale.LocaleConvertUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog(clazz);
        this.mapConverters = new FastHashMap();
        this.deregister();
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale == null ? Locale.getDefault() : locale;
    }

    public boolean getApplyLocalized() {
        return this.applyLocalized;
    }

    public void setApplyLocalized(boolean newApplyLocalized) {
        this.applyLocalized = newApplyLocalized;
    }

    public String convert(Object value) {
        return this.convert(value, this.defaultLocale, null);
    }

    public String convert(Object value, String pattern) {
        return this.convert(value, this.defaultLocale, pattern);
    }

    public String convert(Object value, Locale locale, String pattern) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LocaleConverter converter = this.lookup(clazz, locale);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (String)converter.convert(clazz2, value, pattern);
    }

    public Object convert(String value, Class clazz) {
        return this.convert(value, clazz, this.defaultLocale, null);
    }

    public Object convert(String value, Class clazz, String pattern) {
        return this.convert(value, clazz, this.defaultLocale, pattern);
    }

    public Object convert(String value, Class clazz, Locale locale, String pattern) {
        LocaleConverter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert string " + value + " to class " + clazz.getName() + " using " + locale.toString() + " locale and " + pattern + " pattern");
        }
        if ((converter = this.lookup(clazz, locale)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            converter = this.lookup(clazz2, locale);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        return converter.convert(clazz, value, pattern);
    }

    public Object convert(String[] values, Class clazz, String pattern) {
        return this.convert(values, clazz, this.getDefaultLocale(), pattern);
    }

    public Object convert(String[] values, Class clazz) {
        return this.convert(values, clazz, this.getDefaultLocale(), null);
    }

    public Object convert(String[] values, Class clazz, Locale locale, String pattern) {
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert String[" + values.length + "] to class " + type.getName() + "[] using " + locale.toString() + " locale and " + pattern + " pattern");
        }
        Object array = Array.newInstance(type, values.length);
        int i = 0;
        while (i < values.length) {
            Array.set(array, i, this.convert(values[i], type, locale, pattern));
            ++i;
        }
        return array;
    }

    public void register(LocaleConverter converter, Class clazz, Locale locale) {
        this.lookup(locale).put(clazz, converter);
    }

    public void deregister() {
        FastHashMap defaultConverter = this.lookup(this.defaultLocale);
        this.mapConverters.setFast(false);
        this.mapConverters.clear();
        this.mapConverters.put(this.defaultLocale, defaultConverter);
        this.mapConverters.setFast(true);
    }

    public void deregister(Locale locale) {
        this.mapConverters.remove(locale);
    }

    public void deregister(Class clazz, Locale locale) {
        this.lookup(locale).remove(clazz);
    }

    public LocaleConverter lookup(Class clazz, Locale locale) {
        LocaleConverter converter = (LocaleConverter)this.lookup(locale).get(clazz);
        if (this.log.isTraceEnabled()) {
            this.log.trace("LocaleConverter:" + converter);
        }
        return converter;
    }

    protected FastHashMap lookup(Locale locale) {
        FastHashMap localeConverters;
        if (locale == null) {
            localeConverters = (FastHashMap)this.mapConverters.get(this.defaultLocale);
        } else {
            localeConverters = (FastHashMap)this.mapConverters.get(locale);
            if (localeConverters == null) {
                localeConverters = this.create(locale);
                this.mapConverters.put(locale, localeConverters);
            }
        }
        return localeConverters;
    }

    protected FastHashMap create(Locale locale) {
        FastHashMap converter = new FastHashMap();
        converter.setFast(false);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz, new BigDecimalLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz2, new BigIntegerLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz3, new ByteLocaleConverter(locale, this.applyLocalized));
        converter.put(Byte.TYPE, new ByteLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz4, new DoubleLocaleConverter(locale, this.applyLocalized));
        converter.put(Double.TYPE, new DoubleLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz5 = class$6;
        if (clazz5 == null) {
            try {
                clazz5 = class$6 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz5, new FloatLocaleConverter(locale, this.applyLocalized));
        converter.put(Float.TYPE, new FloatLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz6 = class$7;
        if (clazz6 == null) {
            try {
                clazz6 = class$7 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz6, new IntegerLocaleConverter(locale, this.applyLocalized));
        converter.put(Integer.TYPE, new IntegerLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz7 = class$8;
        if (clazz7 == null) {
            try {
                clazz7 = class$8 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz7, new LongLocaleConverter(locale, this.applyLocalized));
        converter.put(Long.TYPE, new LongLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz8 = class$9;
        if (clazz8 == null) {
            try {
                clazz8 = class$9 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz8, new ShortLocaleConverter(locale, this.applyLocalized));
        converter.put(Short.TYPE, new ShortLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz9 = class$1;
        if (clazz9 == null) {
            try {
                clazz9 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz9, new StringLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz10 = class$10;
        if (clazz10 == null) {
            try {
                clazz10 = class$10 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz10, new SqlDateLocaleConverter(locale, "yyyy-MM-dd"));
        Class<?> clazz11 = class$11;
        if (clazz11 == null) {
            try {
                clazz11 = class$11 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz11, new SqlTimeLocaleConverter(locale, "HH:mm:ss"));
        Class<?> clazz12 = class$12;
        if (clazz12 == null) {
            try {
                clazz12 = class$12 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        converter.put(clazz12, new SqlTimestampLocaleConverter(locale, "yyyy-MM-dd HH:mm:ss.S"));
        converter.setFast(true);
        return converter;
    }
}

