/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CallMethodRule
extends Rule {
    protected String bodyText = null;
    private int targetOffset = 0;
    protected String methodName = null;
    protected int paramCount = 0;
    protected Class[] paramTypes = null;
    private String[] paramClassNames = null;
    protected boolean useExactMatch = false;
    static /* synthetic */ Class class$0;

    public CallMethodRule(Digester digester, String methodName, int paramCount) {
        this(methodName, paramCount);
    }

    public CallMethodRule(Digester digester, String methodName, int paramCount, String[] paramTypes) {
        this(methodName, paramCount, paramTypes);
    }

    public CallMethodRule(Digester digester, String methodName, int paramCount, Class[] paramTypes) {
        this(methodName, paramCount, paramTypes);
    }

    public CallMethodRule(String methodName, int paramCount) {
        this(0, methodName, paramCount);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramCount == 0) {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            this.paramTypes = classArray;
        } else {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.paramTypes[i] = clazz;
                ++i;
            }
        }
    }

    public CallMethodRule(String methodName) {
        this(0, methodName, 0, (Class[])null);
    }

    public CallMethodRule(int targetOffset, String methodName) {
        this(targetOffset, methodName, 0, (Class[])null);
    }

    public CallMethodRule(String methodName, int paramCount, String[] paramTypes) {
        this(0, methodName, paramCount, paramTypes);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount, String[] paramTypes) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramClassNames = new String[paramTypes.length];
            int i = 0;
            while (i < this.paramClassNames.length) {
                this.paramClassNames[i] = paramTypes[i];
                ++i;
            }
        }
    }

    public CallMethodRule(String methodName, int paramCount, Class[] paramTypes) {
        this(0, methodName, paramCount, paramTypes);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount, Class[] paramTypes) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramTypes = new Class[paramTypes.length];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = paramTypes[i];
                ++i;
            }
        }
    }

    public boolean getUseExactMatch() {
        return this.useExactMatch;
    }

    public void setUseExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    public void setDigester(Digester digester) {
        super.setDigester(digester);
        if (this.paramClassNames != null) {
            this.paramTypes = new Class[this.paramClassNames.length];
            int i = 0;
            while (i < this.paramClassNames.length) {
                try {
                    this.paramTypes[i] = digester.getClassLoader().loadClass(this.paramClassNames[i]);
                }
                catch (ClassNotFoundException e) {
                    digester.getLogger().error("(CallMethodRule) Cannot load class " + this.paramClassNames[i], e);
                    this.paramTypes[i] = null;
                }
                ++i;
            }
        }
    }

    public void begin(Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            Object[] parameters = new Object[this.paramCount];
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = null;
                ++i;
            }
            this.digester.pushParams(parameters);
        }
    }

    public void body(String bodyText) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = bodyText.trim();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void end() throws Exception {
        parameters = null;
        if (this.paramCount > 0) {
            parameters = (Object[])this.digester.popParams();
            if (this.digester.log.isTraceEnabled()) {
                i = 0;
                size = parameters.length;
                while (i < size) {
                    this.digester.log.trace("[CallMethodRule](" + i + ")" + parameters[i]);
                    ++i;
                }
            }
            if (this.paramCount == 1 && parameters[0] == null) {
                return;
            }
        } else if (this.paramTypes != null && this.paramTypes.length != 0) {
            if (this.bodyText == null) {
                return;
            }
            parameters = new Object[]{this.bodyText};
            if (this.paramTypes.length == 0) {
                this.paramTypes = new Class[1];
                this.paramTypes[0] = "abc".getClass();
            }
        }
        paramValues = new Object[this.paramTypes.length];
        i = 0;
        while (i < this.paramTypes.length) {
            if (parameters[i] == null) ** GOTO lbl-1000
            if (parameters[i] instanceof String) {
                v0 = CallMethodRule.class$0;
                if (v0 == null) {
                    try {
                        v0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                }
                ** if (v0.isAssignableFrom(this.paramTypes[i])) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                paramValues[i] = ConvertUtils.convert((String)parameters[i], this.paramTypes[i]);
                ** GOTO lbl38
            }
lbl-1000:
            // 2 sources

            {
                paramValues[i] = parameters[i];
            }
lbl38:
            // 2 sources

            ++i;
        }
        target = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (target == null) {
            sb = new StringBuffer();
            sb.append("[CallMethodRule]{");
            sb.append(this.digester.match);
            sb.append("} Call target is null (");
            sb.append("targetOffset=");
            sb.append(this.targetOffset);
            sb.append(",stackdepth=");
            sb.append(this.digester.getCount());
            sb.append(")");
            throw new SAXException(sb.toString());
        }
        if (this.digester.log.isDebugEnabled()) {
            sb = new StringBuffer("[CallMethodRule]{");
            sb.append(this.digester.match);
            sb.append("} Call ");
            sb.append(target.getClass().getName());
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            i = 0;
            while (i < paramValues.length) {
                if (i > 0) {
                    sb.append(",");
                }
                if (paramValues[i] == null) {
                    sb.append("null");
                } else {
                    sb.append(paramValues[i].toString());
                }
                sb.append("/");
                if (this.paramTypes[i] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.paramTypes[i].getName());
                }
                ++i;
            }
            sb.append(")");
            this.digester.log.debug(sb.toString());
        }
        result = null;
        result = this.useExactMatch != false ? MethodUtils.invokeExactMethod(target, this.methodName, paramValues, this.paramTypes) : MethodUtils.invokeMethod(target, this.methodName, paramValues, this.paramTypes);
        this.processMethodCallResult(result);
    }

    public void finish() throws Exception {
        this.bodyText = null;
    }

    protected void processMethodCallResult(Object result) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CallMethodRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramCount=");
        sb.append(this.paramCount);
        sb.append(", paramTypes={");
        if (this.paramTypes != null) {
            int i = 0;
            while (i < this.paramTypes.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.paramTypes[i].getName());
                ++i;
            }
        }
        sb.append("}");
        sb.append("]");
        return sb.toString();
    }
}

