/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins.strategies;

import java.lang.reflect.Method;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.plugins.PluginException;
import org.apache.commons.digester.plugins.RuleLoader;
import org.apache.commons.logging.Log;

public class LoaderFromClass
extends RuleLoader {
    private Class rulesClass;
    private Method rulesMethod;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public LoaderFromClass(Class rulesClass, Method rulesMethod) {
        this.rulesClass = rulesClass;
        this.rulesMethod = rulesMethod;
    }

    public LoaderFromClass(Class rulesClass, String methodName) throws PluginException {
        Method method = LoaderFromClass.locateMethod(rulesClass, methodName);
        if (method == null) {
            throw new PluginException("rule class " + rulesClass.getName() + " does not have method " + methodName + " or that method has an invalid signature.");
        }
        this.rulesClass = rulesClass;
        this.rulesMethod = method;
    }

    public void addRules(Digester d, String path) throws PluginException {
        Log log = d.getLogger();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("LoaderFromClass loading rules for plugin at path [" + path + "]");
        }
        try {
            Object[] params = new Object[]{d, path};
            Object none = this.rulesMethod.invoke(null, params);
        }
        catch (Exception e) {
            throw new PluginException("Unable to invoke rules method " + this.rulesMethod + " on rules class " + this.rulesClass, e);
        }
    }

    public static Method locateMethod(Class rulesClass, String methodName) throws PluginException {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.digester.Digester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] paramSpec = classArray;
        Method rulesMethod = MethodUtils.getAccessibleMethod(rulesClass, methodName, paramSpec);
        return rulesMethod;
    }
}

