/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.context;

import com.steadystate.css.parser.CSSOMParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;
import org.xhtmlrenderer.context.CSSPageRuleAdapter;
import org.xhtmlrenderer.css.extend.StylesheetFactory;
import org.xhtmlrenderer.css.sheet.InlineStyleInfo;
import org.xhtmlrenderer.css.sheet.Ruleset;
import org.xhtmlrenderer.css.sheet.Stylesheet;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;

public class StylesheetFactoryImpl
implements StylesheetFactory {
    private UserAgentCallback _userAgent;
    private int _cacheCapacity = 16;
    private LinkedHashMap _cache = new LinkedHashMap(this._cacheCapacity, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > StylesheetFactoryImpl.this._cacheCapacity;
        }
    };
    private CSSOMParser parser;

    public StylesheetFactoryImpl(UserAgentCallback userAgent) {
        this._userAgent = userAgent;
        try {
            Object obj = Class.forName("com.steadystate.css.parser.SACParser").newInstance();
            Parser psr = (Parser)obj;
            this.parser = new CSSOMParser(psr);
        }
        catch (Exception ex) {
            XRLog.exception("Bad!  Couldn't load the CSS parser. Everything after this will fail.");
        }
    }

    synchronized Stylesheet parse(InputStream stream, StylesheetInfo info) {
        InputStreamReader r = new InputStreamReader(stream);
        InputSource is = new InputSource((Reader)r);
        CSSStyleSheet style = null;
        try {
            style = this.parser.parseStyleSheet(is);
        }
        catch (IOException e) {
            throw new XRRuntimeException("IOException on parsing style seet from a Reader; don't know the URI.", e);
        }
        Stylesheet sheet = new Stylesheet(info.getUri(), info.getOrigin());
        CSSRuleList rl = style.getCssRules();
        this.pullRulesets(rl, sheet, info);
        return sheet;
    }

    private Stylesheet parse(StylesheetInfo info) {
        CSSResource cr = this._userAgent.getCSSResource(info.getUri());
        InputStream is = cr.getResourceInputSource().getByteStream();
        Stylesheet sheet = null;
        try {
            if (is != null) {
                sheet = this.parse(is, info);
            }
        }
        catch (Exception e) {
            this.debugBadStyleSheet(info);
            if (e instanceof XRRuntimeException) {
                throw (XRRuntimeException)e;
            }
            throw new XRRuntimeException("Failed on parsing CSS sheet at " + info.getUri(), e);
        }
        return sheet;
    }

    private void debugBadStyleSheet(StylesheetInfo info) {
        InputStream is = this._userAgent.getCSSResource(info.getUri()).getResourceInputSource().getByteStream();
        if (is != null) {
            try {
                InputStreamReader r = new InputStreamReader(is);
                LineNumberReader lnr = new LineNumberReader(new BufferedReader(r));
                StringBuffer sb = new StringBuffer();
                String line = null;
                while ((line = lnr.readLine()) != null) {
                    sb.append(line + "\n");
                }
                XRLog.cssParse(sb.toString());
            }
            catch (Exception ex) {
                XRLog.cssParse("Failed to read CSS sheet at " + info.getUri() + " for debugging.");
            }
        }
    }

    public Stylesheet parseInlines(InlineStyleInfo[] isis, StylesheetInfo main) {
        Stylesheet sheet = new Stylesheet(main.getUri(), main.getOrigin());
        if (isis != null) {
            for (int i = 0; i < isis.length; ++i) {
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(isis[i].getStyle().getBytes("UTF-8"));
                    StylesheetInfo info = isis[i].getInfo();
                    info.setUri(main.getUri());
                    Stylesheet is = this.parse(stream, info);
                    info.setStylesheet(is);
                    sheet.addStylesheet(info);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return sheet;
    }

    public synchronized Ruleset parseStyleDeclaration(int origin, String styleDeclaration) {
        try {
            StringReader reader = new StringReader("* {" + styleDeclaration + "}");
            InputSource is = new InputSource((Reader)reader);
            CSSStyleSheet style = this.parser.parseStyleSheet(is);
            reader.close();
            return new Ruleset((CSSStyleRule)style.getCssRules().item(0), origin);
        }
        catch (Exception ex) {
            throw new XRRuntimeException("Cannot parse style declaration from string." + ex.getMessage(), ex);
        }
    }

    public synchronized void putStylesheet(Object key, Stylesheet sheet) {
        this._cache.put(key, sheet);
    }

    public synchronized boolean containsStylesheet(Object key) {
        return this._cache.containsKey(key);
    }

    public synchronized Stylesheet getCachedStylesheet(Object key) {
        return (Stylesheet)this._cache.get(key);
    }

    public synchronized Object removeCachedStylesheet(Object key) {
        return this._cache.remove(key);
    }

    public synchronized void flushCachedStylesheets() {
        this._cache.clear();
    }

    public Stylesheet getStylesheet(StylesheetInfo info) {
        XRLog.load("Requesting stylesheet: " + info.getUri());
        Stylesheet s = this.getCachedStylesheet(info.getUri());
        if (s == null && !this.containsStylesheet(info.getUri())) {
            s = this.parse(info);
            this.putStylesheet(info.getUri(), s);
        }
        return s;
    }

    private void pullRulesets(CSSRuleList rl, Stylesheet stylesheet, StylesheetInfo sheetInfo) {
        int nr = rl.getLength();
        for (int i = 0; i < nr; ++i) {
            if (rl.item(i).getType() == 1) {
                stylesheet.addRuleset(new Ruleset((CSSStyleRule)rl.item(i), stylesheet.getOrigin()));
                continue;
            }
            if (rl.item(i).getType() == 3) {
                CSSImportRule cssir = (CSSImportRule)rl.item(i);
                String href = cssir.getHref();
                MediaList mediaList = cssir.getMedia();
                String media = mediaList.getMediaText();
                if (media.equals("")) {
                    media = sheetInfo.getMedia();
                }
                String uri = null;
                try {
                    uri = new URL(new URL(stylesheet.getURI()), href).toString();
                    StylesheetInfo info = new StylesheetInfo();
                    info.setOrigin(stylesheet.getOrigin());
                    info.setUri(uri);
                    info.setMedia(media);
                    info.setType("text/css");
                    stylesheet.addStylesheet(info);
                }
                catch (MalformedURLException e) {
                    XRLog.exception("bad URL for imported stylesheet", e);
                }
                continue;
            }
            if (rl.item(i).getType() == 4) {
                CSSMediaRule cssmr = (CSSMediaRule)rl.item(i);
                StylesheetInfo info = new StylesheetInfo();
                info.setMedia(cssmr.getMedia().getMediaText());
                info.setOrigin(stylesheet.getOrigin());
                info.setType("text/css");
                Stylesheet mr = new Stylesheet(info.getUri(), info.getOrigin());
                info.setStylesheet(mr);
                this.pullRulesets(cssmr.getCssRules(), mr, info);
                stylesheet.addStylesheet(info);
                continue;
            }
            if (rl.item(i).getType() != 6) continue;
            CSSPageRule cssPageRule = (CSSPageRule)rl.item(i);
            Ruleset pageRules = new Ruleset(new CSSPageRuleAdapter(cssPageRule), stylesheet.getOrigin());
            stylesheet.addPageRuleset(pageRules);
        }
    }
}

