/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.constants;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class CSSName {
    private static final Integer PRIMITIVE = new Integer(0);
    private static final Integer SHORTHAND = new Integer(1);
    private static final Integer INHERITS = new Integer(2);
    private static final Integer NOT_INHERITED = new Integer(3);
    private static int maxAssigned;
    private final String propName;
    private final String initialValue;
    private final boolean propertyInherits;
    public final int FS_ID;
    private static CSSName[] ALL_PROPERTIES;
    private static Map ALL_PROPERTY_NAMES;
    private static Map ALL_PRIMITIVE_PROPERTY_NAMES;
    public static final CSSName COLOR;
    public static final CSSName BACKGROUND_COLOR;
    public static final CSSName BACKGROUND_IMAGE;
    public static final CSSName BACKGROUND_REPEAT;
    public static final CSSName BACKGROUND_ATTACHMENT;
    public static final CSSName BACKGROUND_POSITION;
    public static final CSSName BORDER_COLLAPSE;
    public static final CSSName FS_BORDER_SPACING_HORIZONTAL;
    public static final CSSName FS_BORDER_SPACING_VERTICAL;
    public static final CSSName FS_FLOW_TOP;
    public static final CSSName FS_FLOW_RIGHT;
    public static final CSSName FS_FLOW_BOTTOM;
    public static final CSSName FS_FLOW_LEFT;
    public static final CSSName FS_MOVE_TO_FLOW;
    public static final CSSName FS_PAGE_WIDTH;
    public static final CSSName FS_PAGE_HEIGHT;
    public static final CSSName FS_PAGE_ORIENTATION;
    public static final CSSName FS_TEXT_DECORATION_EXTENT;
    public static final CSSName BOTTOM;
    public static final CSSName CAPTION_SIDE;
    public static final CSSName CLEAR;
    public static final CSSName CLIP;
    public static final CSSName CONTENT;
    public static final CSSName COUNTER_INCREMENT;
    public static final CSSName COUNTER_RESET;
    public static final CSSName CURSOR;
    public static final CSSName DIRECTION;
    public static final CSSName DISPLAY;
    public static final CSSName EMPTY_CELLS;
    public static final CSSName FLOAT;
    public static final CSSName FONT_STYLE;
    public static final CSSName FONT_VARIANT;
    public static final CSSName FONT_WEIGHT;
    public static final CSSName FONT_SIZE;
    public static final CSSName LINE_HEIGHT;
    public static final CSSName FONT_FAMILY;
    public static final CSSName FONT_SIZE_ADJUST;
    public static final CSSName FONT_STRETCH;
    public static final CSSName FS_COLSPAN;
    public static final CSSName FS_ROWSPAN;
    public static final CSSName HEIGHT;
    public static final CSSName LEFT;
    public static final CSSName LETTER_SPACING;
    public static final CSSName LIST_STYLE_TYPE;
    public static final CSSName LIST_STYLE_POSITION;
    public static final CSSName LIST_STYLE_IMAGE;
    public static final CSSName MARKER_OFFSET;
    public static final CSSName MARKS;
    public static final CSSName MAX_HEIGHT;
    public static final CSSName MAX_WIDTH;
    public static final CSSName MIN_HEIGHT;
    public static final CSSName MIN_WIDTH;
    public static final CSSName ORPHANS;
    public static final CSSName OUTLINE_COLOR;
    public static final CSSName OUTLINE_STYLE;
    public static final CSSName OUTLINE_WIDTH;
    public static final CSSName OVERFLOW;
    public static final CSSName PAGE;
    public static final CSSName PAGE_BREAK_AFTER;
    public static final CSSName PAGE_BREAK_BEFORE;
    public static final CSSName PAGE_BREAK_INSIDE;
    public static final CSSName POSITION;
    public static final CSSName QUOTES;
    public static final CSSName RIGHT;
    public static final CSSName TABLE_LAYOUT;
    public static final CSSName TEXT_ALIGN;
    public static final CSSName TEXT_DECORATION;
    public static final CSSName TEXT_INDENT;
    public static final CSSName TEXT_SHADOW;
    public static final CSSName TEXT_TRANSFORM;
    public static final CSSName TOP;
    public static final CSSName UNICODE_BIDI;
    public static final CSSName VERTICAL_ALIGN;
    public static final CSSName VISIBILITY;
    public static final CSSName WHITE_SPACE;
    public static final CSSName WIDOWS;
    public static final CSSName WIDTH;
    public static final CSSName WORD_SPACING;
    public static final CSSName Z_INDEX;
    public static final CSSName BORDER_COLOR_TOP;
    public static final CSSName BORDER_COLOR_RIGHT;
    public static final CSSName BORDER_COLOR_BOTTOM;
    public static final CSSName BORDER_COLOR_LEFT;
    public static final CSSName BORDER_STYLE_TOP;
    public static final CSSName BORDER_STYLE_RIGHT;
    public static final CSSName BORDER_STYLE_BOTTOM;
    public static final CSSName BORDER_STYLE_LEFT;
    public static final CSSName BORDER_WIDTH_TOP;
    public static final CSSName BORDER_WIDTH_RIGHT;
    public static final CSSName BORDER_WIDTH_BOTTOM;
    public static final CSSName BORDER_WIDTH_LEFT;
    public static final CSSName MARGIN_TOP;
    public static final CSSName MARGIN_RIGHT;
    public static final CSSName MARGIN_BOTTOM;
    public static final CSSName MARGIN_LEFT;
    public static final CSSName PADDING_TOP;
    public static final CSSName PADDING_RIGHT;
    public static final CSSName PADDING_BOTTOM;
    public static final CSSName PADDING_LEFT;
    public static final CSSName BACKGROUND_SHORTHAND;
    public static final CSSName BORDER_WIDTH_SHORTHAND;
    public static final CSSName BORDER_STYLE_SHORTHAND;
    public static final CSSName BORDER_SHORTHAND;
    public static final CSSName BORDER_TOP_SHORTHAND;
    public static final CSSName BORDER_RIGHT_SHORTHAND;
    public static final CSSName BORDER_BOTTOM_SHORTHAND;
    public static final CSSName BORDER_LEFT_SHORTHAND;
    public static final CSSName BORDER_COLOR_SHORTHAND;
    public static final CSSName BORDER_SPACING;
    public static final CSSName FONT_SHORTHAND;
    public static final CSSName LIST_STYLE_SHORTHAND;
    public static final CSSName MARGIN_SHORTHAND;
    public static final CSSName OUTLINE_SHORTHAND;
    public static final CSSName PADDING_SHORTHAND;
    public static final CSSName SIZE_SHORTHAND;
    public static final CSSName[] MARGIN_SIDE_PROPERTIES;
    public static final CSSName[] PADDING_SIDE_PROPERTIES;
    public static final CSSName[] BORDER_SIDE_PROPERTIES;
    public static final CSSName[] BORDER_STYLE_PROPERTIES;
    public static final CSSName[] BORDER_COLOR_PROPERTIES;

    private CSSName(String propName, String initialValue, boolean inherits) {
        this.propName = propName;
        this.FS_ID = maxAssigned++;
        this.initialValue = initialValue;
        this.propertyInherits = inherits;
    }

    public String toString() {
        return this.propName;
    }

    public static final int countCSSNames() {
        return maxAssigned;
    }

    public static final int countCSSPrimitiveNames() {
        return ALL_PRIMITIVE_PROPERTY_NAMES.size();
    }

    public static final Iterator allCSS2PropertyNames() {
        return ALL_PROPERTY_NAMES.keySet().iterator();
    }

    public static final Iterator allCSS2PrimitivePropertyNames() {
        return ALL_PRIMITIVE_PROPERTY_NAMES.keySet().iterator();
    }

    public static final boolean propertyInherits(CSSName cssName) {
        return cssName.propertyInherits;
    }

    public static final String initialValue(CSSName cssName) {
        return cssName.initialValue;
    }

    public static CSSName getByPropertyName(String propName) {
        CSSName cssName = (CSSName)ALL_PROPERTY_NAMES.get(propName);
        return cssName;
    }

    public static CSSName getByID(int id) {
        return ALL_PROPERTIES[id];
    }

    private static final synchronized CSSName addProperty(String propName, Object type, String initialValue, Object inherit) {
        CSSName cssName = new CSSName(propName, initialValue, inherit == INHERITS);
        ALL_PROPERTY_NAMES.put(propName, cssName);
        if (type == PRIMITIVE) {
            ALL_PRIMITIVE_PROPERTY_NAMES.put(propName, cssName);
        }
        return cssName;
    }

    static {
        ALL_PROPERTY_NAMES = new TreeMap();
        ALL_PRIMITIVE_PROPERTY_NAMES = new TreeMap();
        COLOR = CSSName.addProperty("color", PRIMITIVE, "black", INHERITS);
        BACKGROUND_COLOR = CSSName.addProperty("background-color", PRIMITIVE, "transparent", NOT_INHERITED);
        BACKGROUND_IMAGE = CSSName.addProperty("background-image", PRIMITIVE, "none", NOT_INHERITED);
        BACKGROUND_REPEAT = CSSName.addProperty("background-repeat", PRIMITIVE, "repeat", NOT_INHERITED);
        BACKGROUND_ATTACHMENT = CSSName.addProperty("background-attachment", PRIMITIVE, "scroll", NOT_INHERITED);
        BACKGROUND_POSITION = CSSName.addProperty("background-position", PRIMITIVE, "0% 0%", NOT_INHERITED);
        BORDER_COLLAPSE = CSSName.addProperty("border-collapse", PRIMITIVE, "separate", INHERITS);
        FS_BORDER_SPACING_HORIZONTAL = CSSName.addProperty("-fs-border-spacing-horizontal", PRIMITIVE, "0", NOT_INHERITED);
        FS_BORDER_SPACING_VERTICAL = CSSName.addProperty("-fs-border-spacing-vertical", PRIMITIVE, "0", NOT_INHERITED);
        FS_FLOW_TOP = CSSName.addProperty("-fs-flow-top", PRIMITIVE, "none", NOT_INHERITED);
        FS_FLOW_RIGHT = CSSName.addProperty("-fs-flow-right", PRIMITIVE, "none", NOT_INHERITED);
        FS_FLOW_BOTTOM = CSSName.addProperty("-fs-flow-bottom", PRIMITIVE, "none", NOT_INHERITED);
        FS_FLOW_LEFT = CSSName.addProperty("-fs-flow-left", PRIMITIVE, "none", NOT_INHERITED);
        FS_MOVE_TO_FLOW = CSSName.addProperty("-fs-move-to-flow", PRIMITIVE, "none", NOT_INHERITED);
        FS_PAGE_WIDTH = CSSName.addProperty("-fs-page-width", PRIMITIVE, "auto", NOT_INHERITED);
        FS_PAGE_HEIGHT = CSSName.addProperty("-fs-page-height", PRIMITIVE, "auto", NOT_INHERITED);
        FS_PAGE_ORIENTATION = CSSName.addProperty("-fs-page-orientation", PRIMITIVE, "auto", NOT_INHERITED);
        FS_TEXT_DECORATION_EXTENT = CSSName.addProperty("-fs-text-decoration-extent", PRIMITIVE, "line", NOT_INHERITED);
        BOTTOM = CSSName.addProperty("bottom", PRIMITIVE, "auto", NOT_INHERITED);
        CAPTION_SIDE = CSSName.addProperty("caption-side", PRIMITIVE, "top", INHERITS);
        CLEAR = CSSName.addProperty("clear", PRIMITIVE, "none", NOT_INHERITED);
        CLIP = CSSName.addProperty("clip", PRIMITIVE, "auto", NOT_INHERITED);
        CONTENT = CSSName.addProperty("content", PRIMITIVE, "normal", NOT_INHERITED);
        COUNTER_INCREMENT = CSSName.addProperty("counter-increment", PRIMITIVE, "none", NOT_INHERITED);
        COUNTER_RESET = CSSName.addProperty("counter-reset", PRIMITIVE, "none", NOT_INHERITED);
        CURSOR = CSSName.addProperty("cursor", PRIMITIVE, "auto", INHERITS);
        DIRECTION = CSSName.addProperty("direction", PRIMITIVE, "ltr", INHERITS);
        DISPLAY = CSSName.addProperty("display", PRIMITIVE, "inline", NOT_INHERITED);
        EMPTY_CELLS = CSSName.addProperty("empty-cells", PRIMITIVE, "show", INHERITS);
        FLOAT = CSSName.addProperty("float", PRIMITIVE, "none", NOT_INHERITED);
        FONT_STYLE = CSSName.addProperty("font-style", PRIMITIVE, "normal", INHERITS);
        FONT_VARIANT = CSSName.addProperty("font-variant", PRIMITIVE, "normal", INHERITS);
        FONT_WEIGHT = CSSName.addProperty("font-weight", PRIMITIVE, "normal", INHERITS);
        FONT_SIZE = CSSName.addProperty("font-size", PRIMITIVE, "medium", INHERITS);
        LINE_HEIGHT = CSSName.addProperty("line-height", PRIMITIVE, "normal", INHERITS);
        FONT_FAMILY = CSSName.addProperty("font-family", PRIMITIVE, "\"Times New Roman\"", INHERITS);
        FONT_SIZE_ADJUST = CSSName.addProperty("font-size-adjust", PRIMITIVE, "none", INHERITS);
        FONT_STRETCH = CSSName.addProperty("font-stretch", PRIMITIVE, "normal", INHERITS);
        FS_COLSPAN = CSSName.addProperty("-fs-table-cell-colspan", PRIMITIVE, "1", NOT_INHERITED);
        FS_ROWSPAN = CSSName.addProperty("-fs-table-cell-rowspan", PRIMITIVE, "1", NOT_INHERITED);
        HEIGHT = CSSName.addProperty("height", PRIMITIVE, "auto", NOT_INHERITED);
        LEFT = CSSName.addProperty("left", PRIMITIVE, "auto", NOT_INHERITED);
        LETTER_SPACING = CSSName.addProperty("letter-spacing", PRIMITIVE, "normal", INHERITS);
        LIST_STYLE_TYPE = CSSName.addProperty("list-style-type", PRIMITIVE, "disc", INHERITS);
        LIST_STYLE_POSITION = CSSName.addProperty("list-style-position", PRIMITIVE, "outside", INHERITS);
        LIST_STYLE_IMAGE = CSSName.addProperty("list-style-image", PRIMITIVE, "none", INHERITS);
        MARKER_OFFSET = CSSName.addProperty("marker-offset", PRIMITIVE, "auto", NOT_INHERITED);
        MARKS = CSSName.addProperty("marks", PRIMITIVE, "none", NOT_INHERITED);
        MAX_HEIGHT = CSSName.addProperty("max-height", PRIMITIVE, "none", NOT_INHERITED);
        MAX_WIDTH = CSSName.addProperty("max-width", PRIMITIVE, "none", NOT_INHERITED);
        MIN_HEIGHT = CSSName.addProperty("min-height", PRIMITIVE, "0", NOT_INHERITED);
        MIN_WIDTH = CSSName.addProperty("min-width", PRIMITIVE, "0", NOT_INHERITED);
        ORPHANS = CSSName.addProperty("orphans", PRIMITIVE, "2", INHERITS);
        OUTLINE_COLOR = CSSName.addProperty("outline-color", PRIMITIVE, "invert", NOT_INHERITED);
        OUTLINE_STYLE = CSSName.addProperty("outline-style", PRIMITIVE, "none", NOT_INHERITED);
        OUTLINE_WIDTH = CSSName.addProperty("outline-width", PRIMITIVE, "medium", NOT_INHERITED);
        OVERFLOW = CSSName.addProperty("overflow", PRIMITIVE, "visible", NOT_INHERITED);
        PAGE = CSSName.addProperty("page", PRIMITIVE, "auto", INHERITS);
        PAGE_BREAK_AFTER = CSSName.addProperty("page-break-after", PRIMITIVE, "auto", NOT_INHERITED);
        PAGE_BREAK_BEFORE = CSSName.addProperty("page-break-before", PRIMITIVE, "auto", NOT_INHERITED);
        PAGE_BREAK_INSIDE = CSSName.addProperty("page-break-inside", PRIMITIVE, "auto", INHERITS);
        POSITION = CSSName.addProperty("position", PRIMITIVE, "static", NOT_INHERITED);
        QUOTES = CSSName.addProperty("quotes", PRIMITIVE, "none", INHERITS);
        RIGHT = CSSName.addProperty("right", PRIMITIVE, "auto", NOT_INHERITED);
        TABLE_LAYOUT = CSSName.addProperty("table-layout", PRIMITIVE, "auto", NOT_INHERITED);
        TEXT_ALIGN = CSSName.addProperty("text-align", PRIMITIVE, "left", INHERITS);
        TEXT_DECORATION = CSSName.addProperty("text-decoration", PRIMITIVE, "none", NOT_INHERITED);
        TEXT_INDENT = CSSName.addProperty("text-indent", PRIMITIVE, "0", INHERITS);
        TEXT_SHADOW = CSSName.addProperty("text-shadow", PRIMITIVE, "none", NOT_INHERITED);
        TEXT_TRANSFORM = CSSName.addProperty("text-transform", PRIMITIVE, "none", INHERITS);
        TOP = CSSName.addProperty("top", PRIMITIVE, "auto", NOT_INHERITED);
        UNICODE_BIDI = CSSName.addProperty("unicode-bidi", PRIMITIVE, "normal", NOT_INHERITED);
        VERTICAL_ALIGN = CSSName.addProperty("vertical-align", PRIMITIVE, "baseline", NOT_INHERITED);
        VISIBILITY = CSSName.addProperty("visibility", PRIMITIVE, "visible", INHERITS);
        WHITE_SPACE = CSSName.addProperty("white-space", PRIMITIVE, "normal", INHERITS);
        WIDOWS = CSSName.addProperty("widows", PRIMITIVE, "2", INHERITS);
        WIDTH = CSSName.addProperty("width", PRIMITIVE, "auto", NOT_INHERITED);
        WORD_SPACING = CSSName.addProperty("word-spacing", PRIMITIVE, "normal", INHERITS);
        Z_INDEX = CSSName.addProperty("z-index", PRIMITIVE, "auto", NOT_INHERITED);
        BORDER_COLOR_TOP = CSSName.addProperty("border-top-color", PRIMITIVE, "=color", NOT_INHERITED);
        BORDER_COLOR_RIGHT = CSSName.addProperty("border-right-color", PRIMITIVE, "=color", NOT_INHERITED);
        BORDER_COLOR_BOTTOM = CSSName.addProperty("border-bottom-color", PRIMITIVE, "=color", NOT_INHERITED);
        BORDER_COLOR_LEFT = CSSName.addProperty("border-left-color", PRIMITIVE, "=color", NOT_INHERITED);
        BORDER_STYLE_TOP = CSSName.addProperty("border-top-style", PRIMITIVE, "none", NOT_INHERITED);
        BORDER_STYLE_RIGHT = CSSName.addProperty("border-right-style", PRIMITIVE, "none", NOT_INHERITED);
        BORDER_STYLE_BOTTOM = CSSName.addProperty("border-bottom-style", PRIMITIVE, "none", NOT_INHERITED);
        BORDER_STYLE_LEFT = CSSName.addProperty("border-left-style", PRIMITIVE, "none", NOT_INHERITED);
        BORDER_WIDTH_TOP = CSSName.addProperty("border-top-width", PRIMITIVE, "medium", NOT_INHERITED);
        BORDER_WIDTH_RIGHT = CSSName.addProperty("border-right-width", PRIMITIVE, "medium", NOT_INHERITED);
        BORDER_WIDTH_BOTTOM = CSSName.addProperty("border-bottom-width", PRIMITIVE, "medium", NOT_INHERITED);
        BORDER_WIDTH_LEFT = CSSName.addProperty("border-left-width", PRIMITIVE, "medium", NOT_INHERITED);
        MARGIN_TOP = CSSName.addProperty("margin-top", PRIMITIVE, "0", NOT_INHERITED);
        MARGIN_RIGHT = CSSName.addProperty("margin-right", PRIMITIVE, "0", NOT_INHERITED);
        MARGIN_BOTTOM = CSSName.addProperty("margin-bottom", PRIMITIVE, "0", NOT_INHERITED);
        MARGIN_LEFT = CSSName.addProperty("margin-left", PRIMITIVE, "0", NOT_INHERITED);
        PADDING_TOP = CSSName.addProperty("padding-top", PRIMITIVE, "0", NOT_INHERITED);
        PADDING_RIGHT = CSSName.addProperty("padding-right", PRIMITIVE, "0", NOT_INHERITED);
        PADDING_BOTTOM = CSSName.addProperty("padding-bottom", PRIMITIVE, "0", NOT_INHERITED);
        PADDING_LEFT = CSSName.addProperty("padding-left", PRIMITIVE, "0", NOT_INHERITED);
        BACKGROUND_SHORTHAND = CSSName.addProperty("background", SHORTHAND, "transparent none repeat scroll 0% 0%", NOT_INHERITED);
        BORDER_WIDTH_SHORTHAND = CSSName.addProperty("border-width", SHORTHAND, "medium", NOT_INHERITED);
        BORDER_STYLE_SHORTHAND = CSSName.addProperty("border-style", SHORTHAND, "none", NOT_INHERITED);
        BORDER_SHORTHAND = CSSName.addProperty("border", SHORTHAND, "medium none black", NOT_INHERITED);
        BORDER_TOP_SHORTHAND = CSSName.addProperty("border-top", SHORTHAND, "medium none black", NOT_INHERITED);
        BORDER_RIGHT_SHORTHAND = CSSName.addProperty("border-right", SHORTHAND, "medium none black", NOT_INHERITED);
        BORDER_BOTTOM_SHORTHAND = CSSName.addProperty("border-bottom", SHORTHAND, "medium none black", NOT_INHERITED);
        BORDER_LEFT_SHORTHAND = CSSName.addProperty("border-left", SHORTHAND, "medium none black", NOT_INHERITED);
        BORDER_COLOR_SHORTHAND = CSSName.addProperty("border-color", SHORTHAND, "black", NOT_INHERITED);
        BORDER_SPACING = CSSName.addProperty("border-spacing", SHORTHAND, "0", INHERITS);
        FONT_SHORTHAND = CSSName.addProperty("font", SHORTHAND, "", INHERITS);
        LIST_STYLE_SHORTHAND = CSSName.addProperty("list-style", SHORTHAND, "disc outside none", INHERITS);
        MARGIN_SHORTHAND = CSSName.addProperty("margin", SHORTHAND, "0", NOT_INHERITED);
        OUTLINE_SHORTHAND = CSSName.addProperty("outline", SHORTHAND, "invert none medium", NOT_INHERITED);
        PADDING_SHORTHAND = CSSName.addProperty("padding", SHORTHAND, "0", NOT_INHERITED);
        SIZE_SHORTHAND = CSSName.addProperty("size", SHORTHAND, "auto", NOT_INHERITED);
        MARGIN_SIDE_PROPERTIES = new CSSName[]{MARGIN_TOP, MARGIN_RIGHT, MARGIN_BOTTOM, MARGIN_LEFT};
        PADDING_SIDE_PROPERTIES = new CSSName[]{PADDING_TOP, PADDING_RIGHT, PADDING_BOTTOM, PADDING_LEFT};
        BORDER_SIDE_PROPERTIES = new CSSName[]{BORDER_WIDTH_TOP, BORDER_WIDTH_RIGHT, BORDER_WIDTH_BOTTOM, BORDER_WIDTH_LEFT};
        BORDER_STYLE_PROPERTIES = new CSSName[]{BORDER_STYLE_TOP, BORDER_STYLE_RIGHT, BORDER_STYLE_BOTTOM, BORDER_STYLE_LEFT};
        BORDER_COLOR_PROPERTIES = new CSSName[]{BORDER_COLOR_TOP, BORDER_COLOR_RIGHT, BORDER_COLOR_BOTTOM, BORDER_COLOR_LEFT};
        Iterator iter = ALL_PROPERTY_NAMES.values().iterator();
        ALL_PROPERTIES = new CSSName[ALL_PROPERTY_NAMES.size()];
        while (iter.hasNext()) {
            CSSName name;
            CSSName.ALL_PROPERTIES[name.FS_ID] = name = (CSSName)iter.next();
        }
    }
}

