/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.impl;

import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;
import org.xhtmlrenderer.css.constants.ValueConstants;

public class DefaultCSSPrimitiveValue
implements CSSPrimitiveValue {
    private String _stringValue;
    private short _cssValueType;
    private short _primitiveType;
    private _RGBColor _asColor;

    public DefaultCSSPrimitiveValue(String value) {
        this._stringValue = value;
        this._cssValueType = 1;
        this._primitiveType = ValueConstants.guessType(value);
    }

    public void setCssText(String cssText) throws DOMException {
        this._stringValue = cssText;
    }

    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        throw new DOMException(9, "Not a Float value.");
    }

    public void setStringValue(short stringType, String stringValue) throws DOMException {
        if (stringType != 19) {
            throw new DOMException(9, "Can only set to CSS_STRING.");
        }
        this._stringValue = stringValue;
    }

    public String getCssText() {
        return this._stringValue;
    }

    public short getCssValueType() {
        return this._cssValueType;
    }

    public Counter getCounterValue() throws DOMException {
        throw new DOMException(9, "Not a Counter value.");
    }

    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(9, "Not a Float value.");
    }

    public short getPrimitiveType() {
        return this._primitiveType;
    }

    public RGBColor getRGBColorValue() throws DOMException {
        if (this._stringValue.startsWith("#")) {
            if (this._asColor == null) {
                this._asColor = new _RGBColor(this._stringValue);
            }
            return this._asColor;
        }
        if (this._stringValue.startsWith("rgb(")) {
            String core = this._stringValue.substring(4, this._stringValue.length() - 1);
            String[] triple = core.split(",");
            if (triple.length != 3) {
                throw new DOMException(9, "Not an RGBColor value.");
            }
            this._asColor = new _RGBColor(Integer.parseInt(triple[0].trim()), Integer.parseInt(triple[1].trim()), Integer.parseInt(triple[2].trim()));
            return this._asColor;
        }
        throw new DOMException(9, "Not an RGBColor value.");
    }

    public Rect getRectValue() throws DOMException {
        throw new DOMException(9, "Not a Rect value.");
    }

    public String getStringValue() throws DOMException {
        return this._stringValue;
    }

    static class _RGBColor
    implements RGBColor {
        ColorValue redCV;
        ColorValue greenCV;
        ColorValue blueCV;

        _RGBColor(String hex) {
            int red = Integer.parseInt(hex.substring(1, 3), 16);
            this.redCV = new ColorValue(red);
            int green = Integer.parseInt(hex.substring(3, 5), 16);
            this.greenCV = new ColorValue(green);
            int blue = Integer.parseInt(hex.substring(5, 7), 16);
            this.blueCV = new ColorValue(blue);
        }

        _RGBColor(int red, int green, int blue) {
            this.redCV = new ColorValue(red);
            this.greenCV = new ColorValue(green);
            this.blueCV = new ColorValue(blue);
        }

        public CSSPrimitiveValue getBlue() {
            return this.blueCV;
        }

        public CSSPrimitiveValue getGreen() {
            return this.greenCV;
        }

        public CSSPrimitiveValue getRed() {
            return this.redCV;
        }

        class ColorValue
        implements CSSPrimitiveValue {
            float _color;

            ColorValue(int color) {
                this._color = new Float(color).floatValue();
            }

            public void setCssText(String cssText) throws DOMException {
                throw new DOMException(15, "This is a color");
            }

            public void setFloatValue(short unitType, float floatValue) throws DOMException {
                throw new DOMException(15, "This is a color");
            }

            public void setStringValue(short stringType, String stringValue) throws DOMException {
                throw new DOMException(15, "This is a color");
            }

            public Counter getCounterValue() throws DOMException {
                throw new DOMException(15, "This is a color");
            }

            public String getCssText() {
                return "" + this._color;
            }

            public short getCssValueType() {
                return 1;
            }

            public float getFloatValue(short unitType) throws DOMException {
                return this._color;
            }

            public short getPrimitiveType() {
                return 1;
            }

            public RGBColor getRGBColorValue() throws DOMException {
                throw new DOMException(15, "This is a color");
            }

            public Rect getRectValue() throws DOMException {
                throw new DOMException(15, "This is a color");
            }

            public String getStringValue() throws DOMException {
                return "" + this._color;
            }
        }
    }
}

