/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.newmatch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.xhtmlrenderer.css.extend.AttributeResolver;
import org.xhtmlrenderer.css.extend.TreeResolver;
import org.xhtmlrenderer.css.newmatch.Condition;
import org.xhtmlrenderer.css.sheet.Ruleset;
import org.xhtmlrenderer.util.XRLog;

class Selector {
    private Ruleset _parent;
    private Selector chainedSelector = null;
    private Selector siblingSelector = null;
    private int _axis;
    private String _name;
    private int _pc = 0;
    private String _pe;
    private int _specificityB;
    private int _specificityC;
    private int _specificityD;
    private int _pos;
    private List conditions;
    public static final int DESCENDANT_AXIS = 0;
    public static final int CHILD_AXIS = 1;
    public static final int IMMEDIATE_SIBLING_AXIS = 2;
    static final int VISITED_PSEUDOCLASS = 2;
    static final int HOVER_PSEUDOCLASS = 4;
    static final int ACTIVE_PSEUDOCLASS = 8;
    static final int FOCUS_PSEUDOCLASS = 16;
    private int selectorID = selectorCount++;
    private static int selectorCount = 0;

    Selector(int pos, Ruleset parent, int axis, String elementName) {
        this();
        this._parent = parent;
        this._axis = axis;
        this._name = elementName;
        this._pos = pos;
        this._specificityB = 0;
        this._specificityC = 0;
        this._specificityD = 0;
        if (this._name != null) {
            ++this._specificityD;
        }
    }

    private Selector(int pos, int specificityB, int specificityC, int specificityD, Ruleset parent, int axis, String elementName) {
        this(pos, parent, axis, elementName);
        this._specificityB += specificityB;
        this._specificityC += specificityC;
        this._specificityD += specificityD;
    }

    public Selector() {
    }

    public boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
        if (this.siblingSelector != null) {
            Object sib = this.siblingSelector.getAppropriateSibling(e, treeRes);
            if (sib == null) {
                return false;
            }
            if (!this.siblingSelector.matches(sib, attRes, treeRes)) {
                return false;
            }
        }
        if (this._name == null || this._name.equals(treeRes.getElementName(e))) {
            if (this.conditions != null) {
                Iterator i = this.conditions.iterator();
                while (i.hasNext()) {
                    Condition c = (Condition)i.next();
                    if (c.matches(e, attRes, treeRes)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean matchesDynamic(Object e, AttributeResolver attRes, TreeResolver treeRes) {
        if (this.siblingSelector != null) {
            Object sib = this.siblingSelector.getAppropriateSibling(e, treeRes);
            if (sib == null) {
                return false;
            }
            if (!this.siblingSelector.matchesDynamic(sib, attRes, treeRes)) {
                return false;
            }
        }
        if (this.isPseudoClass(2) && (attRes == null || !attRes.isVisited(e))) {
            return false;
        }
        if (this.isPseudoClass(8) && (attRes == null || !attRes.isActive(e))) {
            return false;
        }
        if (this.isPseudoClass(4) && (attRes == null || !attRes.isHover(e))) {
            return false;
        }
        return !this.isPseudoClass(16) || attRes != null && attRes.isFocus(e);
    }

    public Selector appendChainedSelector(int axis, String elementName) {
        this.checkPseudoElement();
        if (this.chainedSelector == null) {
            this.chainedSelector = new Selector(this._pos, this.getSpecificityB(), this.getSpecificityC(), this.getSpecificityD(), this._parent, axis, elementName);
            return this.chainedSelector;
        }
        return this.chainedSelector.appendChainedSelector(axis, elementName);
    }

    public Selector appendSiblingSelector(int axis, String elementName) {
        this.checkPseudoElement();
        if (this.siblingSelector == null) {
            this.siblingSelector = new Selector(this._pos, this.getSpecificityB(), this.getSpecificityC(), this.getSpecificityD(), this._parent, axis, elementName);
            return this.siblingSelector;
        }
        return this.siblingSelector.appendSiblingSelector(axis, elementName);
    }

    private void checkPseudoElement() {
        if (this._pe != null) {
            this.addUnsupportedCondition();
            XRLog.match(Level.WARNING, "Trying to append child selectors to pseudoElement " + this._pe);
        }
    }

    public void addUnsupportedCondition() {
        this.addCondition(Condition.createUnsupportedCondition());
    }

    public void addLinkCondition() {
        ++this._specificityC;
        this.addCondition(Condition.createLinkCondition());
    }

    public void addFirstChildCondition() {
        ++this._specificityC;
        this.addCondition(Condition.createFirstChildCondition());
    }

    public void addLangCondition(String lang) {
        ++this._specificityC;
        this.addCondition(Condition.createLangCondition(lang));
    }

    public void addIDCondition(String id) {
        ++this._specificityB;
        this.addCondition(Condition.createIDCondition(id));
    }

    public void addClassCondition(String className) {
        ++this._specificityC;
        this.addCondition(Condition.createClassCondition(className));
    }

    public void addAttributeExistsCondition(String name) {
        ++this._specificityC;
        this.addCondition(Condition.createAttributeExistsCondition(name));
    }

    public void addAttributeEqualsCondition(String name, String value) {
        ++this._specificityC;
        this.addCondition(Condition.createAttributeEqualsCondition(name, value));
    }

    public void addAttributeMatchesListCondition(String name, String value) {
        ++this._specificityC;
        this.addCondition(Condition.createAttributeMatchesListCondition(name, value));
    }

    public void addAttributeMatchesFirstPartCondition(String name, String value) {
        ++this._specificityC;
        this.addCondition(Condition.createAttributeMatchesFirstPartCondition(name, value));
    }

    public void setPseudoClass(int pc) {
        if (!this.isPseudoClass(pc)) {
            ++this._specificityC;
        }
        this._pc |= pc;
    }

    public void setPseudoElement(String pseudoElement) {
        if (this._pe != null) {
            this.addUnsupportedCondition();
            XRLog.match(Level.WARNING, "Trying to set more than one pseudo-element");
        } else {
            ++this._specificityD;
            this._pe = pseudoElement;
        }
    }

    public boolean isPseudoClass(int pc) {
        return (this._pc & pc) != 0;
    }

    public String getPseudoElement() {
        if (this.chainedSelector != null) {
            return this.chainedSelector.getPseudoElement();
        }
        return this._pe;
    }

    public Selector getChainedSelector() {
        return this.chainedSelector;
    }

    public Ruleset getRuleset() {
        return this._parent;
    }

    public int getAxis() {
        return this._axis;
    }

    public int getSpecificityB() {
        if (this.siblingSelector != null) {
            return this.siblingSelector.getSpecificityB();
        }
        return this._specificityB;
    }

    public int getSpecificityD() {
        if (this.siblingSelector != null) {
            return this.siblingSelector.getSpecificityD();
        }
        return this._specificityD;
    }

    public int getSpecificityC() {
        if (this.siblingSelector != null) {
            return this.siblingSelector.getSpecificityC();
        }
        return this._specificityC;
    }

    String getOrder() {
        if (this.chainedSelector != null) {
            return this.chainedSelector.getOrder();
        }
        String b = "000" + this.getSpecificityB();
        String c = "000" + this.getSpecificityC();
        String d = "000" + this.getSpecificityD();
        String p = "00000" + this._pos;
        return "0" + b.substring(b.length() - 3) + c.substring(c.length() - 3) + d.substring(d.length() - 3) + p.substring(p.length() - 5);
    }

    Object getAppropriateSibling(Object e, TreeResolver treeRes) {
        Object sibling = null;
        switch (this._axis) {
            case 2: {
                sibling = treeRes.getPreviousSiblingElement(e);
                break;
            }
            default: {
                XRLog.exception("Bad sibling axis");
            }
        }
        return sibling;
    }

    private void addCondition(Condition c) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        if (this._pe != null) {
            this.conditions.add(Condition.createUnsupportedCondition());
            XRLog.match(Level.WARNING, "Trying to append conditions to pseudoElement " + this._pe);
        }
        this.conditions.add(c);
    }

    static String getElementStylingOrder() {
        return "100000000000000";
    }

    public int getSelectorID() {
        return this.selectorID;
    }
}

