/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet;

import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.sheet.factory.BackgroundPositionPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.BackgroundPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.BorderColorPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.BorderPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.BorderSidePropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.BorderSpacingPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.BorderStylePropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.BorderWidthPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.DefaultPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.FontFamilyPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.FontPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.ListStylePropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.MarginPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.OutlinePropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PaddingPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.SizePropertyDeclarationFactory;
import org.xhtmlrenderer.util.XRLog;

public class PropertyDeclaration {
    private String propName;
    private CSSName cssName;
    private CSSPrimitiveValue cssPrimitiveValue;
    private boolean important;
    private int origin;
    private IdentValue _identVal;
    private boolean identIsSet;
    public static final int IMPORTANCE_AND_ORIGIN_COUNT = 6;
    private static final PropertyDeclarationFactory[] PROPERTY_FACTORIES = new PropertyDeclarationFactory[CSSName.countCSSNames() + 256];
    private static final PropertyDeclarationFactory DEFAULT_PD_FACTORY = DefaultPropertyDeclarationFactory.instance();
    private static final int USER_AGENT = 1;
    private static final int USER_NORMAL = 2;
    private static final int AUTHOR_NORMAL = 3;
    private static final int AUTHOR_IMPORTANT = 4;
    private static final int USER_IMPORTANT = 5;

    public PropertyDeclaration(CSSName cssName, CSSPrimitiveValue value, boolean imp, int orig) {
        this.propName = cssName.toString();
        this.cssName = cssName;
        this.cssPrimitiveValue = value;
        this.important = imp;
        this.origin = orig;
    }

    public String toString() {
        return this.getPropertyName() + ": " + this.getValue().toString();
    }

    public IdentValue asIdentValue() {
        if (!this.identIsSet) {
            this._identVal = IdentValue.getByIdentString(this.cssPrimitiveValue.getCssText());
            this.identIsSet = true;
        }
        return this._identVal;
    }

    public String getDeclarationStandardText() {
        return this.cssName + ": " + this.cssPrimitiveValue.getCssText() + ";";
    }

    public int getImportanceAndOrigin() {
        if (this.origin == 0) {
            return 1;
        }
        if (this.origin == 1) {
            if (this.important) {
                return 5;
            }
            return 2;
        }
        if (this.important) {
            return 4;
        }
        return 3;
    }

    public String getPropertyName() {
        return this.propName;
    }

    public CSSName getCSSName() {
        return this.cssName;
    }

    public CSSPrimitiveValue getValue() {
        return this.cssPrimitiveValue;
    }

    public static PropertyDeclarationFactory newFactory(CSSName cssName) {
        PropertyDeclarationFactory pdf = null;
        if (cssName == null) {
            XRLog.cssParse("PropertyDeclarationFactory requested for NULL CSSName; returning default.");
            pdf = DEFAULT_PD_FACTORY;
        } else {
            pdf = PROPERTY_FACTORIES[cssName.FS_ID];
            if (pdf == null) {
                pdf = DEFAULT_PD_FACTORY;
            }
        }
        return pdf;
    }

    static {
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BACKGROUND_SHORTHAND.FS_ID] = BackgroundPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BACKGROUND_POSITION.FS_ID] = BackgroundPositionPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BORDER_SHORTHAND.FS_ID] = BorderPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BORDER_COLOR_SHORTHAND.FS_ID] = BorderColorPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BORDER_SPACING.FS_ID] = BorderSpacingPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BORDER_STYLE_SHORTHAND.FS_ID] = BorderStylePropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BORDER_WIDTH_SHORTHAND.FS_ID] = BorderWidthPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BORDER_TOP_SHORTHAND.FS_ID] = BorderSidePropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BORDER_RIGHT_SHORTHAND.FS_ID] = BorderSidePropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BORDER_BOTTOM_SHORTHAND.FS_ID] = BorderSidePropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.BORDER_LEFT_SHORTHAND.FS_ID] = BorderSidePropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.FONT_SHORTHAND.FS_ID] = FontPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.FONT_FAMILY.FS_ID] = FontFamilyPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.LIST_STYLE_SHORTHAND.FS_ID] = ListStylePropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.MARGIN_SHORTHAND.FS_ID] = MarginPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.OUTLINE_SHORTHAND.FS_ID] = OutlinePropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.PADDING_SHORTHAND.FS_ID] = PaddingPropertyDeclarationFactory.instance();
        PropertyDeclaration.PROPERTY_FACTORIES[CSSName.SIZE_SHORTHAND.FS_ID] = SizePropertyDeclarationFactory.instance();
    }
}

