/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet.factory;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.sheet.factory.AbstractPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.BackgroundPositionPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;
import org.xhtmlrenderer.css.value.FSCssValue;

public class BackgroundPropertyDeclarationFactory
extends AbstractPropertyDeclarationFactory {
    private static BackgroundPropertyDeclarationFactory _instance;

    private BackgroundPropertyDeclarationFactory() {
    }

    protected Iterator doBuildDeclarations(CSSPrimitiveValue[] primVals, boolean important, CSSName cssName, int origin) {
        ArrayList declarations = new ArrayList();
        CSSPrimitiveValue primitive = null;
        CSSPrimitiveValue[] primitives = new CSSPrimitiveValue[1];
        CSSName[] names = new CSSName[1];
        CSSValue bgPosPrimitive = null;
        StringBuffer bgPos = null;
        String val = null;
        Object fsCssValue = null;
        for (int i = 0; i < primVals.length; ++i) {
            primitive = primVals[i];
            val = primitive.getCssText().trim();
            Object[] ret = this.parseSingle(val, primitive, bgPos);
            if (((Boolean)ret[4]).booleanValue()) {
                if (bgPos == null) {
                    bgPos = (StringBuffer)ret[2];
                }
                if (bgPosPrimitive != null) continue;
                bgPosPrimitive = (CSSPrimitiveValue)ret[3];
                continue;
            }
            if (ret[0] == null) continue;
            names[0] = (CSSName)ret[0];
            primitives[0] = new FSCssValue((CSSPrimitiveValue)ret[1]);
            this.addProperties(declarations, primitives, names, origin, important);
        }
        if (bgPos != null) {
            val = bgPos.toString().trim();
            val = BackgroundPositionPropertyDeclarationFactory.canonicalizeValue(val);
            bgPosPrimitive.setCssText(val);
            names[0] = CSSName.BACKGROUND_POSITION;
            primitives[0] = new FSCssValue((CSSPrimitiveValue)bgPosPrimitive, val);
            this.addProperties(declarations, primitives, names, origin, important);
        }
        return declarations.iterator();
    }

    private Object[] parseSingle(String val, CSSPrimitiveValue primitive, StringBuffer bgPos) {
        Boolean wasBGP = Boolean.FALSE;
        CSSName expPropName = null;
        CSSPrimitiveValue bgPosPrimitive = null;
        if (Idents.looksLikeAColor(val)) {
            expPropName = CSSName.BACKGROUND_COLOR;
            primitive = new FSCssValue(primitive);
        } else if (Idents.looksLikeAURI(val) || "none".equals(val)) {
            expPropName = CSSName.BACKGROUND_IMAGE;
        } else if (Idents.looksLikeABGRepeat(val)) {
            expPropName = CSSName.BACKGROUND_REPEAT;
        } else if (Idents.looksLikeABGAttachment(val)) {
            expPropName = CSSName.BACKGROUND_ATTACHMENT;
        } else if (Idents.looksLikeABGPosition(val)) {
            if (bgPos == null) {
                bgPos = new StringBuffer(val);
                bgPosPrimitive = primitive;
            } else {
                bgPos.append(" " + val);
            }
            wasBGP = Boolean.TRUE;
        } else {
            expPropName = null;
        }
        return new Object[]{expPropName, primitive, bgPos, bgPosPrimitive, wasBGP};
    }

    public static synchronized PropertyDeclarationFactory instance() {
        if (_instance == null) {
            _instance = new BackgroundPropertyDeclarationFactory();
        }
        return _instance;
    }
}

