/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet.factory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.sheet.factory.AbstractPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;
import org.xhtmlrenderer.css.value.FSCssValue;

public class FontPropertyDeclarationFactory
extends AbstractPropertyDeclarationFactory {
    private static FontPropertyDeclarationFactory _instance;

    private FontPropertyDeclarationFactory() {
    }

    protected Iterator doBuildDeclarations(CSSPrimitiveValue[] primVals, boolean important, CSSName cssName, int origin) {
        ArrayList declarations = new ArrayList();
        ArrayList families = new ArrayList();
        CSSPrimitiveValue primitive = null;
        CSSPrimitiveValue[] primitives = new CSSPrimitiveValue[1];
        CSSPrimitiveValue familyPrimitive = null;
        CSSName[] names = new CSSName[1];
        Boolean hasSize = false;
        for (int i = 0; i < primVals.length; ++i) {
            primitive = primVals[i];
            String val = primitive.getCssText().trim();
            Object[] ret = this.parseSingle(val, primitive, hasSize, families);
            names[0] = (CSSName)ret[0];
            primitives[0] = (CSSPrimitiveValue)ret[1];
            hasSize = (Boolean)ret[2];
            if (ret[3] != null) {
                if (familyPrimitive != null) continue;
                familyPrimitive = (CSSPrimitiveValue)ret[3];
                continue;
            }
            this.addProperties(declarations, primitives, names, origin, important);
        }
        if (families.size() > 0) {
            StringBuffer sb = new StringBuffer();
            String sep = "";
            Iterator iter = families.iterator();
            while (iter.hasNext()) {
                sb.append(sep).append(iter.next());
                sep = ", ";
            }
            names[0] = CSSName.FONT_FAMILY;
            primitives[0] = new FSCssValue(familyPrimitive, sb.toString());
            this.addProperties(declarations, primitives, names, origin, important);
        }
        return declarations.iterator();
    }

    private Object[] parseSingle(String val, CSSPrimitiveValue primitive, Boolean hasSize, List families) {
        CSSPrimitiveValue familyPrimitive = null;
        CSSName expPropName = null;
        if (Idents.looksLikeAFontStyle(val)) {
            expPropName = CSSName.FONT_STYLE;
        } else if (Idents.looksLikeAFontVariant(val)) {
            expPropName = CSSName.FONT_VARIANT;
        } else if (Idents.looksLikeAFontWeight(val)) {
            expPropName = CSSName.FONT_WEIGHT;
        } else if (!hasSize.booleanValue() && Idents.looksLikeAFontSize(val)) {
            expPropName = CSSName.FONT_SIZE;
            hasSize = true;
        } else if (hasSize.booleanValue() && Idents.looksLikeALineHeight(val)) {
            expPropName = CSSName.LINE_HEIGHT;
        } else {
            families.add(val);
            familyPrimitive = primitive;
        }
        return new Object[]{expPropName, primitive, hasSize, familyPrimitive};
    }

    public static synchronized PropertyDeclarationFactory instance() {
        if (_instance == null) {
            _instance = new FontPropertyDeclarationFactory();
        }
        return _instance;
    }
}

