/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet.factory;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.sheet.factory.AbstractPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;
import org.xhtmlrenderer.util.XRRuntimeException;

public class ListStylePropertyDeclarationFactory
extends AbstractPropertyDeclarationFactory {
    private static ListStylePropertyDeclarationFactory _instance;

    private ListStylePropertyDeclarationFactory() {
    }

    protected Iterator doBuildDeclarations(CSSPrimitiveValue[] primVals, boolean important, CSSName cssName, int origin) {
        ArrayList declarations = new ArrayList();
        CSSPrimitiveValue primitive = null;
        CSSPrimitiveValue[] primitives = new CSSPrimitiveValue[1];
        CSSName[] names = new CSSName[1];
        for (int i = 0; i < primVals.length; ++i) {
            primitive = primVals[i];
            String val = primitive.getCssText().trim();
            CSSName expPropName = null;
            if (Idents.looksLikeAListStyleType(val)) {
                expPropName = CSSName.LIST_STYLE_TYPE;
            } else if (Idents.looksLikeAListStyleImage(val)) {
                expPropName = CSSName.LIST_STYLE_IMAGE;
            } else if (Idents.looksLikeAListStylePosition(val)) {
                expPropName = CSSName.LIST_STYLE_POSITION;
            } else {
                throw new XRRuntimeException("Can't recognize the list-style shorthand property value: : " + val);
            }
            names[0] = expPropName;
            primitives[0] = primitive;
            this.addProperties(declarations, primitives, names, origin, important);
        }
        return declarations.iterator();
    }

    public static synchronized PropertyDeclarationFactory instance() {
        if (_instance == null) {
            _instance = new ListStylePropertyDeclarationFactory();
        }
        return _instance;
    }
}

