/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet.factory;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.sheet.factory.AbstractPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;
import org.xhtmlrenderer.css.value.FSCssValue;
import org.xhtmlrenderer.css.value.PageSize;

public class SizePropertyDeclarationFactory
extends AbstractPropertyDeclarationFactory {
    private static SizePropertyDeclarationFactory _instance;

    private SizePropertyDeclarationFactory() {
    }

    protected Iterator doBuildDeclarations(CSSPrimitiveValue[] primVals, boolean important, CSSName cssName, int origin) {
        ArrayList declarations = new ArrayList();
        CSSPrimitiveValue primitive = null;
        CSSPrimitiveValue[] primitives = new CSSPrimitiveValue[1];
        CSSName[] names = new CSSName[1];
        if (primVals.length == 1) {
            primitive = primVals[0];
            String val = primitive.getCssText().trim();
            if (val.equals("landscape") || val.equals("portrait")) {
                names[0] = CSSName.FS_PAGE_WIDTH;
                primitives[0] = FSCssValue.getNewIdentValue("auto");
                this.addProperties(declarations, primitives, names, origin, important);
                names[0] = CSSName.FS_PAGE_HEIGHT;
                this.addProperties(declarations, primitives, names, origin, important);
                names[0] = CSSName.FS_PAGE_ORIENTATION;
                this.addProperties(declarations, primVals, names, origin, important);
            } else if (PageSize.resolvePageSize(val) != null) {
                PageSize pageSize = PageSize.resolvePageSize(val);
                names[0] = CSSName.FS_PAGE_WIDTH;
                primitives[0] = pageSize.getPageWidth();
                this.addProperties(declarations, primitives, names, origin, important);
                names[0] = CSSName.FS_PAGE_HEIGHT;
                primitives[0] = pageSize.getPageHeight();
                this.addProperties(declarations, primitives, names, origin, important);
                names[0] = CSSName.FS_PAGE_ORIENTATION;
                primitives[0] = FSCssValue.getNewIdentValue("auto");
                this.addProperties(declarations, primitives, names, origin, important);
            } else {
                names[0] = CSSName.FS_PAGE_WIDTH;
                this.addProperties(declarations, primVals, names, origin, important);
                names[0] = CSSName.FS_PAGE_HEIGHT;
                this.addProperties(declarations, primVals, names, origin, important);
                names[0] = CSSName.FS_PAGE_ORIENTATION;
                primitives[0] = FSCssValue.getNewIdentValue("auto");
                this.addProperties(declarations, primitives, names, origin, important);
            }
        } else if (primVals.length == 2) {
            primitive = primVals[1];
            String val = primitive.getCssText().trim();
            if (val.equals("landscape") || val.equals("portrait")) {
                PageSize pageSize = PageSize.resolvePageSize(primVals[0].getCssText().trim());
                names[0] = CSSName.FS_PAGE_WIDTH;
                primitives[0] = pageSize == null ? FSCssValue.getNewIdentValue("auto") : pageSize.getPageWidth();
                this.addProperties(declarations, primitives, names, origin, important);
                names[0] = CSSName.FS_PAGE_HEIGHT;
                primitives[0] = pageSize == null ? FSCssValue.getNewIdentValue("auto") : pageSize.getPageHeight();
                this.addProperties(declarations, primitives, names, origin, important);
                names[0] = CSSName.FS_PAGE_ORIENTATION;
                primitives[0] = primVals[1];
                this.addProperties(declarations, primitives, names, origin, important);
            } else {
                names[0] = CSSName.FS_PAGE_WIDTH;
                primitives[0] = primVals[0];
                this.addProperties(declarations, primitives, names, origin, important);
                names[0] = CSSName.FS_PAGE_HEIGHT;
                primitives[0] = primVals[1];
                this.addProperties(declarations, primitives, names, origin, important);
                names[0] = CSSName.FS_PAGE_ORIENTATION;
                primitives[0] = FSCssValue.getNewIdentValue("auto");
                this.addProperties(declarations, primitives, names, origin, important);
            }
        }
        return declarations.iterator();
    }

    public static synchronized PropertyDeclarationFactory instance() {
        if (_instance == null) {
            _instance = new SizePropertyDeclarationFactory();
        }
        return _instance;
    }
}

