/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style;

import java.awt.Color;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.constants.ValueConstants;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.DerivedValueFactory;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;

public class CalculatedStyle {
    private static final Map _cachedRects = new HashMap(500);
    private CalculatedStyle _parent;
    private String _styleKey;
    private BorderPropertySet _border;
    private RectPropertySet _margin;
    private RectPropertySet _padding;
    private float _lineHeight;
    private boolean _lineHeightResolved;
    private FSFont _FSFont;
    private FSFontMetrics _FSFontMetrics;
    private HashMap _childCache = new HashMap();
    private FSDerivedValue[] _derivedValuesById = new FSDerivedValue[CSSName.countCSSPrimitiveNames()];
    private FontSpecification _font;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;

    protected CalculatedStyle() {
    }

    CalculatedStyle(CalculatedStyle parent, CascadedStyle matched) {
        this();
        this._parent = parent;
        this.derive(matched);
        this._styleKey = this.genStyleKey();
    }

    public synchronized CalculatedStyle deriveStyle(CascadedStyle matched) {
        String fingerprint = matched.getFingerprint();
        CalculatedStyle cs = (CalculatedStyle)this._childCache.get(fingerprint);
        if (cs == null) {
            cs = new CalculatedStyle(this, matched);
            this._childCache.put(fingerprint, cs);
        }
        return cs;
    }

    public int countAssigned() {
        int c = 0;
        for (int i = 0; i < this._derivedValuesById.length; ++i) {
            if (this._derivedValuesById[i] == null) continue;
            ++c;
        }
        return c;
    }

    public CalculatedStyle getParent() {
        return this._parent;
    }

    public String toString() {
        return this._styleKey;
    }

    public Color asColor(CSSName cssName) {
        return this.valueByName(cssName).asColor();
    }

    public float asFloat(CSSName cssName) {
        return this.valueByName(cssName).asFloat();
    }

    public String asString(CSSName cssName) {
        return this.valueByName(cssName).asString();
    }

    public String[] asStringArray(CSSName cssName) {
        return this.valueByName(cssName).asStringArray();
    }

    public boolean hasAbsoluteUnit(CSSName cssName) {
        boolean isAbs = false;
        try {
            isAbs = this.valueByName(cssName).hasAbsoluteUnit();
        }
        catch (Exception e) {
            XRLog.layout(Level.WARNING, "Property " + cssName + " has an assignment we don't understand, " + "and can't tell if it's an absolute unit or not. Assuming it is not. Exception was: " + e.getMessage());
            isAbs = false;
        }
        return isAbs;
    }

    public boolean isIdent(CSSName cssName, IdentValue val) {
        return this.valueByName(cssName) == val;
    }

    public IdentValue getIdent(CSSName cssName) {
        return this.valueByName(cssName).asIdentValue();
    }

    public Color getColor() {
        return this.valueByName(CSSName.COLOR).asColor();
    }

    public Color getBackgroundColor() {
        return this.asColor(CSSName.BACKGROUND_COLOR);
    }

    public Point getBackgroundPosition(float parentWidth, float parentHeight, CssContext ctx) {
        return this.valueByName(CSSName.BACKGROUND_POSITION).asPoint(CSSName.BACKGROUND_POSITION, parentWidth, parentHeight, ctx);
    }

    public BorderPropertySet getBorder(CssContext ctx) {
        BorderPropertySet b = CalculatedStyle.getBorderProperty(this, ctx);
        return b;
    }

    public FontSpecification getFont(CssContext ctx) {
        if (this._font == null) {
            this._font = new FontSpecification();
            this._font.size = this.getFloatPropertyProportionalTo(CSSName.FONT_SIZE, 0.0f, ctx);
            this._font.fontWeight = this.getIdent(CSSName.FONT_WEIGHT);
            this._font.families = this.valueByName(CSSName.FONT_FAMILY).asStringArray();
            this._font.fontStyle = this.getIdent(CSSName.FONT_STYLE);
            this._font.variant = this.getIdent(CSSName.FONT_VARIANT);
        }
        return this._font;
    }

    public float getFloatPropertyProportionalTo(CSSName cssName, float baseValue, CssContext ctx) {
        return this.valueByName(cssName).getFloatProportionalTo(cssName, baseValue, ctx);
    }

    public float getFloatPropertyProportionalWidth(CSSName cssName, float parentWidth, CssContext ctx) {
        return this.valueByName(cssName).getFloatProportionalTo(cssName, parentWidth, ctx);
    }

    public float getFloatPropertyProportionalHeight(CSSName cssName, float parentHeight, CssContext ctx) {
        return this.valueByName(cssName).getFloatProportionalTo(cssName, parentHeight, ctx);
    }

    public float getLineHeight(CssContext ctx) {
        if (!this._lineHeightResolved) {
            this._lineHeight = this.isIdent(CSSName.LINE_HEIGHT, IdentValue.NORMAL) ? this.getFont((CssContext)ctx).size * 1.1f : (this.isLengthValue(CSSName.LINE_HEIGHT) ? this.getFloatPropertyProportionalHeight(CSSName.LINE_HEIGHT, 0.0f, ctx) : this.getFont((CssContext)ctx).size * this.valueByName(CSSName.LINE_HEIGHT).asFloat());
            this._lineHeightResolved = true;
        }
        return this._lineHeight;
    }

    public RectPropertySet getMarginRect(float parentWidth, float parentHeight, CssContext ctx) {
        return CalculatedStyle.getMarginProperty(this, CSSName.MARGIN_SHORTHAND, CSSName.MARGIN_SIDE_PROPERTIES, parentWidth, parentHeight, ctx);
    }

    public RectPropertySet getPaddingRect(float parentWidth, float parentHeight, CssContext ctx) {
        return CalculatedStyle.getPaddingProperty(this, CSSName.PADDING_SHORTHAND, CSSName.PADDING_SIDE_PROPERTIES, parentWidth, parentHeight, ctx);
    }

    public String getStringProperty(CSSName cssName) {
        return this.valueByName(cssName).asString();
    }

    public boolean isLengthValue(CSSName cssName) {
        FSDerivedValue val = this.valueByName(cssName);
        return val instanceof LengthValue;
    }

    public FSDerivedValue copyOf(CSSName cssName) {
        return this.valueByName(cssName).copyOf(cssName);
    }

    public FSDerivedValue valueByName(CSSName cssName) {
        FSDerivedValue val = this._derivedValuesById[cssName.FS_ID];
        if (val == null) {
            if (CSSName.propertyInherits(cssName) && this._parent != null && (val = this._parent.valueByName(cssName)) != null) {
                val = val.copyOf(cssName);
            } else {
                String initialValue = CSSName.initialValue(cssName);
                if (initialValue == null) {
                    throw new XRRuntimeException("Property '" + cssName + "' has no initial values assigned. " + "Check CSSName declarations.");
                }
                if (initialValue.startsWith("=")) {
                    CSSName ref = CSSName.getByPropertyName(initialValue.substring(1));
                    val = this.valueByName(ref);
                } else {
                    initialValue = Idents.convertIdent(cssName, initialValue);
                    short type = ValueConstants.guessType(initialValue);
                    val = DerivedValueFactory.newDerivedValue(this, cssName, type, initialValue, initialValue, null);
                }
            }
            this._derivedValuesById[cssName.FS_ID] = val;
        }
        return val;
    }

    private void derive(CascadedStyle matched) {
        if (matched == null) {
            return;
        }
        Iterator mProps = matched.getCascadedPropertyDeclarations();
        while (mProps.hasNext()) {
            FSDerivedValue val;
            PropertyDeclaration pd = (PropertyDeclaration)mProps.next();
            this._derivedValuesById[pd.getCSSName().FS_ID] = val = this.deriveValue(pd.getCSSName(), pd.getValue());
        }
    }

    private FSDerivedValue deriveValue(CSSName cssName, CSSPrimitiveValue value) {
        RGBColor rgb = value.getPrimitiveType() == 25 ? value.getRGBColorValue() : null;
        String s = value.getPrimitiveType() == 19 ? value.getStringValue() : null;
        String cssText = value.getCssText();
        String converted = Idents.convertIdent(cssName, value.getCssText());
        if (!converted.equals(value.getCssText())) {
            cssText = converted;
            s = converted;
        }
        FSDerivedValue dval = null;
        try {
            dval = DerivedValueFactory.newDerivedValue(this, cssName, value.getPrimitiveType(), cssText, s, rgb);
        }
        catch (Exception e) {
            dval = this.assignInitialValue(cssName);
            XRLog.cascade(Level.WARNING, "Property " + cssName + " had an illegal or unexpected value. " + "This may actually be a limitation or bug in the Flying Saucer code, so please report " + "it. The assigned text was '" + cssText + "'." + (s == null ? "" : " (or possibly there was a problem withour interpretation of the value (once converted) '" + s + "').") + "The property is being assigned its valid _initial_ value as defined by the CSS 2.1 spec." + "Original exception message: " + e.getMessage());
        }
        return dval;
    }

    private FSDerivedValue assignInitialValue(CSSName cssName) {
        String initialValue = CSSName.initialValue(cssName);
        FSDerivedValue dval = null;
        try {
            dval = DerivedValueFactory.newDerivedValue(this, cssName, (short)19, initialValue, initialValue, null);
        }
        catch (Exception e) {
            XRLog.cascade(Level.WARNING, "Property " + cssName + " had an initial value of " + initialValue + " which " + "could not be converted for use in styling. Have no option but to assign a " + "null at this point, which may cause the render or layout to break. Exception " + "message was: " + e.getMessage());
        }
        return dval;
    }

    private String genStyleKey() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._derivedValuesById.length; ++i) {
            CSSName name = CSSName.getByID(i);
            FSDerivedValue val = this._derivedValuesById[i];
            if (val != null) {
                sb.append(name.toString());
            } else {
                sb.append("(no prop assigned in this pos)");
            }
            sb.append("|\n");
        }
        return sb.toString();
    }

    public RectPropertySet getCachedPadding() {
        if (this._padding == null) {
            throw new XRRuntimeException("No padding property cached yet; should have called getPropertyRect() at least once before.");
        }
        return this._padding;
    }

    public RectPropertySet getCachedMargin() {
        if (this._margin == null) {
            throw new XRRuntimeException("No margin property cached yet; should have called getMarginRect() at least once before.");
        }
        return this._margin;
    }

    private static RectPropertySet getPaddingProperty(CalculatedStyle style, CSSName shorthandProp, CSSName[] sides, float parentWidth, float parentHeight, CssContext ctx) {
        String key = null;
        if (style._padding == null) {
            key = RectPropertySet.deriveKey(style, sides);
            if (key == null) {
                style._padding = CalculatedStyle.newRectInstance(style, shorthandProp, sides, parentHeight, parentWidth, ctx);
                return style._padding;
            }
            style._padding = (RectPropertySet)CalculatedStyle.getCachedRect(key);
            if (style._padding == null) {
                style._padding = CalculatedStyle.newRectInstance(style, shorthandProp, sides, parentHeight, parentWidth, ctx);
                CalculatedStyle.putCachedRect(key, style._padding);
            }
            if (CalculatedStyle.hasNegativeValues(style._padding)) {
                style._padding = style._padding.copyOf();
                CalculatedStyle.resetNegativeValues(style._padding);
            }
        }
        return style._padding;
    }

    private static RectPropertySet getMarginProperty(CalculatedStyle style, CSSName shorthandProp, CSSName[] sides, float parentWidth, float parentHeight, CssContext ctx) {
        String key = null;
        if (style._margin == null) {
            key = RectPropertySet.deriveKey(style, sides);
            if (key == null) {
                style._margin = CalculatedStyle.newRectInstance(style, shorthandProp, sides, parentHeight, parentWidth, ctx);
                return style._margin;
            }
            style._margin = (RectPropertySet)CalculatedStyle.getCachedRect(key);
            if (style._margin == null) {
                style._margin = CalculatedStyle.newRectInstance(style, shorthandProp, sides, parentHeight, parentWidth, ctx);
                CalculatedStyle.putCachedRect(key, style._margin);
            }
        }
        return style._margin;
    }

    private static RectPropertySet newRectInstance(CalculatedStyle style, CSSName shorthand, CSSName[] sides, float parentHeight, float parentWidth, CssContext ctx) {
        RectPropertySet rect = RectPropertySet.newInstance(style, shorthand, sides, parentHeight, parentWidth, ctx);
        return rect;
    }

    private static BorderPropertySet getBorderProperty(CalculatedStyle style, CssContext ctx) {
        if (style._border == null) {
            String key = BorderPropertySet.deriveKey(style);
            style._border = (BorderPropertySet)CalculatedStyle.getCachedRect(key);
            if (style._border == null) {
                style._border = BorderPropertySet.newInstance(style, ctx);
                CalculatedStyle.putCachedRect(key, style._border);
            }
            if (CalculatedStyle.hasNegativeValues(style._border)) {
                style._border = new BorderPropertySet(style._border);
                CalculatedStyle.resetNegativeValues(style._border);
            }
        }
        return style._border;
    }

    private static void resetNegativeValues(RectPropertySet rect) {
        if (rect.top() < 0.0f) {
            rect.setTop(0.0f);
        }
        if (rect.right() < 0.0f) {
            rect.setRight(0.0f);
        }
        if (rect.bottom() < 0.0f) {
            rect.setBottom(0.0f);
        }
        if (rect.left() < 0.0f) {
            rect.setLeft(0.0f);
        }
    }

    private static boolean hasNegativeValues(RectPropertySet rect) {
        return rect.top() < 0.0f || rect.right() < 0.0f || rect.bottom() < 0.0f || rect.left() < 0.0f;
    }

    public int getMarginBorderPadding(CssContext cssCtx, int containingBlockWidth, int which) {
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet margin = this.getMarginRect(containingBlockWidth, containingBlockWidth, cssCtx);
        RectPropertySet padding = this.getPaddingRect(containingBlockWidth, containingBlockWidth, cssCtx);
        switch (which) {
            case 1: {
                return (int)(margin.left() + border.left() + padding.left());
            }
            case 2: {
                return (int)(margin.right() + border.right() + padding.right());
            }
            case 3: {
                return (int)(margin.top() + border.top() + padding.top());
            }
            case 4: {
                return (int)(margin.bottom() + border.bottom() + padding.bottom());
            }
        }
        throw new IllegalArgumentException();
    }

    public IdentValue getWhitespace() {
        return this.getIdent(CSSName.WHITE_SPACE);
    }

    private static final synchronized Object getCachedRect(String key) {
        return _cachedRects.get(key);
    }

    private static final synchronized void putCachedRect(String key, Object value) {
        _cachedRects.put(key, value);
    }

    public FSFont getFSFont(CssContext cssContext) {
        if (this._FSFont == null) {
            this._FSFont = cssContext.getFont(this.getFont(cssContext));
        }
        return this._FSFont;
    }

    public FSFontMetrics getFSFontMetrics(LayoutContext c) {
        if (this._FSFontMetrics == null) {
            this._FSFontMetrics = c.getTextRenderer().getFSFontMetrics(c.getFontContext(), this.getFSFont(c), "");
        }
        return this._FSFontMetrics;
    }

    public boolean isAlternateFlow() {
        return !this.getStringProperty(CSSName.FS_MOVE_TO_FLOW).equals("none");
    }
}

