/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style.derived;

import java.awt.Color;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;

public class BorderPropertySet
extends RectPropertySet {
    private IdentValue _topStyle;
    private IdentValue _rightStyle;
    private IdentValue _bottomStyle;
    private IdentValue _leftStyle;
    private Color _topColor;
    private Color _rightColor;
    private Color _bottomColor;
    private Color _leftColor;

    public BorderPropertySet(BorderPropertySet border) {
        this(border.top(), border.right(), border.bottom(), border.left());
        this._topStyle = border.topStyle();
        this._rightStyle = border.rightStyle();
        this._bottomStyle = border.bottomStyle();
        this._leftStyle = border.leftStyle();
        this._topColor = border.topColor();
        this._rightColor = border.rightColor();
        this._bottomColor = border.bottomColor();
        this._leftColor = border.leftColor();
        this._key = border._key;
    }

    public BorderPropertySet(float top, float right, float bottom, float left) {
        this._top = top;
        this._right = right;
        this._bottom = bottom;
        this._left = left;
        this.buildKey(CSSName.BORDER_SHORTHAND);
    }

    private BorderPropertySet(CalculatedStyle style, CssContext ctx) {
        this._top = style.isIdent(CSSName.BORDER_STYLE_TOP, IdentValue.NONE) ? 0.0f : style.getFloatPropertyProportionalHeight(CSSName.BORDER_WIDTH_TOP, 0.0f, ctx);
        this._right = style.isIdent(CSSName.BORDER_STYLE_RIGHT, IdentValue.NONE) ? 0.0f : style.getFloatPropertyProportionalHeight(CSSName.BORDER_WIDTH_RIGHT, 0.0f, ctx);
        this._bottom = style.isIdent(CSSName.BORDER_STYLE_BOTTOM, IdentValue.NONE) ? 0.0f : style.getFloatPropertyProportionalHeight(CSSName.BORDER_WIDTH_BOTTOM, 0.0f, ctx);
        this._left = style.isIdent(CSSName.BORDER_STYLE_LEFT, IdentValue.NONE) ? 0.0f : style.getFloatPropertyProportionalHeight(CSSName.BORDER_WIDTH_LEFT, 0.0f, ctx);
        this._topColor = style.asColor(CSSName.BORDER_COLOR_TOP);
        this._rightColor = style.asColor(CSSName.BORDER_COLOR_RIGHT);
        this._bottomColor = style.asColor(CSSName.BORDER_COLOR_BOTTOM);
        this._leftColor = style.asColor(CSSName.BORDER_COLOR_LEFT);
        this._topStyle = style.getIdent(CSSName.BORDER_STYLE_TOP);
        this._rightStyle = style.getIdent(CSSName.BORDER_STYLE_RIGHT);
        this._bottomStyle = style.getIdent(CSSName.BORDER_STYLE_BOTTOM);
        this._leftStyle = style.getIdent(CSSName.BORDER_STYLE_LEFT);
        this._key = BorderPropertySet.deriveKey(style);
    }

    public BorderPropertySet brighter(IdentValue style) {
        double dS = -0.1;
        double dB = 0.2;
        if (style == IdentValue.INSET || style == IdentValue.GROOVE) {
            dS = 0.05;
            dB = 0.0;
        } else if (style == IdentValue.RIDGE || style == IdentValue.OUTSET) {
            dS = -0.1;
            dB = 0.1;
        }
        BorderPropertySet bc = new BorderPropertySet(this);
        bc._topColor = BorderPropertySet.modify(this._topColor, dS, dB);
        bc._bottomColor = BorderPropertySet.modify(this._bottomColor, dS, dB);
        bc._leftColor = BorderPropertySet.modify(this._leftColor, dS, dB);
        bc._rightColor = BorderPropertySet.modify(this._rightColor, dS, dB);
        bc.buildKey(CSSName.BORDER_SHORTHAND);
        return bc;
    }

    public BorderPropertySet darker(IdentValue style) {
        double dS = 0.1;
        double dB = -0.2;
        if (style == IdentValue.GROOVE) {
            dS = 0.0;
        } else if (style == IdentValue.OUTSET) {
            dB = -0.3;
        }
        BorderPropertySet bc = new BorderPropertySet(this);
        bc._topColor = BorderPropertySet.modify(this._topColor, dS, dB);
        bc._bottomColor = BorderPropertySet.modify(this._bottomColor, dS, dB);
        bc._leftColor = BorderPropertySet.modify(this._leftColor, dS, dB);
        bc._rightColor = BorderPropertySet.modify(this._rightColor, dS, dB);
        bc.buildKey(CSSName.BORDER_SHORTHAND);
        return bc;
    }

    public static BorderPropertySet newInstance(CalculatedStyle style, CssContext ctx) {
        return new BorderPropertySet(style, ctx);
    }

    public static String deriveKey(CalculatedStyle style) {
        String key = null;
        CSSName[] sides = CSSName.BORDER_SIDE_PROPERTIES;
        CSSName[] styles = CSSName.BORDER_STYLE_PROPERTIES;
        CSSName[] colors = CSSName.BORDER_COLOR_PROPERTIES;
        key = style.asString(sides[0]) + style.getIdent(styles[0]) + style.asColor(colors[0]) + style.asString(sides[1]) + style.getIdent(styles[1]) + style.asColor(colors[1]) + style.asString(sides[2]) + style.getIdent(styles[2]) + style.asColor(colors[2]) + style.asString(sides[3]) + style.getIdent(styles[3]) + style.asColor(colors[3]);
        return key;
    }

    public String toString() {
        return this.getPropertyIdentifier();
    }

    public boolean noTop() {
        return this._topStyle == IdentValue.NONE || (int)this._top == 0;
    }

    public boolean noRight() {
        return this._rightStyle == IdentValue.NONE || (int)this._right == 0;
    }

    public boolean noBottom() {
        return this._bottomStyle == IdentValue.NONE || (int)this._bottom == 0;
    }

    public boolean noLeft() {
        return this._leftStyle == IdentValue.NONE || (int)this._left == 0;
    }

    public IdentValue topStyle() {
        return this._topStyle;
    }

    public IdentValue rightStyle() {
        return this._rightStyle;
    }

    public IdentValue bottomStyle() {
        return this._bottomStyle;
    }

    public IdentValue leftStyle() {
        return this._leftStyle;
    }

    public Color topColor() {
        return this._topColor;
    }

    public Color rightColor() {
        return this._rightColor;
    }

    public Color bottomColor() {
        return this._bottomColor;
    }

    public Color leftColor() {
        return this._leftColor;
    }

    /*
     * Exception decompiling
     */
    protected void buildKey(CSSName name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index -1 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.genStringConcat(StringBuilderRewriter.java:193)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.testAppendChain(StringBuilderRewriter.java:180)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:43)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:786)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Color modify(Color color, double dS, double dB) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float s = (float)Math.max(0.0, Math.min(1.0, (double)hsb[1] + dS));
        float b = (float)Math.max(0.0, Math.min(1.0, (double)hsb[2] + dB));
        int code = Color.HSBtoRGB(hsb[0], s, b);
        return new Color(code);
    }
}

