/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style.derived;

import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;

public class RectPropertySet {
    protected String _key;
    protected float _top = 0.0f;
    protected float _right = 0.0f;
    protected float _bottom = 0.0f;
    protected float _left = 0.0f;

    protected RectPropertySet() {
    }

    public RectPropertySet(CSSName cssName, float top, float right, float bottom, float left) {
        this();
        this._top = top;
        this._right = right;
        this._bottom = bottom;
        this._left = left;
        this.buildKey(cssName);
    }

    public static RectPropertySet newInstance(CalculatedStyle style, CSSName shortHandProperty, CSSName[] sideProperties, float parentHeight, float parentWidth, CssContext ctx) {
        RectPropertySet rect = new RectPropertySet(shortHandProperty, style.getFloatPropertyProportionalHeight(sideProperties[0], parentHeight, ctx), style.getFloatPropertyProportionalWidth(sideProperties[1], parentWidth, ctx), style.getFloatPropertyProportionalHeight(sideProperties[2], parentHeight, ctx), style.getFloatPropertyProportionalWidth(sideProperties[3], parentWidth, ctx));
        return rect;
    }

    public String toString() {
        return this.getPropertyIdentifier();
    }

    public float top() {
        return this._top;
    }

    public float right() {
        return this._right;
    }

    public float bottom() {
        return this._bottom;
    }

    public float left() {
        return this._left;
    }

    public float getLeftRightDiff() {
        return this._left - this._right;
    }

    public float height() {
        return this._top + this._bottom;
    }

    public float width() {
        return this._left + this._right;
    }

    public String getPropertyIdentifier() {
        return this._key;
    }

    public void setTop(float _top) {
        this._top = _top;
    }

    public void setRight(float _right) {
        this._right = _right;
    }

    public void setBottom(float _bottom) {
        this._bottom = _bottom;
    }

    public void setLeft(float _left) {
        this._left = _left;
    }

    public static String deriveKey(CalculatedStyle style, CSSName[] sideProperties) {
        String key = null;
        boolean isAbs = true;
        for (int i = 0; i < sideProperties.length && isAbs; ++i) {
            isAbs = style.hasAbsoluteUnit(sideProperties[i]);
        }
        if (isAbs) {
            key = style.asString(sideProperties[0]) + style.asString(sideProperties[1]) + style.asString(sideProperties[2]) + style.asString(sideProperties[3]);
        }
        return key;
    }

    public RectPropertySet copyOf() {
        RectPropertySet newRect = new RectPropertySet();
        newRect._top = this._top;
        newRect._right = this._right;
        newRect._bottom = this._bottom;
        newRect._left = this._left;
        return newRect;
    }

    protected void buildKey(CSSName name) {
        this._key = name.toString() + ": " + (this._top + "px ") + (this._right + "px ") + (this._bottom + "px ") + (this._left + "px ") + ";";
    }
}

