/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.value;

import java.awt.Color;
import org.xhtmlrenderer.css.constants.IdentValue;

public class BorderColor {
    public Color topColor;
    public Color bottomColor;
    public Color leftColor;
    public Color rightColor;

    public BorderColor() {
    }

    public BorderColor(Color color) {
        this.topColor = color;
        this.bottomColor = color;
        this.rightColor = color;
        this.leftColor = color;
    }

    public BorderColor(Color top, Color right, Color bottom, Color left) {
        this.topColor = top;
        this.bottomColor = bottom;
        this.rightColor = right;
        this.leftColor = left;
    }

    public BorderColor brighter(IdentValue style) {
        double dS = -0.1;
        double dB = 0.2;
        if (style == IdentValue.INSET || style == IdentValue.GROOVE) {
            dS = 0.05;
            dB = 0.0;
        } else if (style == IdentValue.RIDGE || style == IdentValue.OUTSET) {
            dS = -0.1;
            dB = 0.1;
        }
        BorderColor bc = new BorderColor();
        bc.topColor = BorderColor.modify(this.topColor, dS, dB);
        bc.bottomColor = BorderColor.modify(this.bottomColor, dS, dB);
        bc.leftColor = BorderColor.modify(this.leftColor, dS, dB);
        bc.rightColor = BorderColor.modify(this.rightColor, dS, dB);
        return bc;
    }

    public BorderColor darker(IdentValue style) {
        double dS = 0.1;
        double dB = -0.2;
        if (style == IdentValue.GROOVE) {
            dS = 0.0;
        } else if (style == IdentValue.OUTSET) {
            dB = -0.3;
        }
        BorderColor bc = new BorderColor();
        bc.topColor = BorderColor.modify(this.topColor, dS, dB);
        bc.bottomColor = BorderColor.modify(this.bottomColor, dS, dB);
        bc.leftColor = BorderColor.modify(this.leftColor, dS, dB);
        bc.rightColor = BorderColor.modify(this.rightColor, dS, dB);
        return bc;
    }

    private static Color modify(Color color, double dS, double dB) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float s = (float)Math.max(0.0, Math.min(1.0, (double)hsb[1] + dS));
        float b = (float)Math.max(0.0, Math.min(1.0, (double)hsb[2] + dB));
        int code = Color.HSBtoRGB(hsb[0], s, b);
        return new Color(code);
    }

    public String toString() {
        return "BorderColor:\n    topColor = " + this.topColor + "    rightColor = " + this.rightColor + "    bottomColor = " + this.bottomColor + "    leftColor = " + this.leftColor;
    }
}

