/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.logging.Level;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.layout.Boxing;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.LayoutState;
import org.xhtmlrenderer.layout.content.AnonymousBlockContent;
import org.xhtmlrenderer.layout.content.Content;
import org.xhtmlrenderer.layout.content.FirstLetterStyle;
import org.xhtmlrenderer.layout.content.FirstLineStyle;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.ReflowEvent;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.Uu;
import org.xhtmlrenderer.util.XRLog;

public class BlockBoxing {
    private BlockBoxing() {
    }

    public static void layoutContent(final LayoutContext c, BlockBox block, List contentList) {
        Boxing.StyleSetListener styleSetListener = new Boxing.StyleSetListener(){

            public void onStyleSet(BlockBox child) {
                boolean moved = false;
                if (child.getStyle().isRelative()) {
                    Dimension delta = child.positionRelative(c);
                    c.translate(delta.width, delta.height);
                    moved = true;
                }
                if (c.isPrint() && (child.isNeedPageClear() || child.getStyle().isForcePageBreakBefore())) {
                    int delta = child.moveToNextPage(c);
                    c.translate(0, delta);
                    moved = true;
                    child.setNeedPageClear(false);
                }
                if (child.getStyle().isCleared()) {
                    c.translate(0, -child.y);
                    c.getBlockFormattingContext().clear(c, child);
                    c.translate(0, child.y);
                    moved = true;
                }
                if (moved) {
                    child.calcCanvasLocation();
                }
            }
        };
        boolean resetMargins = false;
        int listIndex = 0;
        int offset = -1;
        ArrayList localContentList = contentList;
        if (c.isPrint() && !(localContentList instanceof RandomAccess)) {
            localContentList = new ArrayList(localContentList);
        }
        Iterator contentIterator = localContentList.iterator();
        RelayoutDataList relayoutDataList = null;
        if (c.isPrint()) {
            relayoutDataList = new RelayoutDataList(localContentList.size());
        }
        BlockBox previousChildBox = null;
        while (contentIterator.hasNext()) {
            Dimension relativeOffset;
            Object o = contentIterator.next();
            ++offset;
            if (o instanceof FirstLineStyle || o instanceof FirstLetterStyle) continue;
            ++listIndex;
            Content currentContent = (Content)o;
            RelayoutData relayoutData = null;
            if (c.isPrint()) {
                relayoutData = relayoutDataList.get(offset);
                relayoutData.setLayoutState(c.copyStateForRelayout());
                relayoutData.setInitialParentHeight(block.height);
                relayoutData.setContent(currentContent);
                relayoutData.setListIndex(listIndex);
                relayoutData.setResetMargins(resetMargins);
                if (o instanceof AnonymousBlockContent && block.getPendingInlineElements() != null) {
                    relayoutData.setHasPendingInlines(true);
                }
            }
            BlockBox childBox = null;
            childBox = BlockBoxing.layoutBlockChild(c, block, styleSetListener, listIndex, resetMargins, false, currentContent);
            if (c.isPrint() && o instanceof AnonymousBlockContent && block.getPendingInlineElements() != null) {
                relayoutData.setHasPendingInlines(true);
            }
            if (c.isPrint() && childBox.getStyle().isAvoidPageBreakInside() && childBox.crossesPageBreak(c)) {
                if (o instanceof AnonymousBlockContent && relayoutData.isHasPendingInlines()) {
                    XRLog.layout(Level.WARNING, "Unable to relayout anonymous block with pending inlines. Dropping rule.");
                } else {
                    c.restoreStateForRelayout(relayoutData.getLayoutState());
                    childBox.detach(c);
                    childBox = BlockBoxing.layoutBlockChild(c, block, styleSetListener, listIndex, resetMargins, true, currentContent);
                    if (childBox.crossesPageBreak(c)) {
                        c.restoreStateForRelayout(relayoutData.getLayoutState());
                        childBox.detach(c);
                        childBox = BlockBoxing.layoutBlockChild(c, block, styleSetListener, listIndex, resetMargins, false, currentContent);
                    }
                }
            }
            if (c.isPrint()) {
                c.getRootLayer().ensureHasPage(c, childBox);
            }
            if (!childBox.getStyle().isListItem()) {
                --listIndex;
            }
            block.height = (relativeOffset = childBox.getRelativeOffset()) == null ? childBox.y + childBox.height : childBox.y - relativeOffset.height + childBox.height;
            if (c.isPrint()) {
                if (childBox.getStyle().isForcePageBreakAfter()) {
                    block.expandToPageBottom(c);
                }
                if (previousChildBox != null) {
                    relayoutDataList.markRun(offset, previousChildBox, childBox);
                }
                BlockBoxing.processPageBreakAvoidRun(c, block, contentList, styleSetListener, offset, relayoutDataList, relayoutData, childBox);
                resetMargins = childBox.getStyle().isForcePageBreakBefore();
            }
            if (c.shouldStop()) break;
            previousChildBox = childBox;
            BlockBoxing.dispatchRepaintEvent(c, block);
        }
    }

    private static void processPageBreakAvoidRun(LayoutContext c, BlockBox block, List contentList, Boxing.StyleSetListener styleSetListener, int offset, RelayoutDataList relayoutDataList, RelayoutData relayoutData, BlockBox childBox) {
        if (offset > 0) {
            RelayoutData previousRelayoutData;
            boolean mightNeedRelayout = false;
            int runEnd = -1;
            if (offset == contentList.size() - 1 && relayoutData.isEndsRun()) {
                mightNeedRelayout = true;
                runEnd = offset;
            } else if (offset > 0 && (previousRelayoutData = relayoutDataList.get(offset - 1)).isEndsRun()) {
                mightNeedRelayout = true;
                runEnd = offset - 1;
            }
            if (mightNeedRelayout) {
                int runStart = relayoutDataList.getRunStart(runEnd);
                Box runEndChild = block.getChild(runEnd);
                if (c.getRootLayer().crossesPageBreak(c, block.getChild(runStart).getAbsY(), runEndChild.getAbsY() + runEndChild.getHeight()) && !BlockBoxing.checkForPendingInlines(relayoutDataList, runStart, offset)) {
                    block.detachChildren(c, runStart, offset);
                    BlockBoxing.relayoutRun(c, contentList, block, styleSetListener, relayoutDataList, runStart, offset, true);
                    runEndChild = block.getChild(runEnd);
                    if (c.getRootLayer().crossesPageBreak(c, block.getChild(runStart).getAbsY(), runEndChild.getAbsY() + runEndChild.getHeight())) {
                        block.detachChildren(c, runStart, offset);
                        BlockBoxing.relayoutRun(c, contentList, block, styleSetListener, relayoutDataList, runStart, offset, false);
                    }
                }
            }
        }
    }

    private static boolean checkForPendingInlines(RelayoutDataList relayoutDataList, int start, int end) {
        boolean result;
        boolean bl = result = relayoutDataList.get(start).isHasPendingInlines() || relayoutDataList.get(end).isHasPendingInlines();
        if (result) {
            XRLog.layout(Level.WARNING, "Unable to relayout run with pending inlines. Dropping rule.");
        }
        return result;
    }

    private static void relayoutRun(LayoutContext c, List contentList, BlockBox block, Boxing.StyleSetListener styleSetListener, RelayoutDataList relayoutDataList, int start, int end, boolean onNewPage) {
        block.height = relayoutDataList.get(start).getInitialParentHeight();
        if (onNewPage) {
            block.expandToPageBottom(c);
        }
        for (int i = start; i <= end; ++i) {
            Content currentContent = (Content)contentList.get(i);
            RelayoutData relayoutData = relayoutDataList.get(i);
            BlockBox childBox = null;
            c.restoreStateForRelayout(relayoutData.getLayoutState());
            childBox = BlockBoxing.layoutBlockChild(c, block, styleSetListener, relayoutData.getListIndex(), relayoutData.isResetMargins(), false, currentContent);
            if (childBox.getStyle().isAvoidPageBreakInside() && childBox.crossesPageBreak(c)) {
                if (currentContent instanceof AnonymousBlockContent && relayoutData.isHasPendingInlines()) {
                    XRLog.layout(Level.WARNING, "Unable to relayout anonymous block with pending inlines. Dropping rule.");
                } else {
                    c.restoreStateForRelayout(relayoutData.getLayoutState());
                    childBox.detach(c);
                    childBox = BlockBoxing.layoutBlockChild(c, block, styleSetListener, relayoutData.getListIndex(), relayoutData.isResetMargins(), true, currentContent);
                    if (childBox.crossesPageBreak(c)) {
                        c.restoreStateForRelayout(relayoutData.getLayoutState());
                        childBox.detach(c);
                        childBox = BlockBoxing.layoutBlockChild(c, block, styleSetListener, relayoutData.getListIndex(), relayoutData.isResetMargins(), false, currentContent);
                    }
                }
            }
            c.getRootLayer().ensureHasPage(c, childBox);
            Dimension relativeOffset = childBox.getRelativeOffset();
            block.height = relativeOffset == null ? childBox.y + childBox.height : childBox.y - relativeOffset.height + childBox.height;
            if (!childBox.getStyle().isForcePageBreakAfter()) continue;
            block.expandToPageBottom(c);
        }
    }

    private static BlockBox layoutBlockChild(LayoutContext c, Box block, Boxing.StyleSetListener styleSetListener, int listIndex, boolean resetMargins, boolean needPageClear, Content currentContent) {
        BlockBox childBox = Boxing.constructBox(c, currentContent);
        childBox.setResetMargins(resetMargins);
        childBox.setNeedPageClear(needPageClear);
        childBox.setListCounter(listIndex);
        childBox.x = 0;
        childBox.y = block.height;
        block.addChild(c, childBox);
        childBox.calcCanvasLocation();
        c.translate(0, block.height);
        Boxing.layout(c, childBox, currentContent, styleSetListener);
        c.translate(-childBox.x, -childBox.y);
        return childBox;
    }

    private static void dispatchRepaintEvent(LayoutContext c, Box box) {
        if (c.isInteractive() && !c.isPrint()) {
            int delay;
            if (Configuration.isTrue("xr.incremental.enabled", false) && c.isRenderQueueAvailable()) {
                Dimension max_size = c.getRootLayer().getPaintingDimension(c);
                c.getRenderQueue().dispatchRepaintEvent(new ReflowEvent(ReflowEvent.MORE_BOXES_AVAILABLE, box, max_size));
            }
            if ((delay = Configuration.valueAsInt("xr.incremental.debug.layoutdelay", 0)) > 0) {
                try {
                    Uu.sleep(delay);
                }
                catch (Exception ex) {
                    Uu.p("sleep was interrupted in BlockBoxing.layoutContent()!");
                }
            }
        }
    }

    private static class RelayoutData {
        private LayoutState _layoutState;
        private boolean _resetMargins;
        private Content _content;
        private int _listIndex;
        private boolean _startsRun;
        private boolean _endsRun;
        private boolean _inRun;
        private int _initialParentHeight;
        private boolean _hasPendingInlines;

        public boolean isEndsRun() {
            return this._endsRun;
        }

        public void setEndsRun(boolean endsRun) {
            this._endsRun = endsRun;
        }

        public boolean isInRun() {
            return this._inRun;
        }

        public void setInRun(boolean inRun) {
            this._inRun = inRun;
        }

        public LayoutState getLayoutState() {
            return this._layoutState;
        }

        public void setLayoutState(LayoutState layoutState) {
            this._layoutState = layoutState;
        }

        public boolean isStartsRun() {
            return this._startsRun;
        }

        public void setStartsRun(boolean startsRun) {
            this._startsRun = startsRun;
        }

        public int getInitialParentHeight() {
            return this._initialParentHeight;
        }

        public void setInitialParentHeight(int initialParentHeight) {
            this._initialParentHeight = initialParentHeight;
        }

        public Content getContent() {
            return this._content;
        }

        public void setContent(Content content) {
            this._content = content;
        }

        public boolean isResetMargins() {
            return this._resetMargins;
        }

        public void setResetMargins(boolean resetMargins) {
            this._resetMargins = resetMargins;
        }

        public int getListIndex() {
            return this._listIndex;
        }

        public void setListIndex(int listIndex) {
            this._listIndex = listIndex;
        }

        public boolean isHasPendingInlines() {
            return this._hasPendingInlines;
        }

        public void setHasPendingInlines(boolean hasPendingInlineElements) {
            this._hasPendingInlines = hasPendingInlineElements;
        }
    }

    private static class RelayoutDataList {
        private List _hints;

        public RelayoutDataList(int size) {
            this._hints = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this._hints.add(new RelayoutData());
            }
        }

        public RelayoutData get(int index) {
            return (RelayoutData)this._hints.get(index);
        }

        public void markRun(int offset, BlockBox previous, BlockBox current) {
            RelayoutData previousData = this.get(offset - 1);
            RelayoutData currentData = this.get(offset);
            IdentValue previousAfter = previous.getStyle().getCalculatedStyle().getIdent(CSSName.PAGE_BREAK_AFTER);
            IdentValue currentBefore = current.getStyle().getCalculatedStyle().getIdent(CSSName.PAGE_BREAK_BEFORE);
            if (previousAfter == IdentValue.AVOID && currentBefore == IdentValue.AUTO || previousAfter == IdentValue.AUTO && currentBefore == IdentValue.AVOID || previousAfter == IdentValue.AVOID && currentBefore == IdentValue.AVOID) {
                if (!previousData.isInRun()) {
                    previousData.setStartsRun(true);
                }
                previousData.setInRun(true);
                currentData.setInRun(true);
                if (offset == this._hints.size() - 1) {
                    currentData.setEndsRun(true);
                }
            } else if (previousData.isInRun()) {
                previousData.setEndsRun(true);
            }
        }

        public int getRunStart(int runEnd) {
            int offset = runEnd;
            RelayoutData current = this.get(offset);
            if (!current.isEndsRun()) {
                throw new RuntimeException("Not the end of a run");
            }
            while (!current.isStartsRun()) {
                current = this.get(--offset);
            }
            return offset;
        }
    }
}

