/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.awt.Shape;
import java.util.List;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.LineBox;

public class BoxCollector {
    public void collect(CssContext c, Shape clip, Layer layer, List blockContent, List inlineContent) {
        if (layer.isInline()) {
            this.collectInlineLayer(c, clip, layer, blockContent, inlineContent);
        } else {
            this.collect(c, clip, layer, layer.getMaster(), blockContent, inlineContent);
        }
    }

    public boolean intersectsAny(CssContext c, Shape clip, Box master) {
        return this.intersectsAny(c, clip, master, master);
    }

    private void collectInlineLayer(CssContext c, Shape clip, Layer layer, List blockContent, List inlineContent) {
        InlineBox iB = (InlineBox)layer.getMaster();
        List content = iB.getElementWithContent();
        for (int i = 0; i < content.size(); ++i) {
            Box b = (Box)content.get(i);
            if (!b.intersects(c, clip)) continue;
            if (b instanceof InlineBox) {
                inlineContent.add(b);
                continue;
            }
            BlockBox bb = (BlockBox)b;
            if (bb.isInline()) {
                if (!this.intersectsAny(c, clip, b)) continue;
                inlineContent.add(b);
                continue;
            }
            this.collect(c, clip, layer, bb, blockContent, inlineContent);
        }
    }

    public void collect(CssContext c, Shape clip, Layer layer, Box container, List blockContent, List inlineContent) {
        if (layer != container.getContainingLayer()) {
            return;
        }
        if (container instanceof LineBox) {
            if (container.intersects(c, clip)) {
                inlineContent.add(container);
                ((LineBox)container).addAllChildren(inlineContent, layer);
            }
        } else {
            if ((container.getLayer() == null || !(container instanceof BlockBox)) && container.intersects(c, clip)) {
                blockContent.add(container);
            }
            if (container.getLayer() == null || container == layer.getMaster()) {
                for (int i = 0; i < container.getChildCount(); ++i) {
                    Box child = container.getChild(i);
                    this.collect(c, clip, layer, child, blockContent, inlineContent);
                }
            }
        }
    }

    private boolean intersectsAny(CssContext c, Shape clip, Box master, Box container) {
        if (container instanceof LineBox) {
            if (container.intersects(c, clip)) {
                return true;
            }
        } else {
            if ((container.getLayer() == null || !(container instanceof BlockBox)) && container.intersects(c, clip)) {
                return true;
            }
            if (container.getLayer() == null || container == master) {
                for (int i = 0; i < container.getChildCount(); ++i) {
                    Box child = container.getChild(i);
                    boolean possibleResult = this.intersectsAny(c, clip, master, child);
                    if (!possibleResult) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

