/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.awt.Rectangle;
import java.util.List;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.layout.AnonymousBoxing;
import org.xhtmlrenderer.layout.BlockBoxing;
import org.xhtmlrenderer.layout.BlockFormattingContext;
import org.xhtmlrenderer.layout.InlineBoxing;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.VerticalMarginCollapser;
import org.xhtmlrenderer.layout.content.AnonymousBlockContent;
import org.xhtmlrenderer.layout.content.Content;
import org.xhtmlrenderer.layout.content.ContentUtil;
import org.xhtmlrenderer.layout.content.DomToplevelNode;
import org.xhtmlrenderer.layout.content.FirstLetterStyle;
import org.xhtmlrenderer.layout.content.FirstLineStyle;
import org.xhtmlrenderer.layout.content.TableContent;
import org.xhtmlrenderer.render.AnonymousBlockBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.StrutMetrics;
import org.xhtmlrenderer.render.Style;
import org.xhtmlrenderer.table.TableBoxing;

public class Boxing {
    private Boxing() {
    }

    public static BlockBox constructBox(LayoutContext c, Content content) {
        String id;
        BlockBox block = null;
        if (content instanceof AnonymousBlockContent) {
            return AnonymousBoxing.createBox(c, content);
        }
        if (content instanceof TableContent) {
            block = TableBoxing.createBox(c, content);
        } else {
            block = new BlockBox();
            block.element = content.getElement();
        }
        Element element = content.getElement();
        if (element != null && (id = c.getNamespaceHandler().getID(element)) != null && !id.equals("")) {
            c.addIDBox(id, block);
        }
        return block;
    }

    public static Box layout(LayoutContext c, BlockBox block, Content content) {
        return Boxing.layout(c, block, content, null);
    }

    public static Box layout(LayoutContext c, BlockBox block, Content content, StyleSetListener listener) {
        if (content instanceof AnonymousBlockContent) {
            return AnonymousBoxing.layout(c, block, content);
        }
        if (content instanceof TableContent) {
            return TableBoxing.layout(c, block, content, listener);
        }
        return Boxing.layoutBlock(c, block, content, listener);
    }

    private static Box layoutBlock(LayoutContext c, BlockBox block, Content content, StyleSetListener listener) {
        CascadedStyle pushed = content.getStyle();
        if (pushed != null) {
            c.pushStyle(pushed);
        }
        Rectangle oe = c.getExtents();
        if (block.getStyle() == null) {
            block.setStyle(new Style(c.getCurrentStyle(), (int)oe.getWidth()));
        }
        if (listener != null) {
            listener.onStyleSet(block);
        }
        if (c.getCurrentStyle().isIdent(CSSName.BACKGROUND_ATTACHMENT, IdentValue.FIXED)) {
            c.getRootLayer().setFixedBackground(true);
        }
        boolean pushedLayer = false;
        if (content instanceof DomToplevelNode || block.getStyle().requiresLayer()) {
            pushedLayer = true;
            if (block.getLayer() == null) {
                c.pushLayer(block);
                if (c.isPrint() && content instanceof DomToplevelNode) {
                    c.getLayer().addPage(c);
                }
            } else {
                c.pushLayer(block.getLayer());
            }
        }
        if (content instanceof DomToplevelNode || block.getStyle().establishesBFC()) {
            BlockFormattingContext bfc = new BlockFormattingContext(block, c);
            c.pushBFC(bfc);
        }
        c.setExtents(new Rectangle(oe));
        VerticalMarginCollapser.collapseVerticalMargins(c, block, content, (float)oe.getWidth());
        if (block.isResetMargins()) {
            block.getStyle().resetCollapsedMargin();
            block.setResetMargins(false);
        }
        BorderPropertySet border = c.getCurrentStyle().getBorder(c);
        RectPropertySet margin = block.getStyle().getMarginWidth(c);
        RectPropertySet padding = c.getCurrentStyle().getPaddingRect((float)oe.getWidth(), (float)oe.getWidth(), c);
        block.leftMBP = (int)margin.left() + (int)border.left() + (int)padding.left();
        block.rightMBP = (int)padding.right() + (int)border.right() + (int)margin.right();
        block.contentWidth = (int)(c.getExtents().getWidth() - (double)block.leftMBP - (double)block.rightMBP);
        CalculatedStyle style = c.getCurrentStyle();
        if (!(block instanceof AnonymousBlockBox)) {
            ReplacedElement re;
            int setHeight = -1;
            int setWidth = -1;
            if (!block.getStyle().isAutoWidth()) {
                block.contentWidth = setWidth = (int)style.getFloatPropertyProportionalWidth(CSSName.WIDTH, c.getExtents().width, c);
                c.getExtents().width = block.getWidth();
            }
            if (!block.getStyle().isAutoHeight()) {
                setHeight = (int)style.getFloatPropertyProportionalHeight(CSSName.HEIGHT, c.getExtents().height, c);
                c.getExtents().height = (int)margin.top() + (int)border.top() + (int)padding.top() + setHeight + (int)padding.bottom() + (int)border.bottom() + (int)margin.bottom();
                block.height = setHeight;
            }
            if ((re = c.getReplacedElementFactory().createReplacedElement(c, block, c.getUac(), setWidth, setHeight)) != null) {
                block.contentWidth = re.getIntrinsicWidth();
                block.height = re.getIntrinsicHeight();
                block.setReplacedElement(re);
            }
        }
        int original_height = block.height;
        if (!block.isReplaced()) {
            block.height = 0;
        }
        boolean didSetMarkerData = false;
        if (block instanceof BlockBox && block.getStyle().isListItem()) {
            StrutMetrics strutMetrics = InlineBoxing.createDefaultStrutMetrics(c, block);
            block.createMarkerData(c, strutMetrics);
            c.setCurrentMarkerData(block.getMarkerData());
            didSetMarkerData = true;
        }
        int tx = (int)margin.left() + (int)border.left() + (int)padding.left();
        int ty = (int)margin.top() + (int)border.top() + (int)padding.top();
        block.tx = tx;
        block.ty = ty;
        c.translate(tx, ty);
        Rectangle extents = c.shrinkExtents(tx + (int)margin.right() + (int)border.right() + (int)padding.right(), ty + (int)margin.bottom() + (int)border.bottom() + (int)padding.bottom());
        if (!block.isReplaced()) {
            Boxing.layoutChildren(c, block, content);
        } else {
            block.setState(3);
        }
        c.setExtents(extents);
        c.translate(-tx, -ty);
        if (!block.getStyle().isAutoHeight()) {
            block.height = original_height;
        }
        if (content instanceof DomToplevelNode || block.getStyle().establishesBFC()) {
            int delta;
            if (block.getStyle().isAutoHeight() && (delta = c.getBlockFormattingContext().getFloatManager().getClearDelta(c, (int)margin.top() + (int)border.top() + (int)padding.top() + block.height)) > 0) {
                block.height += delta;
            }
            c.popBFC();
        }
        if (didSetMarkerData) {
            c.setCurrentMarkerData(null);
        }
        block.height = (int)margin.top() + (int)border.top() + (int)padding.top() + block.height + (int)padding.bottom() + (int)border.bottom() + (int)margin.bottom();
        if (pushedLayer) {
            c.popLayer();
        }
        c.setExtents(oe);
        if (pushed != null) {
            c.popStyle();
        }
        return block;
    }

    public static Box layoutChildren(LayoutContext c, BlockBox box, Content content) {
        List contentList = content.getChildContent(c);
        box.setState(2);
        if (contentList != null && contentList.size() > 0) {
            Content parent = c.getParentContent();
            c.setParentContent(content);
            PseudoClassPushStatus status = Boxing.pushPseudoClasses(c, contentList);
            if (ContentUtil.hasBlockContent(contentList)) {
                BlockBoxing.layoutContent(c, box, contentList);
            } else {
                InlineBoxing.layoutContent(c, box, contentList);
            }
            if (status.isPushedFirstLine()) {
                c.getFirstLinesTracker().removeLast();
            }
            if (status.isPushedFirstLetter()) {
                c.getFirstLettersTracker().removeLast();
            }
            c.setParentContent(parent);
        }
        box.setState(3);
        return box;
    }

    public static PseudoClassPushStatus pushPseudoClasses(LayoutContext c, List contentList) {
        Object second;
        PseudoClassPushStatus status = new PseudoClassPushStatus();
        Object first = contentList.get(0);
        Object v0 = second = contentList.size() > 1 ? contentList.get(1) : null;
        if (first instanceof FirstLineStyle) {
            c.getFirstLinesTracker().addStyle(((FirstLineStyle)first).getStyle());
            status.setPushedFirstLine(true);
            if (second instanceof FirstLetterStyle) {
                c.getFirstLettersTracker().addStyle(((FirstLetterStyle)second).getStyle());
                status.setPushedFirstLetter(true);
            }
        } else if (first instanceof FirstLetterStyle) {
            c.getFirstLettersTracker().addStyle(((FirstLetterStyle)first).getStyle());
            status.setPushedFirstLetter(true);
        }
        return status;
    }

    private static class PseudoClassPushStatus {
        private boolean pushedFirstLine;
        private boolean pushedFirstLetter;

        private PseudoClassPushStatus() {
        }

        public boolean isPushedFirstLetter() {
            return this.pushedFirstLetter;
        }

        public void setPushedFirstLetter(boolean pushedFirstLetter) {
            this.pushedFirstLetter = pushedFirstLetter;
        }

        public boolean isPushedFirstLine() {
            return this.pushedFirstLine;
        }

        public void setPushedFirstLine(boolean pushedFirstLine) {
            this.pushedFirstLine = pushedFirstLine;
        }
    }

    public static interface StyleSetListener {
        public void onStyleSet(BlockBox var1);
    }
}

