/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.EmptyStyle;
import org.xhtmlrenderer.layout.AbsoluteContentLayoutData;
import org.xhtmlrenderer.layout.BlockFormattingContext;
import org.xhtmlrenderer.layout.BoxCollector;
import org.xhtmlrenderer.layout.Boxing;
import org.xhtmlrenderer.layout.FloatManager;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.LayoutState;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.FloatedBlockBox;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.MarginBox;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.Style;
import org.xhtmlrenderer.render.ViewportBox;

public class Layer {
    public static final short PAGED_MODE_SCREEN = 1;
    public static final short PAGED_MODE_PRINT = 2;
    private Layer parent;
    private boolean stackingContext;
    private List children;
    private Box master;
    private Box end;
    private List floats;
    private boolean fixedBackground;
    private boolean inline;
    private boolean requiresLayout;
    private AbsoluteContentLayoutData layoutData;
    private List pages;
    private static final int POSITIVE = 1;
    private static final int ZERO = 2;
    private static final int NEGATIVE = 3;
    private static final int AUTO = 4;

    public Layer(Box master) {
        this(null, master);
        this.setStackingContext(true);
    }

    public Layer(Layer parent, Box master) {
        this.parent = parent;
        this.master = master;
        this.setStackingContext(!master.getStyle().isAutoZIndex());
        master.setLayer(this);
        master.setContainingLayer(this);
    }

    public Layer getParent() {
        return this.parent;
    }

    public boolean isStackingContext() {
        return this.stackingContext;
    }

    public void setStackingContext(boolean stackingContext) {
        this.stackingContext = stackingContext;
    }

    public int getZIndex() {
        return (int)this.master.getStyle().getCalculatedStyle().asFloat(CSSName.Z_INDEX);
    }

    public boolean isAlternateFlow() {
        return this.master.getStyle().isAlternateFlow();
    }

    public Box getMaster() {
        return this.master;
    }

    public synchronized void addChild(Layer layer) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(layer);
    }

    public void addFloat(FloatedBlockBox floater, BlockFormattingContext bfc) {
        if (this.floats == null) {
            this.floats = new ArrayList();
        }
        this.floats.add(floater);
        floater.setDrawingLayer(this);
    }

    public void removeFloat(FloatedBlockBox floater) {
        if (this.floats != null) {
            this.floats.remove(floater);
        }
    }

    private void paintFloats(RenderingContext c) {
        if (this.floats != null) {
            for (int i = this.floats.size() - 1; i >= 0; --i) {
                FloatedBlockBox floater = (FloatedBlockBox)this.floats.get(i);
                this.paintAsLayer(c, floater);
            }
        }
    }

    private void paintLayers(RenderingContext c, List layers) {
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            layer.paint(c, this.getMaster().getAbsX(), this.getMaster().getAbsY());
        }
    }

    private List collectLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        if (which != 4) {
            result.addAll(this.getStackingContextLayers(which));
        }
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Layer child = (Layer)children.get(i);
            if (this.isRootLayer() && child.isAlternateFlow() || child.isStackingContext()) continue;
            if (which == 4) {
                result.add(child);
            }
            result.addAll(child.collectLayers(which));
        }
        return result;
    }

    private List getStackingContextLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Layer target = (Layer)children.get(i);
            if (this.isRootLayer() && target.isAlternateFlow() || !target.isStackingContext()) continue;
            if (which == 3 && target.getZIndex() < 0) {
                result.add(target);
                continue;
            }
            if (which == 1 && target.getZIndex() > 0) {
                result.add(target);
                continue;
            }
            if (which != 2) continue;
            result.add(target);
        }
        return result;
    }

    private List getSortedLayers(int which) {
        List result = this.collectLayers(which);
        Collections.sort(result, new ZIndexComparator());
        return result;
    }

    private void paintBackgroundsAndBorders(RenderingContext c, List blocks) {
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            BlockBox box = (BlockBox)i.next();
            box.paintBackground(c);
            box.paintBorder(c);
            if (!c.debugDrawBoxes()) continue;
            box.paintDebugOutline(c);
        }
    }

    private void paintInlineContent(RenderingContext c, List lines) {
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            InlinePaintable paintable = (InlinePaintable)i.next();
            paintable.paintInline(c);
        }
    }

    public Dimension getPaintingDimension(LayoutContext c) {
        return this.calcPaintingDimension(c);
    }

    public void paint(RenderingContext c, int originX, int originY) {
        this.paint(c, originX, originY, false);
    }

    public void paint(RenderingContext c, int originX, int originY, boolean paintAlternateFlows) {
        if (!paintAlternateFlows && this.isAlternateFlow()) {
            return;
        }
        if (this.getMaster().getStyle().isFixed()) {
            this.positionFixedLayer(c);
        }
        if (!this.isInline() && ((BlockBox)this.getMaster()).isReplaced()) {
            this.paintLayerBackgroundAndBorder(c);
            this.paintReplacedElement(c, (BlockBox)this.getMaster());
        } else {
            ArrayList blocks = new ArrayList();
            ArrayList lines = new ArrayList();
            BoxCollector collector = new BoxCollector();
            collector.collect(c, c.getOutputDevice().getClip(), this, blocks, lines);
            if (!this.isInline()) {
                this.paintLayerBackgroundAndBorder(c);
                if (c.debugDrawBoxes()) {
                    ((BlockBox)this.getMaster()).paintDebugOutline(c);
                }
            }
            if (this.isRootLayer() || this.isStackingContext() || this.isAlternateFlow()) {
                this.paintLayers(c, this.getSortedLayers(3));
            }
            this.paintBackgroundsAndBorders(c, blocks);
            this.paintFloats(c);
            this.paintListMarkers(c, blocks);
            this.paintInlineContent(c, lines);
            this.paintReplacedElements(c, blocks);
            if (this.isRootLayer() || this.isStackingContext() || this.isAlternateFlow()) {
                this.paintLayers(c, this.collectLayers(4));
                this.paintLayers(c, this.getSortedLayers(2));
                this.paintLayers(c, this.getSortedLayers(1));
            }
        }
    }

    private List getFloats() {
        return this.floats == null ? Collections.EMPTY_LIST : this.floats;
    }

    public Box find(CssContext cssCtx, int absX, int absY) {
        Box result = null;
        if (this.isRootLayer() || this.isStackingContext()) {
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(1));
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(2));
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.collectLayers(4));
            if (result != null) {
                return result;
            }
        }
        if ((result = this.getMaster().find(cssCtx, absX, absY)) != null) {
            return result;
        }
        for (int i = 0; i < this.getFloats().size(); ++i) {
            Box floater = (Box)this.getFloats().get(i);
            result = floater.find(cssCtx, absX, absY);
            if (result == null) continue;
            return result;
        }
        if ((this.isRootLayer() || this.isStackingContext()) && (result = this.find(cssCtx, absX, absY, this.getSortedLayers(3))) != null) {
            return result;
        }
        return null;
    }

    private Box find(CssContext cssCtx, int absX, int absY, List layers) {
        Box result = null;
        for (int i = 0; i < layers.size(); ++i) {
            Layer l = (Layer)layers.get(i);
            result = l.getMaster().find(cssCtx, absX, absY);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public void paintAsLayer(RenderingContext c, BlockBox startingPoint) {
        ArrayList blocks = new ArrayList();
        ArrayList lines = new ArrayList();
        BoxCollector collector = new BoxCollector();
        collector.collect(c, c.getOutputDevice().getClip(), this, startingPoint, blocks, lines);
        this.paintBackgroundsAndBorders(c, blocks);
        this.paintListMarkers(c, blocks);
        this.paintInlineContent(c, lines);
        this.paintReplacedElements(c, blocks);
    }

    private void paintListMarkers(RenderingContext c, List blocks) {
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            BlockBox box = (BlockBox)i.next();
            box.paintListMarker(c);
        }
    }

    private void paintReplacedElements(RenderingContext c, List blocks) {
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            BlockBox box = (BlockBox)i.next();
            if (!box.isReplaced()) continue;
            this.paintReplacedElement(c, box);
        }
    }

    private void positionFixedLayer(RenderingContext c) {
        Rectangle rect = c.getFixedRectangle();
        rect.translate(-1, -1);
        Box fixed = this.getMaster();
        fixed.x = 0;
        fixed.y = 0;
        fixed.setAbsX(0);
        fixed.setAbsY(0);
        fixed.setContainingBlock(new ViewportBox(rect));
        ((BlockBox)fixed).positionAbsolute(c, 3);
    }

    private void paintLayerBackgroundAndBorder(RenderingContext c) {
        if (this.getMaster() instanceof BlockBox) {
            BlockBox box = (BlockBox)this.getMaster();
            box.paintBackground(c);
            box.paintBorder(c);
        }
    }

    private void paintReplacedElement(RenderingContext c, BlockBox replaced) {
        Rectangle contentBounds = replaced.getContentAreaEdge(replaced.getAbsX(), replaced.getAbsY(), c);
        Point loc = replaced.getReplacedElement().getLocation();
        if (contentBounds.x != loc.x || contentBounds.y != loc.y) {
            replaced.getReplacedElement().setLocation(contentBounds.x, contentBounds.y);
        }
        if (!c.isInteractive()) {
            c.getOutputDevice().paintReplacedElement(c, replaced);
        }
    }

    public boolean isRootLayer() {
        return this.getParent() == null && this.isStackingContext();
    }

    private void moveIfGreater(Dimension result, Dimension test) {
        if (test.width > result.width) {
            result.width = test.width;
        }
        if (test.height > result.height) {
            result.height = test.height;
        }
    }

    private Dimension calcPaintingDimension(LayoutContext c) {
        Dimension result = this.scanLayer(c);
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Layer child = (Layer)children.get(i);
            if (child.getMaster().getStyle().isFixed() || !child.getMaster().getStyle().isAbsolute()) continue;
            Dimension dim = child.scanLayer(c);
            this.moveIfGreater(result, dim);
        }
        return result;
    }

    private Dimension scanLayer(LayoutContext c) {
        return this.scanLayerHelper(c, this.getMaster());
    }

    private Dimension scanLayerHelper(final LayoutContext c, Box box) {
        Rectangle bounds = box.getBounds(box.getAbsX(), box.getAbsY(), c, 0, 0);
        final Dimension result = new Dimension(bounds.x + bounds.width, bounds.y + bounds.height);
        if (!(box instanceof InlineBox)) {
            if (box instanceof BlockBox && ((BlockBox)box).getPersistentBFC() != null) {
                ((BlockBox)box).getPersistentBFC().getFloatManager().performFloatOperation(new FloatManager.FloatOperation(){

                    public void operate(Box floater) {
                        Dimension dim = Layer.this.scanLayerHelper(c, floater);
                        Layer.this.moveIfGreater(result, dim);
                    }
                });
            }
            for (int i = 0; i < box.getChildCount(); ++i) {
                Box child = box.getChild(i);
                Dimension offset = this.scanLayerHelper(c, child);
                this.moveIfGreater(result, offset);
            }
        } else {
            InlineBox iB = (InlineBox)box;
            for (int i = 0; i < iB.getInlineChildCount(); ++i) {
                Object obj = iB.getInlineChild(i);
                if (!(obj instanceof Box)) continue;
                Dimension offset = this.scanLayerHelper(c, (Box)obj);
                this.moveIfGreater(result, offset);
            }
        }
        return result;
    }

    public void positionChildren(LayoutContext c) {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            Layer child = (Layer)i.next();
            child.position(c);
        }
    }

    private void position(LayoutContext c) {
        if (this.getMaster().getStyle().isAbsolute() && !c.isPrint()) {
            ((BlockBox)this.getMaster()).positionAbsolute(c, 3);
        } else if (this.getMaster().getStyle().isRelative() && this.isInline()) {
            this.getMaster().positionRelative(c);
        }
    }

    private boolean containsFixedLayer() {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            Layer child = (Layer)i.next();
            if (!child.getMaster().getStyle().isFixed()) continue;
            return true;
        }
        return false;
    }

    public boolean containsFixedContent() {
        return this.fixedBackground || this.containsFixedLayer();
    }

    public void setFixedBackground(boolean b) {
        this.fixedBackground = b;
    }

    public synchronized List getChildren() {
        return this.children == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.children);
    }

    public Layer getAlternateFlow(String name) {
        List children = this.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            CalculatedStyle cs;
            Layer child = (Layer)i.next();
            if (!child.getMaster().getStyle().isAlternateFlow() || !(cs = child.getMaster().getStyle().getCalculatedStyle()).getStringProperty(CSSName.FS_MOVE_TO_FLOW).equals(name)) continue;
            return child;
        }
        return null;
    }

    private void remove(Layer layer) {
        boolean removed = false;
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                Layer child = (Layer)i.next();
                if (child != layer) continue;
                removed = true;
                i.remove();
                break;
            }
        }
        if (!removed) {
            throw new RuntimeException("Could not find layer to remove");
        }
    }

    public void detach() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public Box getEnd() {
        return this.end;
    }

    public void setEnd(Box end) {
        this.end = end;
    }

    public AbsoluteContentLayoutData getLayoutData() {
        return this.layoutData;
    }

    public void setLayoutData(AbsoluteContentLayoutData layoutData) {
        this.layoutData = layoutData;
    }

    public boolean isRequiresLayout() {
        return this.requiresLayout;
    }

    public void setRequiresLayout(boolean requiresLayout) {
        this.requiresLayout = requiresLayout;
    }

    public void finish(LayoutContext c) {
        if (c.isPrint()) {
            this.layoutAbsoluteChildren(c);
            if (this.isRootLayer()) {
                this.layoutAlternateFlows(c);
            }
        }
        if (!this.isInline()) {
            this.positionChildren(c);
        }
    }

    private void layoutAlternateFlows(LayoutContext c) {
        List children = this.getChildren();
        if (children.size() > 0) {
            LayoutState state = c.captureLayoutState();
            for (int i = 0; i < children.size(); ++i) {
                Layer child = (Layer)children.get(i);
                if (!child.isRequiresLayout() || !child.isAlternateFlow()) continue;
                CalculatedStyle cs = child.getMaster().getStyle().getCalculatedStyle();
                MarginBox cb = this.createMarginBox(c, cs.getStringProperty(CSSName.FS_MOVE_TO_FLOW));
                if (cb != null) {
                    child.getMaster().setContainingBlock(cb);
                    this.layoutAlternateFlowChild(c, child);
                    child.setRequiresLayout(false);
                    child.finish(c);
                    continue;
                }
                child.setRequiresLayout(false);
            }
            c.restoreLayoutState(state);
        }
    }

    private MarginBox createMarginBox(CssContext cssCtx, String flowName) {
        PageBox pageBox;
        List pages = this.getPages();
        Rectangle bounds = null;
        Iterator i = pages.iterator();
        while (i.hasNext() && (bounds = (pageBox = (PageBox)i.next()).getFlowBounds(cssCtx, flowName)) == null) {
        }
        return bounds == null ? null : new MarginBox(bounds);
    }

    private void layoutAbsoluteChildren(LayoutContext c) {
        List children = this.getChildren();
        if (children.size() > 0) {
            LayoutState state = c.captureLayoutState();
            for (int i = 0; i < children.size(); ++i) {
                Layer child = (Layer)children.get(i);
                if (!child.isRequiresLayout() || child.isAlternateFlow()) continue;
                this.layoutAbsoluteChild(c, child);
                if (child.getMaster().getStyle().isAvoidPageBreakInside() && child.getMaster().crossesPageBreak(c)) {
                    ((BlockBox)child.getMaster()).setNeedPageClear(true);
                    child.getMaster().detach(c);
                    this.layoutAbsoluteChild(c, child);
                    ((BlockBox)child.getMaster()).setNeedPageClear(false);
                    if (child.getMaster().crossesPageBreak(c)) {
                        child.getMaster().detach(c);
                        this.layoutAbsoluteChild(c, child);
                    }
                }
                child.setRequiresLayout(false);
                child.finish(c);
                c.getRootLayer().ensureHasPage(c, child.getMaster());
            }
            c.restoreLayoutState(state);
        }
    }

    private void layoutAbsoluteChild(LayoutContext c, Layer child) {
        BlockBox master = (BlockBox)child.getMaster();
        if (child.getMaster().getStyle().isBottomAuto()) {
            master.positionAbsolute(c, 3);
            master.positionAbsoluteOnPage(c);
            c.reInit(child.getLayoutData().getParentStyle());
            c.setExtents(this.getExtents(c));
            Boxing.layout(c, (BlockBox)child.getMaster(), child.getLayoutData().getContent());
            master.positionAbsolute(c, 2);
        } else {
            c.reInit(child.getLayoutData().getParentStyle());
            c.setExtents(this.getExtents(c));
            Boxing.layout(c, (BlockBox)child.getMaster(), child.getLayoutData().getContent());
            child.getMaster().detach(c);
            master.positionAbsolute(c, 3);
            master.positionAbsoluteOnPage(c);
            c.reInit(child.getLayoutData().getParentStyle());
            c.setExtents(this.getExtents(c));
            Boxing.layout(c, (BlockBox)child.getMaster(), child.getLayoutData().getContent());
        }
    }

    private void layoutAlternateFlowChild(LayoutContext c, Layer child) {
        BlockBox master = (BlockBox)child.getMaster();
        master.positionAbsolute(c, 3);
        c.reInit(child.getLayoutData().getParentStyle());
        c.setExtents(child.getMaster().getContainingBlock().getPaddingEdge(0, 0, c));
        Boxing.layout(c, (BlockBox)child.getMaster(), child.getLayoutData().getContent());
        master.positionAbsolute(c, 3);
    }

    private Rectangle getExtents(CssContext cssCtx) {
        return this.getMaster().getPaddingEdge(this.getMaster().getAbsX(), this.getMaster().getAbsY(), cssCtx);
    }

    public List getPages() {
        return this.pages == null ? Collections.EMPTY_LIST : this.pages;
    }

    public void setPages(List pages) {
        this.pages = pages;
    }

    public boolean isLastPage(PageBox pageBox) {
        return this.pages.get(this.pages.size() - 1) == pageBox;
    }

    public void addPage(CssContext c) {
        List pages;
        String pseudoPage = null;
        if (this.pages == null) {
            this.pages = new ArrayList();
        }
        pseudoPage = (pages = this.getPages()).size() == 0 ? "first" : (pages.size() % 2 == 0 ? "left" : "right");
        PageBox pageBox = Layer.createPageBox(c, pseudoPage);
        if (pages.size() == 0) {
            pageBox.setTopAndBottom(c, 0);
        } else {
            PageBox previous = (PageBox)pages.get(pages.size() - 1);
            pageBox.setTopAndBottom(c, previous.getBottom());
        }
        pageBox.setPageNo(pages.size());
        pages.add(pageBox);
    }

    public static PageBox createPageBox(CssContext c, String pseudoPage) {
        PageBox result = new PageBox();
        CalculatedStyle cs = new EmptyStyle().deriveStyle(c.getCss().getPageStyle(pseudoPage));
        result.setStyle(new Style(cs, 0));
        result.getStyle().setContainingBlockWidth(result.getWidth(c));
        return result;
    }

    public PageBox getFirstPage(CssContext c, Box box) {
        return this.getPage(c, box.getAbsY());
    }

    public PageBox getLastPage(CssContext c, Box box) {
        return this.getPage(c, box.getAbsY() + box.getHeight() - 1);
    }

    public void ensureHasPage(CssContext c, Box box) {
        this.getLastPage(c, box);
    }

    public PageBox getPage(CssContext c, int yOffset) {
        List pages = this.getPages();
        if (yOffset < 0) {
            return null;
        }
        PageBox last = (PageBox)pages.get(pages.size() - 1);
        if (yOffset < last.getBottom()) {
            for (int i = pages.size() - 1; i >= 0; --i) {
                PageBox pageBox = (PageBox)pages.get(i);
                if (yOffset < pageBox.getTop() || yOffset >= pageBox.getBottom()) continue;
                return pageBox;
            }
        } else {
            this.addPagesUntilPosition(c, yOffset);
            return (PageBox)pages.get(pages.size() - 1);
        }
        throw new RuntimeException("internal error");
    }

    private void addPagesUntilPosition(CssContext c, int position) {
        List pages = this.getPages();
        PageBox last = (PageBox)pages.get(pages.size() - 1);
        while (position >= last.getBottom()) {
            this.addPage(c);
            last = (PageBox)pages.get(pages.size() - 1);
        }
    }

    public void trimEmptyPages(CssContext c, int maxYHeight) {
        PageBox page;
        List pages = this.getPages();
        for (int i = pages.size() - 1; i >= 0 && (page = (PageBox)pages.get(i)).getTop() > maxYHeight; --i) {
            pages.remove(i);
        }
    }

    public void assignPagePaintingPositions(CssContext cssCtx, short mode) {
        this.assignPagePaintingPositions(cssCtx, mode, 0);
    }

    public void assignPagePaintingPositions(CssContext cssCtx, int mode, int additionalClearance) {
        List pages = this.getPages();
        int paintingTop = additionalClearance;
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            PageBox page = (PageBox)i.next();
            page.setPaintingTop(paintingTop);
            if (mode == 1) {
                page.setPaintingBottom(paintingTop + page.getHeight(cssCtx));
            } else if (mode == 2) {
                page.setPaintingBottom(paintingTop + page.getContentHeight(cssCtx));
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            paintingTop = page.getPaintingBottom() + additionalClearance;
        }
    }

    public int getMaxPageWidth(CssContext cssCtx, int additionalClearance) {
        List pages = this.getPages();
        int maxWidth = 0;
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            PageBox page = (PageBox)i.next();
            int pageWidth = page.getWidth(cssCtx) + additionalClearance * 2;
            if (pageWidth <= maxWidth) continue;
            maxWidth = pageWidth;
        }
        return maxWidth;
    }

    public PageBox getLastPage() {
        List pages = this.getPages();
        return pages.size() == 0 ? null : (PageBox)pages.get(pages.size() - 1);
    }

    public boolean crossesPageBreak(LayoutContext c, int top, int bottom) {
        if (top < 0) {
            return false;
        }
        List pages = this.getPages();
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            PageBox page = (PageBox)i.next();
            if (top < page.getTop() || top >= page.getBottom()) continue;
            return bottom >= page.getBottom();
        }
        throw new RuntimeException("Could not find page");
    }

    public Layer findRoot() {
        if (this.isRootLayer()) {
            return this;
        }
        return this.getParent().findRoot();
    }

    private static class ZIndexComparator
    implements Comparator {
        private ZIndexComparator() {
        }

        public int compare(Object o1, Object o2) {
            Layer l1 = (Layer)o1;
            Layer l2 = (Layer)o2;
            return l1.getZIndex() - l2.getZIndex();
        }
    }
}

