/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.awt.Rectangle;
import java.util.List;
import org.xhtmlrenderer.layout.AbsoluteContentLayoutData;
import org.xhtmlrenderer.layout.Boxing;
import org.xhtmlrenderer.layout.FloatLayoutResult;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.content.Content;
import org.xhtmlrenderer.layout.content.FloatedBlockContent;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.FloatedBlockBox;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.MarkerData;
import org.xhtmlrenderer.render.Style;

public class LayoutUtil {
    public static BlockBox generateAbsolute(LayoutContext c, Content content, LineBox currentLine) {
        Rectangle oe = c.getExtents();
        c.setExtents(new Rectangle(oe));
        MarkerData markerData = c.getCurrentMarkerData();
        c.setCurrentMarkerData(null);
        BlockBox box = Boxing.constructBox(c, content);
        box.setContainingBlock(c.getLayer().getMaster());
        box.setStaticEquivalent(currentLine);
        if (!c.isPrint()) {
            if (!LayoutUtil.isAlternateFlow(c, content)) {
                Boxing.layout(c, box, content);
            } else {
                box = null;
            }
        } else {
            c.pushStyle(content.getStyle());
            box.setStyle(new Style(c.getCurrentStyle(), c.getLayer().getMaster().getContentWidth()));
            c.pushLayer(box);
            c.getLayer().setRequiresLayout(true);
            c.getLayer().setLayoutData(new AbsoluteContentLayoutData(content, c.getCurrentStyle()));
            c.popLayer();
            c.popStyle();
        }
        c.setCurrentMarkerData(markerData);
        c.setExtents(oe);
        return box;
    }

    private static boolean isAlternateFlow(LayoutContext c, Content content) {
        c.pushStyle(content.getStyle());
        boolean result = c.getCurrentStyle().isAlternateFlow();
        c.popStyle();
        return result;
    }

    public static FloatLayoutResult generateFloated(LayoutContext c, FloatedBlockContent content, int avail, LineBox curr_line, List pendingFloats) {
        FloatLayoutResult result = new FloatLayoutResult();
        Rectangle oe = c.getExtents();
        c.setExtents(new Rectangle(oe));
        MarkerData markerData = c.getCurrentMarkerData();
        c.setCurrentMarkerData(null);
        FloatedBlockBox block = new FloatedBlockBox();
        block.setContainingBlock(curr_line.getParent());
        block.setContainingLayer(curr_line.getContainingLayer());
        block.y = pendingFloats != null ? curr_line.y + content.getMarginFromPrevious() : curr_line.y + curr_line.height;
        block.calcInitialCanvasLocation(c);
        int initialY = block.y;
        block.element = content.getElement();
        Boxing.layout(c, block, content);
        c.getBlockFormattingContext().floatBox(c, block);
        if (pendingFloats != null && (pendingFloats.size() > 0 || block.getWidth() > avail)) {
            block.detach(c);
            result.setPending(true);
            result.setPendingContent(content);
        } else {
            if (c.isPrint()) {
                LayoutUtil.positionFloatOnPage(c, content, curr_line, block, initialY != block.y);
                c.getRootLayer().ensureHasPage(c, block);
            }
            result.setBlock(block);
        }
        c.setCurrentMarkerData(markerData);
        c.setExtents(oe);
        return result;
    }

    private static void positionFloatOnPage(LayoutContext c, FloatedBlockContent content, LineBox curr_line, FloatedBlockBox block, boolean movedVertically) {
        boolean clearedPage = false;
        int clearDelta = 0;
        if (block.getStyle().isForcePageBreakBefore() || block.getStyle().isAvoidPageBreakInside() && block.crossesPageBreak(c)) {
            clearDelta = block.moveToNextPage(c);
            clearedPage = true;
            block.calcCanvasLocation();
            block.detach(c);
            Boxing.layout(c, block, content);
            c.getBlockFormattingContext().floatBox(c, block);
        }
        if ((movedVertically || block.getStyle().isAvoidPageBreakInside() && block.crossesPageBreak(c)) && !block.getStyle().isForcePageBreakBefore()) {
            if (clearedPage) {
                block.y -= clearDelta;
                block.calcCanvasLocation();
            }
            block.detach(c);
            Boxing.layout(c, block, content);
            c.getBlockFormattingContext().floatBox(c, block);
        }
    }
}

