/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.content.ContentUtil;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.LineBox;

public class Restyling {
    public static void restyleAll(LayoutContext c, BlockBox box) {
        if (box.element != null) {
            CalculatedStyle parentStyle = box.getStyle().getCalculatedStyle().getParent();
            c.initializeStyles(parentStyle);
        }
        Restyling.restyle(c, box);
    }

    private static void restyle(LayoutContext c, BlockBox box) {
        CascadedStyle style = c.getCss().getCascadedStyle(box.element, true);
        if (style == null) {
            style = CascadedStyle.emptyCascadedStyle;
        }
        c.pushStyle(style);
        CalculatedStyle calculatedStyle = c.getCurrentStyle();
        box.getStyle().setCalculatedStyle(calculatedStyle);
        CascadedStyle firstLine = null;
        if (ContentUtil.mayHaveFirstLine(calculatedStyle)) {
            firstLine = c.getCss().getPseudoElementStyle(box.element, "first-line");
        }
        if (firstLine != null) {
            c.getFirstLinesTracker().addStyle(firstLine);
        }
        if (box.containsLineBoxes()) {
            Restyling.restyleInlineContext(c, box);
        } else {
            Restyling.restyleBlockContext(c, box);
        }
        if (firstLine != null) {
            c.getFirstLinesTracker().removeLast();
        }
    }

    private static void restyle(LayoutContext c, LineBox line) {
        Box child;
        int j;
        for (j = 0; j < line.getChildCount(); ++j) {
            child = line.getChild(j);
            if (c.getFirstLinesTracker().hasStyles() && line.isFirstLine()) {
                c.getFirstLinesTracker().pushStyles(c);
            }
            if (child instanceof InlineBox) {
                Restyling.restyle(c, (InlineBox)child);
                continue;
            }
            Restyling.restyle(c, (BlockBox)child);
        }
        for (j = 0; j < line.getNonFlowContent().size(); ++j) {
            child = (BlockBox)line.getNonFlowContent().get(j);
            Restyling.restyle(c, (BlockBox)child);
        }
        if (c.getFirstLinesTracker().hasStyles() && line.isFirstLine()) {
            c.getFirstLinesTracker().popStyles(c);
            c.getFirstLinesTracker().clearStyles();
        }
    }

    private static void restyle(LayoutContext c, InlineBox iB) {
        c.pushStyle(c.getCss().getCascadedStyle(iB.element, true));
        iB.getStyle().setCalculatedStyle(c.getCurrentStyle());
        iB.calculateTextDecoration(c);
        for (int i = 0; i < iB.getInlineChildCount(); ++i) {
            Object child = iB.getInlineChild(i);
            if (child instanceof InlineBox) {
                Restyling.restyle(c, (InlineBox)child);
                continue;
            }
            if (!(child instanceof BlockBox)) continue;
            Restyling.restyle(c, (BlockBox)child);
        }
        c.popStyle();
    }

    private static void restyleBlockContext(LayoutContext c, BlockBox box) {
        if (!box.isReplaced()) {
            for (int i = 0; i <= box.getChildCount(); ++i) {
                Box child = box.getChild(i);
                Restyling.restyle(c, (BlockBox)child);
            }
        }
    }

    private static void restyleInlineContext(LayoutContext c, Box block) {
        for (int i = 0; i < block.getChildCount(); ++i) {
            LineBox line = (LineBox)block.getChild(i);
            Restyling.restyle(c, line);
        }
    }
}

