/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import org.xhtmlrenderer.context.AWTFontResolver;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.Java2DTextRenderer;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.swing.RootPanel;
import org.xhtmlrenderer.util.XRLog;

public class SharedContext {
    private TextRenderer text_renderer;
    private String media;
    private UserAgentCallback uac;
    private boolean interactive = true;
    private float dpi;
    private static final int MM__PER__CM = 10;
    private static final float CM__PER__IN = 2.54f;
    private float mm_per_dot;
    private static final float DEFAULT_DPI = 72.0f;
    private boolean print;
    private int dotsPerPixel = 1;
    protected FontResolver font_resolver = new AWTFontResolver();
    protected StyleReference css;
    protected boolean debug_draw_boxes;
    protected boolean debug_draw_line_boxes;
    protected boolean debug_draw_inline_boxes;
    protected boolean debug_draw_font_metrics;
    protected RootPanel canvas;
    protected Box selection_start;
    protected Box selection_end;
    protected int selection_end_x;
    protected int selection_start_x;
    protected boolean in_selection = false;
    private NamespaceHandler namespaceHandler;
    private Map id_map;
    private Map namedAnchors;

    public SharedContext(UserAgentCallback uac) {
        this.setMedia("screen");
        this.uac = uac;
        this.setCss(new StyleReference(uac));
        XRLog.render("Using CSS implementation from: " + this.getCss().getClass().getName());
        this.setTextRenderer(new Java2DTextRenderer());
        try {
            this.setDPI(Toolkit.getDefaultToolkit().getScreenResolution());
        }
        catch (HeadlessException e) {
            this.setDPI(72.0f);
        }
    }

    public LayoutContext newLayoutContextInstance(Rectangle extents) {
        LayoutContext c = new LayoutContext(this, extents);
        return c;
    }

    public RenderingContext newRenderingContextInstance() {
        RenderingContext c = new RenderingContext(this);
        return c;
    }

    public FontResolver getFontResolver() {
        return this.font_resolver;
    }

    public void flushFonts() {
        this.font_resolver.flushCache();
    }

    public String getMedia() {
        return this.media;
    }

    public TextRenderer getTextRenderer() {
        return this.text_renderer;
    }

    public boolean debugDrawBoxes() {
        return this.debug_draw_boxes;
    }

    public boolean debugDrawLineBoxes() {
        return this.debug_draw_line_boxes;
    }

    public boolean debugDrawInlineBoxes() {
        return this.debug_draw_inline_boxes;
    }

    public boolean debugDrawFontMetrics() {
        return this.debug_draw_font_metrics;
    }

    public void setDebug_draw_boxes(boolean debug_draw_boxes) {
        this.debug_draw_boxes = debug_draw_boxes;
    }

    public void setDebug_draw_line_boxes(boolean debug_draw_line_boxes) {
        this.debug_draw_line_boxes = debug_draw_line_boxes;
    }

    public void setDebug_draw_inline_boxes(boolean debug_draw_inline_boxes) {
        this.debug_draw_inline_boxes = debug_draw_inline_boxes;
    }

    public void setDebug_draw_font_metrics(boolean debug_draw_font_metrics) {
        this.debug_draw_font_metrics = debug_draw_font_metrics;
    }

    public void clearSelection() {
        int selection_end_x1;
        int selection_start_x1;
        this.selection_end = null;
        this.selection_start = null;
        this.selection_start_x = selection_start_x1 = -1;
        this.selection_end_x = selection_end_x1 = -1;
    }

    public void updateSelection(Box box) {
        if (box == this.selection_end) {
            this.in_selection = false;
        }
        if (box == this.selection_start) {
            this.in_selection = true;
        }
        if (box == this.selection_end && box == this.selection_start) {
            this.in_selection = false;
        }
    }

    public boolean inSelection(Box box) {
        if (box == this.selection_end || box == this.selection_start) {
            return true;
        }
        return this.in_selection;
    }

    public Box getSelectionStart() {
        return this.selection_start;
    }

    public Box getSelectionEnd() {
        return this.selection_end;
    }

    public int getSelectionStartX() {
        return this.selection_start_x;
    }

    public int getSelectionEndX() {
        return this.selection_end_x;
    }

    public void setSelectionStart(Box box, int x) {
        this.selection_start = box;
        this.selection_start_x = x;
    }

    public void setSelectionEnd(Box box, int x) {
        this.selection_end = box;
        this.selection_end_x = x;
    }

    public StyleReference getCss() {
        return this.css;
    }

    public void setCss(StyleReference css) {
        this.css = css;
    }

    public RootPanel getCanvas() {
        return this.canvas;
    }

    public void setCanvas(RootPanel canvas) {
        this.canvas = canvas;
    }

    public Rectangle getFixedRectangle() {
        Rectangle rect = this.getCanvas().getFixedRectangle();
        rect.translate(this.getCanvas().getX(), this.getCanvas().getY());
        return rect;
    }

    public void setNamespaceHandler(NamespaceHandler nh) {
        this.namespaceHandler = nh;
    }

    public NamespaceHandler getNamespaceHandler() {
        return this.namespaceHandler;
    }

    public void addIDBox(String id, Box box) {
        if (this.id_map == null) {
            this.id_map = new HashMap();
        }
        this.id_map.put(id, box);
    }

    public void addNamedAnchor(String name, Box box) {
        if (this.namedAnchors == null) {
            this.namedAnchors = new HashMap();
        }
        if (!this.namedAnchors.containsKey(name)) {
            this.namedAnchors.put(name, box);
        }
    }

    public void removeNamedAnchor(String name) {
        if (this.namedAnchors != null) {
            this.namedAnchors.remove(name);
        }
    }

    public Box getNamedAnchor(String name) {
        if (this.namedAnchors == null) {
            return null;
        }
        return (Box)this.namedAnchors.get(name);
    }

    public Box getIDBox(String id) {
        if (this.id_map == null) {
            this.id_map = new HashMap();
        }
        return (Box)this.id_map.get(id);
    }

    public void setTextRenderer(TextRenderer text_renderer) {
        this.text_renderer = text_renderer;
    }

    private void setMedia(String media) {
        this.media = media;
    }

    public UserAgentCallback getUac() {
        return this.uac;
    }

    public float getDPI() {
        return this.dpi;
    }

    public void setDPI(float dpi) {
        this.dpi = dpi;
        this.mm_per_dot = 25.4f / dpi;
    }

    public float getMmPerPx() {
        return this.mm_per_dot;
    }

    public FSFont getFont(FontSpecification spec) {
        return this.getFontResolver().resolveFont(this, spec);
    }

    public float getFontSizeForXHeight(FontContext fontContext, FontSpecification parent, FontSpecification desired, float xHeight) {
        float bestGuess = this.getFontResolver().resolveFont(this, parent).getSize2D();
        float bestHeight = this.getXHeight(fontContext, parent);
        float nextGuess = bestGuess * xHeight / bestHeight;
        while (true) {
            desired.size = nextGuess;
            float nextHeight = this.getXHeight(fontContext, desired);
            if (!(Math.abs(nextHeight - xHeight) < Math.abs(bestHeight - xHeight))) break;
            bestGuess = nextGuess;
            bestHeight = nextHeight;
            nextGuess = bestGuess * xHeight / nextHeight;
        }
        return bestGuess;
    }

    public float getXHeight(FontContext fontContext, FontSpecification fs) {
        FSFont font = this.getFontResolver().resolveFont(this, fs);
        FSFontMetrics fm = this.getTextRenderer().getFSFontMetrics(fontContext, font, " ");
        float sto = fm.getStrikethroughOffset();
        return 2.0f * Math.abs(sto) + fm.getStrikethroughThickness();
    }

    public String getBaseURL() {
        return this.uac.getBaseURL();
    }

    public void setBaseURL(String url) {
        this.uac.setBaseURL(url);
    }

    public boolean isPaged() {
        if (this.media.equals("print")) {
            return true;
        }
        if (this.media.equals("projection")) {
            return true;
        }
        if (this.media.equals("embossed")) {
            return true;
        }
        if (this.media.equals("handheld")) {
            return true;
        }
        return this.media.equals("tv");
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
        if (print) {
            this.setMedia("print");
        } else {
            this.setMedia("screen");
        }
    }

    public void setFontMapping(String name, Font font) {
        FontResolver resolver = this.getFontResolver();
        if (resolver instanceof AWTFontResolver) {
            ((AWTFontResolver)resolver).setFontMapping(name, font);
        }
    }

    public void setFontResolver(FontResolver resolver) {
        this.font_resolver = resolver;
    }

    public int getDotsPerPixel() {
        return this.dotsPerPixel;
    }

    public void setDotsPerPixel(int pixelsPerDot) {
        this.dotsPerPixel = pixelsPerDot;
    }
}

