/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.layout.InlineBoxMeasurements;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.InlineBox;

public class VerticalAlignContext {
    private List measurements = new ArrayList();
    private int inlineTop;
    private boolean inlineTopSet = false;
    private int inlineBottom;
    private boolean inlineBottomSet = false;
    private int paintingTop;
    private boolean paintingTopSet = false;
    private int paintingBottom;
    private boolean paintingBottomSet = false;
    private List children = new ArrayList();
    private VerticalAlignContext parent = null;

    private void moveTrackedValues(int ty) {
        if (this.inlineTopSet) {
            this.inlineTop += ty;
        }
        if (this.inlineBottomSet) {
            this.inlineBottom += ty;
        }
        if (this.paintingTopSet) {
            this.paintingTop += ty;
        }
        if (this.paintingBottomSet) {
            this.paintingBottom += ty;
        }
    }

    public int getInlineBottom() {
        return this.inlineBottom;
    }

    public int getInlineTop() {
        return this.inlineTop;
    }

    public void updateInlineTop(int inlineTop) {
        if (!this.inlineTopSet || inlineTop < this.inlineTop) {
            this.inlineTop = inlineTop;
            this.inlineTopSet = true;
        }
    }

    public void updatePaintingTop(int paintingTop) {
        if (!this.paintingTopSet || paintingTop < this.paintingTop) {
            this.paintingTop = paintingTop;
            this.paintingTopSet = true;
        }
    }

    public void updateInlineBottom(int inlineBottom) {
        if (!this.inlineBottomSet || inlineBottom > this.inlineBottom) {
            this.inlineBottom = inlineBottom;
            this.inlineBottomSet = true;
        }
    }

    public void updatePaintingBottom(int paintingBottom) {
        if (!this.paintingBottomSet || paintingBottom > this.paintingBottom) {
            this.paintingBottom = paintingBottom;
            this.paintingBottomSet = true;
        }
    }

    public int getLineBoxHeight() {
        return this.inlineBottom - this.inlineTop;
    }

    public void pushMeasurements(InlineBoxMeasurements measurements) {
        this.measurements.add(measurements);
        if (measurements.isContainsContent()) {
            this.updateInlineTop(measurements.getInlineTop());
            this.updateInlineBottom(measurements.getInlineBottom());
            this.updatePaintingTop(measurements.getPaintingTop());
            this.updatePaintingBottom(measurements.getPaintingBottom());
        }
    }

    public InlineBoxMeasurements getParentMeasurements() {
        return (InlineBoxMeasurements)this.measurements.get(this.measurements.size() - 1);
    }

    public void popMeasurements() {
        this.measurements.remove(this.measurements.size() - 1);
    }

    public int getPaintingBottom() {
        return this.paintingBottom;
    }

    public int getPaintingTop() {
        return this.paintingTop;
    }

    public VerticalAlignContext createChild(Box root) {
        VerticalAlignContext result = new VerticalAlignContext();
        VerticalAlignContext vaRoot = this.getRoot();
        result.setParent(vaRoot);
        InlineBoxMeasurements initial = (InlineBoxMeasurements)vaRoot.measurements.get(0);
        result.pushMeasurements(initial);
        if (vaRoot.children == null) {
            vaRoot.children = new ArrayList();
        }
        vaRoot.children.add(new ChildContextData(root, result));
        return result;
    }

    public List getChildren() {
        return this.children == null ? Collections.EMPTY_LIST : this.children;
    }

    public VerticalAlignContext getParent() {
        return this.parent;
    }

    public void setParent(VerticalAlignContext parent) {
        this.parent = parent;
    }

    private VerticalAlignContext getRoot() {
        VerticalAlignContext result = this;
        return result.getParent() != null ? result.getParent() : this;
    }

    private void merge(VerticalAlignContext context) {
        this.updateInlineBottom(context.getInlineBottom());
        this.updateInlineTop(context.getInlineTop());
        this.updatePaintingBottom(context.getPaintingBottom());
        this.updatePaintingTop(context.getPaintingTop());
    }

    public void alignChildren() {
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ChildContextData data = (ChildContextData)children.get(i);
            data.align();
            this.merge(data.getVerticalAlignContext());
        }
    }

    private static final class ChildContextData {
        private Box root;
        private VerticalAlignContext verticalAlignContext;

        public ChildContextData() {
        }

        public ChildContextData(Box root, VerticalAlignContext vaContext) {
            this.root = root;
            this.verticalAlignContext = vaContext;
        }

        public Box getRoot() {
            return this.root;
        }

        public void setRoot(Box root) {
            this.root = root;
        }

        public VerticalAlignContext getVerticalAlignContext() {
            return this.verticalAlignContext;
        }

        public void setVerticalAlignContext(VerticalAlignContext verticalAlignContext) {
            this.verticalAlignContext = verticalAlignContext;
        }

        private void moveContextContents(int ty) {
            this.moveInlineContents(this.root, ty);
        }

        private void moveInlineContents(Box box, int ty) {
            if (this.canBeMoved(box)) {
                box.y += ty;
                if (box instanceof InlineBox) {
                    InlineBox iB = (InlineBox)box;
                    for (int i = 0; i < iB.getInlineChildCount(); ++i) {
                        Object child = iB.getInlineChild(i);
                        if (!(child instanceof Box)) continue;
                        this.moveInlineContents((Box)child, ty);
                    }
                }
            }
        }

        private boolean canBeMoved(Box box) {
            IdentValue vAlign = box.getStyle().getCalculatedStyle().getIdent(CSSName.VERTICAL_ALIGN);
            return box == this.root || vAlign != IdentValue.TOP && vAlign != IdentValue.BOTTOM;
        }

        public void align() {
            IdentValue vAlign = this.root.getStyle().getCalculatedStyle().getIdent(CSSName.VERTICAL_ALIGN);
            int delta = 0;
            if (vAlign == IdentValue.TOP) {
                delta = this.verticalAlignContext.getRoot().getInlineTop() - this.verticalAlignContext.getInlineTop();
            } else if (vAlign == IdentValue.BOTTOM) {
                delta = this.verticalAlignContext.getRoot().getInlineBottom() - this.verticalAlignContext.getInlineBottom();
            } else {
                throw new RuntimeException("internal error");
            }
            this.verticalAlignContext.moveTrackedValues(delta);
            this.moveContextContents(delta);
        }
    }
}

