/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout.content;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.content.AbstractCollapsableContent;
import org.xhtmlrenderer.layout.content.CollapsableContent;
import org.xhtmlrenderer.layout.content.ContentUtil;
import org.xhtmlrenderer.layout.content.FirstLetterStyle;
import org.xhtmlrenderer.layout.content.FirstLineStyle;
import org.xhtmlrenderer.layout.content.TableCaptionContent;
import org.xhtmlrenderer.layout.content.TableColumnContent;
import org.xhtmlrenderer.layout.content.TableColumnGroupContent;
import org.xhtmlrenderer.layout.content.TableFooterGroupContent;
import org.xhtmlrenderer.layout.content.TableHeaderGroupContent;
import org.xhtmlrenderer.layout.content.TableRowContent;
import org.xhtmlrenderer.layout.content.TableRowGroupContent;
import org.xhtmlrenderer.layout.content.WhitespaceStripper;

public class TableContent
extends AbstractCollapsableContent
implements CollapsableContent {
    private final Element _elem;
    private final CascadedStyle _style;
    private final LinkedList _children;
    private boolean _topMarginCollapsed;
    private boolean _bottomMarginCollapsed;

    TableContent(Element e, CascadedStyle style) {
        this._elem = e;
        this._style = style;
        this._children = null;
    }

    TableContent() {
        this._elem = null;
        this._style = null;
        this._children = new LinkedList();
    }

    void addChild(Element e) {
        this._children.addLast(e);
    }

    public String toString() {
        return "Table: " + this._elem.getNodeName();
    }

    public Element getElement() {
        return this._elem;
    }

    public CascadedStyle getStyle() {
        return this._style;
    }

    protected List makeChildContent(LayoutContext c) {
        LinkedList<Object> contentList = new LinkedList<Object>();
        FirstLineStyle firstLineStyle = null;
        FirstLetterStyle firstLetterStyle = null;
        if (this._elem != null) {
            CascadedStyle firstLetter;
            CascadedStyle firstLine;
            c.pushStyle(this._style);
            if (ContentUtil.mayHaveFirstLine(c.getCurrentStyle()) && (firstLine = c.getCss().getPseudoElementStyle(this._elem, "first-line")) != null) {
                firstLineStyle = new FirstLineStyle(firstLine);
            }
            if (ContentUtil.mayHaveFirstLetter(c.getCurrentStyle()) && (firstLetter = c.getCss().getPseudoElementStyle(this._elem, "first-letter")) != null) {
                firstLetterStyle = new FirstLetterStyle(firstLetter);
            }
            c.popStyle();
        }
        Iterator childIterator = this.getChildIterator();
        TableRowContent anonymousRow = null;
        while (childIterator.hasNext()) {
            Node curr = (Node)childIterator.next();
            if (curr.getNodeType() != 1 && curr.getNodeType() != 3) continue;
            if (curr.getNodeType() == 3) {
                String text = curr.getNodeValue();
                if ((text = WhitespaceStripper.collapseWhitespace(IdentValue.NORMAL, text, true)).equals("")) continue;
                if (anonymousRow == null) {
                    anonymousRow = new TableRowContent();
                    contentList.add(anonymousRow);
                }
                anonymousRow.addChild(curr);
                continue;
            }
            Element elem = (Element)curr;
            CascadedStyle style = c.getCss().getCascadedStyle(elem, true);
            c.pushStyle(style);
            IdentValue display = c.getCurrentStyle().getIdent(CSSName.DISPLAY);
            if (display != IdentValue.TABLE_ROW && display != IdentValue.TABLE_CAPTION && display != IdentValue.TABLE_COLUMN && display != IdentValue.TABLE_COLUMN_GROUP && display != IdentValue.TABLE_FOOTER_GROUP && display != IdentValue.TABLE_HEADER_GROUP && display != IdentValue.TABLE_ROW_GROUP) {
                if (anonymousRow == null) {
                    anonymousRow = new TableRowContent();
                    contentList.add(anonymousRow);
                }
                anonymousRow.addChild(elem);
                c.popStyle();
                continue;
            }
            anonymousRow = null;
            if (display == IdentValue.TABLE_ROW) {
                contentList.add(new TableRowContent(elem, style));
                c.popStyle();
                continue;
            }
            if (display == IdentValue.TABLE_CAPTION) {
                contentList.add(new TableCaptionContent(elem, style));
                c.popStyle();
                continue;
            }
            if (display == IdentValue.TABLE_COLUMN) {
                contentList.add(new TableColumnContent(elem, style));
                c.popStyle();
                continue;
            }
            if (display == IdentValue.TABLE_COLUMN_GROUP) {
                contentList.add(new TableColumnGroupContent(elem, style));
                c.popStyle();
                continue;
            }
            if (display == IdentValue.TABLE_FOOTER_GROUP) {
                contentList.add(new TableFooterGroupContent(elem, style));
                c.popStyle();
                continue;
            }
            if (display == IdentValue.TABLE_HEADER_GROUP) {
                contentList.add(new TableHeaderGroupContent(elem, style));
                c.popStyle();
                continue;
            }
            if (display != IdentValue.TABLE_ROW_GROUP) continue;
            contentList.add(new TableRowGroupContent(elem, style));
            c.popStyle();
        }
        if (firstLetterStyle != null) {
            contentList.addFirst(firstLetterStyle);
        }
        if (firstLineStyle != null) {
            contentList.addFirst(firstLineStyle);
        }
        return contentList;
    }

    private Iterator getChildIterator() {
        if (this._children != null) {
            return this._children.iterator();
        }
        return new Iterator(){
            NodeList nl;
            int i;
            {
                this.nl = TableContent.this._elem.getChildNodes();
                this.i = 0;
            }

            public boolean hasNext() {
                return this.i < this.nl.getLength();
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.nl.item(this.i++);
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isTopMarginCollapsed() {
        return this._topMarginCollapsed;
    }

    public void setTopMarginCollapsed(boolean topMarginCollapsed) {
        this._topMarginCollapsed = topMarginCollapsed;
    }

    public boolean mayCollapseInto() {
        return false;
    }

    public boolean isBottomMarginCollapsed() {
        return this._bottomMarginCollapsed;
    }

    public void setBottomMarginCollapsed(boolean bottomMarginCollapsed) {
        this._bottomMarginCollapsed = bottomMarginCollapsed;
    }
}

