/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.BookmarkElement;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.render.BlockBox;

public class ITextReplacedElementFactory
implements ReplacedElementFactory {
    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.element;
        if (e == null) {
            return null;
        }
        if (e.getNodeName().equals("img")) {
            FSImage fsImage = uac.getImageResource(e.getAttribute("src")).getImage();
            if (fsImage != null) {
                if (cssWidth != -1 || cssHeight != -1) {
                    fsImage.scale(cssWidth, cssHeight);
                }
                return new ITextImageElement(fsImage);
            }
        } else if (e.getNodeName().equals("bookmark")) {
            BookmarkElement result = new BookmarkElement();
            if (e.hasAttribute("name")) {
                String name = e.getAttribute("name");
                c.addNamedAnchor(name, box);
                result.setAnchorName(name);
            }
            return result;
        }
        return null;
    }
}

