/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.render.BorderPainter;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.TextDecoration;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.Uu;

public abstract class AbstractOutputDevice
implements OutputDevice {
    protected abstract void drawLine(int var1, int var2, int var3, int var4);

    public void drawText(RenderingContext c, InlineText inlineText) {
        InlineBox iB = inlineText.getParent();
        String text = inlineText.getSubstring();
        if (text != null && text.length() > 0) {
            this.setColor(iB.getStyle().getCalculatedStyle().getColor());
            this.setFont(iB.getStyle().getCalculatedStyle().getFSFont(c));
            c.getTextRenderer().drawString(c.getOutputDevice(), text, iB.getAbsX() + inlineText.getX(), iB.getAbsY() + iB.getBaseline());
        }
        if (c.debugDrawFontMetrics()) {
            this.drawFontMetrics(c, inlineText);
        }
    }

    private void drawFontMetrics(RenderingContext c, InlineText inlineText) {
        InlineBox iB = inlineText.getParent();
        String text = inlineText.getSubstring();
        this.setColor(new Color(255, 51, 255));
        FSFontMetrics fm = iB.getStyle().getFSFontMetrics(null);
        int width = c.getTextRenderer().getWidth(c.getFontContext(), iB.getStyle().getCalculatedStyle().getFSFont(c), text);
        int x = iB.getAbsX() + inlineText.getX();
        int y = iB.getAbsY() + iB.getBaseline();
        this.drawLine(x, y, x + width, y);
        this.drawLine(x, y += (int)Math.ceil(fm.getDescent()), x + width, y);
        y -= (int)Math.ceil(fm.getDescent());
        this.drawLine(x, y -= (int)Math.ceil(fm.getAscent()), x + width, y);
    }

    public void drawTextDecoration(RenderingContext c, InlineBox iB) {
        this.setColor(iB.getStyle().getCalculatedStyle().getColor());
        Rectangle edge = iB.getContentAreaEdge(iB.getAbsX(), iB.getAbsY(), c);
        this.fillRect(edge.x, iB.getAbsY() + iB.getTextDecoration().getOffset(), edge.width, iB.getTextDecoration().getThickness());
    }

    public void drawTextDecoration(RenderingContext c, LineBox lineBox) {
        this.setColor(lineBox.getStyle().getCalculatedStyle().getColor());
        Box parent = lineBox.getParent();
        TextDecoration textDecoration = lineBox.getTextDecoration();
        if (parent.getStyle().getCalculatedStyle().isIdent(CSSName.FS_TEXT_DECORATION_EXTENT, IdentValue.BLOCK)) {
            this.fillRect(lineBox.getAbsX(), lineBox.getAbsY() + textDecoration.getOffset(), parent.getAbsX() + parent.tx + parent.getContentWidth() - lineBox.getAbsX(), textDecoration.getThickness());
        } else {
            this.fillRect(lineBox.getAbsX(), lineBox.getAbsY() + textDecoration.getOffset(), lineBox.getContentWidth(), textDecoration.getThickness());
        }
    }

    public void drawDebugOutline(RenderingContext c, Box box, Color color) {
        this.setColor(color);
        Rectangle rect = box.getBounds(box.getAbsX(), box.getAbsY(), c, 0, 0);
        --rect.height;
        --rect.width;
        this.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void paintBorder(RenderingContext c, Box box) {
        if (!box.getStyle().isVisible()) {
            return;
        }
        Rectangle borderBounds = box.getPaintingBorderEdge(c);
        if (!c.isPrint() && box.getState() != 3) {
            borderBounds.height += c.getCanvas().getHeight();
        }
        BorderPainter.paint(borderBounds, box.getBorderSides(), box.getStyle().getCalculatedStyle(), c, 0);
    }

    public void paintBorder(RenderingContext c, CalculatedStyle style, Rectangle edge, int sides) {
        BorderPainter.paint(edge, sides, style, c, 0);
    }

    private FSImage getBackgroundImage(RenderingContext c, Box box) {
        String uri = box.getStyle().getCalculatedStyle().getStringProperty(CSSName.BACKGROUND_IMAGE);
        if (!uri.equals("none")) {
            try {
                return c.getUac().getImageResource(uri).getImage();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Uu.p(ex);
            }
        }
        return null;
    }

    public void paintBackground(RenderingContext c, Box box) {
        if (!Configuration.isTrue("xr.renderer.draw.backgrounds", true)) {
            return;
        }
        if (!box.getStyle().isVisible()) {
            return;
        }
        Color backgroundColor = box.getStyle().getCalculatedStyle().getBackgroundColor();
        FSImage backgroundImage = this.getBackgroundImage(c, box);
        if ((backgroundColor == null || backgroundColor.equals(TRANSPARENT)) && backgroundImage == null) {
            return;
        }
        Rectangle backgroundBounds = box.getPaintingBorderEdge(c);
        if (!c.isPrint() && box.getState() != 3) {
            backgroundBounds.height += c.getCanvas().getHeight();
        }
        if (backgroundColor != null && !backgroundColor.equals(TRANSPARENT)) {
            this.setColor(backgroundColor);
            this.fillRect(backgroundBounds.x, backgroundBounds.y, backgroundBounds.width, backgroundBounds.height);
        }
        int xoff = 0;
        int yoff = 0;
        if (backgroundImage != null) {
            Shape oldclip = this.getClip();
            if (box.getStyle().isFixedBackground() && !c.isPrint()) {
                yoff = c.getCanvas().getLocation().y;
                this.setClip(c.getCanvas().getVisibleRect());
            }
            this.clip(backgroundBounds);
            int imageWidth = backgroundImage.getWidth();
            int imageHeight = backgroundImage.getHeight();
            Point bgOffset = box.getStyle().getCalculatedStyle().getBackgroundPosition(backgroundBounds.width - imageWidth, backgroundBounds.height - imageHeight, c);
            this.tileFill(backgroundImage, backgroundBounds, xoff += bgOffset.x, -(yoff -= bgOffset.y), box.getStyle().isHorizontalBackgroundRepeat(), box.getStyle().isVerticalBackgroundRepeat());
            this.setClip(oldclip);
        }
    }

    private void tileFill(FSImage img, Rectangle rect, int xoff, int yoff, boolean horiz, boolean vert) {
        int iwidth = img.getWidth();
        int iheight = img.getHeight();
        int rwidth = rect.width;
        int rheight = rect.height;
        if (horiz) {
            xoff = xoff % iwidth - iwidth;
            rwidth += iwidth;
        } else {
            rwidth = iwidth;
        }
        if (vert) {
            yoff = yoff % iheight - iheight;
            rheight += iheight;
        } else {
            rheight = iheight;
        }
        for (int i = 0; i < rwidth; i += iwidth) {
            for (int j = 0; j < rheight; j += iheight) {
                this.drawImage(img, i + rect.x + xoff, j + rect.y + yoff);
            }
        }
    }
}

