/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.Style;
import org.xhtmlrenderer.util.XRLog;

public abstract class Box {
    public Element element;
    public int x;
    public int y;
    private int absY;
    private int absX;
    public int contentWidth;
    public int rightMBP = 0;
    public int leftMBP = 0;
    public int height;
    private Layer layer = null;
    private Layer containingLayer;
    private Box parent;
    private List boxes;
    public int tx;
    public int ty;
    private Style style;
    private Box containingBlock;
    private Dimension relativeOffset;
    public static final int NOTHING = 0;
    public static final int FLUX = 1;
    public static final int CHILDREN_FLUX = 2;
    public static final int DONE = 3;
    private int state = 0;

    public int getWidth() {
        return this.contentWidth + this.leftMBP + this.rightMBP;
    }

    public boolean contains(int x, int y) {
        return x >= 0 && x <= 0 + this.getWidth() && y >= 0 && y <= 0 + this.height;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Box: ");
        sb.append(" (" + this.getAbsX() + "," + this.getAbsY() + ")->(" + this.getWidth() + " x " + this.height + ")");
        return sb.toString();
    }

    public void addChild(LayoutContext c, Box child) {
        if (this.boxes == null) {
            this.boxes = new ArrayList();
        }
        if (child == null) {
            throw new NullPointerException("trying to add null child");
        }
        child.setParent(this);
        this.boxes.add(child);
        child.initContainingLayer(c);
    }

    public void removeAllChildren() {
        if (this.boxes != null) {
            this.boxes.clear();
        }
    }

    public void removeChild(Box child) {
        if (this.boxes != null) {
            this.boxes.remove(child);
        }
    }

    public void removeChild(int i) {
        if (this.boxes != null) {
            this.boxes.remove(i);
        }
    }

    public void setParent(Box box) {
        this.parent = box;
    }

    public int getHeight() {
        return this.height;
    }

    public Box getParent() {
        return this.parent;
    }

    public int getChildCount() {
        return this.boxes == null ? 0 : this.boxes.size();
    }

    public Box getChild(int i) {
        if (this.boxes == null) {
            throw new IndexOutOfBoundsException();
        }
        return (Box)this.boxes.get(i);
    }

    public Iterator getChildIterator() {
        if (this.boxes == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.boxes.iterator();
    }

    public String getTestString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" " + this.hashCode() + " ");
        if (this instanceof LineBox) {
            sb.append("line:");
        } else if (this instanceof InlineBox) {
            sb.append("inline:");
        } else {
            sb.append("box:");
        }
        sb.append("element:");
        if (this.element != null) {
            sb.append(this.element.getNodeName());
        } else {
            sb.append("null");
        }
        sb.append("-box(" + this.x + "," + this.y + ")-(" + this.getWidth() + "x" + this.height + ")");
        if (this.style.isFixed()) {
            sb.append("-fixed");
        }
        if (this.style.isAbsolute()) {
            sb.append("-absolute");
        }
        if (this.style.isFloated()) {
            sb.append("-floated");
        }
        sb.append("-value:");
        if (this.element != null) {
            sb.append(this.element.getNodeValue());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "NOTHING";
            }
            case 1: {
                return "FLUX";
            }
            case 2: {
                return "CHILDREN_FLUX";
            }
            case 3: {
                return "DONE";
            }
        }
        return "unknown";
    }

    public final Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Box getContainingBlock() {
        return this.containingBlock == null ? this.getParent() : this.containingBlock;
    }

    public void setContainingBlock(Box containingBlock) {
        this.containingBlock = containingBlock;
    }

    public Rectangle getBounds(int left, int top, CssContext cssCtx, int tx, int ty) {
        Rectangle result = this.getBorderEdge(left, top, cssCtx);
        this.addBackMargins(cssCtx, result);
        result.translate(tx, ty);
        return result;
    }

    public Rectangle getBounds(CssContext cssCtx, int tx, int ty) {
        return this.getBounds(this.x, this.y, cssCtx, tx, ty);
    }

    public Rectangle getPaintingBorderEdge(CssContext cssCtx) {
        return this.getBorderEdge(this.getAbsX(), this.getAbsY(), cssCtx);
    }

    public boolean intersects(CssContext cssCtx, Shape clip) {
        return clip == null || clip.intersects(this.getBorderEdge(this.getAbsX(), this.getAbsY(), cssCtx));
    }

    private void addBackMargins(CssContext cssCtx, Rectangle bounds) {
        RectPropertySet margin = this.getStyle().getMarginWidth(cssCtx);
        if (margin.top() > 0.0f) {
            bounds.y = (int)((float)bounds.y - margin.top());
            bounds.height = (int)((float)bounds.height + margin.top());
        }
        if (margin.right() > 0.0f) {
            bounds.width = (int)((float)bounds.width + margin.right());
        }
        if (margin.bottom() > 0.0f) {
            bounds.height = (int)((float)bounds.height + margin.bottom());
        }
        if (margin.left() > 0.0f) {
            bounds.x = (int)((float)bounds.x - margin.left());
            bounds.width = (int)((float)bounds.width + margin.left());
        }
    }

    protected Rectangle getBorderEdge(int left, int top, CssContext cssCtx) {
        RectPropertySet margin = this.getStyle().getMarginWidth(cssCtx);
        Rectangle result = new Rectangle(left + (int)margin.left(), top + (int)margin.top(), this.getWidth() - (int)margin.left() - (int)margin.right(), this.getHeight() - (int)margin.top() - (int)margin.bottom());
        return result;
    }

    public Rectangle getPaddingEdge(int left, int top, CssContext cssCtx) {
        RectPropertySet margin = this.getStyle().getMarginWidth(cssCtx);
        BorderPropertySet border = this.getStyle().getCalculatedStyle().getBorder(cssCtx);
        Rectangle result = new Rectangle(left + (int)margin.left() + (int)border.left(), top + (int)margin.top() + (int)border.top(), this.getWidth() - (int)margin.width() - (int)border.width(), this.getHeight() - (int)margin.height() - (int)border.height());
        return result;
    }

    public Rectangle getContentAreaEdge(int left, int top, CssContext cssCtx) {
        RectPropertySet margin = this.getStyle().getMarginWidth(cssCtx);
        BorderPropertySet border = this.getStyle().getCalculatedStyle().getBorder(cssCtx);
        RectPropertySet padding = this.getStyle().getPaddingWidth(cssCtx);
        Rectangle result = new Rectangle(left + (int)margin.left() + (int)border.left() + (int)padding.left(), top + (int)margin.top() + (int)border.top() + (int)padding.top(), this.getWidth() - (int)margin.width() - (int)border.width() - (int)padding.width(), this.getHeight() - (int)margin.height() - (int)border.height() - (int)padding.height());
        return result;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public Dimension positionRelative(CssContext cssCtx) {
        int initialX = this.x;
        int initialY = this.y;
        CalculatedStyle style = this.getStyle().getCalculatedStyle();
        if (!style.isIdent(CSSName.LEFT, IdentValue.AUTO)) {
            this.x = (int)((float)this.x + style.getFloatPropertyProportionalWidth(CSSName.LEFT, this.getContainingBlock().getContentWidth(), cssCtx));
        } else if (!style.isIdent(CSSName.RIGHT, IdentValue.AUTO)) {
            this.x = (int)((float)this.x + style.getFloatPropertyProportionalWidth(CSSName.RIGHT, this.getContainingBlock().getContentWidth(), cssCtx));
        }
        int cbContentHeight = 0;
        if (!this.getContainingBlock().getStyle().isAutoHeight()) {
            CalculatedStyle cbStyle = this.getContainingBlock().getStyle().getCalculatedStyle();
            cbContentHeight = (int)cbStyle.getFloatPropertyProportionalHeight(CSSName.HEIGHT, 0.0f, cssCtx);
        }
        if (!style.isIdent(CSSName.TOP, IdentValue.AUTO)) {
            this.y = (int)((float)this.y + style.getFloatPropertyProportionalHeight(CSSName.TOP, cbContentHeight, cssCtx));
        } else if (!style.isIdent(CSSName.BOTTOM, IdentValue.AUTO)) {
            this.y = (int)((float)this.y + style.getFloatPropertyProportionalHeight(CSSName.BOTTOM, cbContentHeight, cssCtx));
        }
        this.setRelativeOffset(new Dimension(this.x - initialX, this.y - initialY));
        return this.getRelativeOffset();
    }

    public void createDefaultStyle(LayoutContext c) {
        c.pushStyle(CascadedStyle.emptyCascadedStyle);
        this.setStyle(new Style(c.getCurrentStyle(), 0));
        c.popStyle();
    }

    public void setAbsY(int absY) {
        this.absY = absY;
    }

    public int getAbsY() {
        return this.absY;
    }

    public void setAbsX(int absX) {
        this.absX = absX;
    }

    public int getAbsX() {
        return this.absX;
    }

    public boolean isStyled() {
        return this.style != null;
    }

    public int getBorderSides() {
        return 15;
    }

    public void paintBorder(RenderingContext c) {
        c.getOutputDevice().paintBorder(c, this);
    }

    public void paintBackground(RenderingContext c) {
        c.getOutputDevice().paintBackground(c, this);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Layer getContainingLayer() {
        return this.containingLayer;
    }

    public void setContainingLayer(Layer containingLayer) {
        this.containingLayer = containingLayer;
    }

    public void initContainingLayer(LayoutContext c) {
        if (this.getLayer() != null) {
            this.setContainingLayer(this.getLayer());
        } else if (this.getContainingLayer() == null) {
            List content;
            if (this.getParent() == null || this.getParent().getContainingLayer() == null) {
                throw new RuntimeException("internal error");
            }
            this.setContainingLayer(this.getParent().getContainingLayer());
            if (c.getLayer().isInline() && (content = ((InlineBox)c.getLayer().getMaster()).getElementWithContent()).contains(this)) {
                this.setContainingLayer(c.getLayer());
            }
        }
    }

    public void connectChildrenToCurrentLayer(LayoutContext c) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box box = this.getChild(i);
            box.setContainingLayer(c.getLayer());
            box.connectChildrenToCurrentLayer(c);
        }
    }

    public List getElementBoxes(Element elem) {
        ArrayList<Box> result = new ArrayList<Box>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            if (child.element == elem) {
                result.add(child);
            }
            result.addAll(child.getElementBoxes(elem));
        }
        return result;
    }

    public void detach(LayoutContext c) {
        String anchorName;
        this.detachChildren(c);
        if (this.layer != null) {
            this.layer.detach();
            this.layer = null;
        }
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
        }
        if ((anchorName = c.getNamespaceHandler().getAnchorName(this.element)) != null) {
            c.removeNamedAnchor(anchorName);
        }
        this.setParent(null);
    }

    public void detachChildren(LayoutContext c, int start, int end) {
        for (int i = start; i <= end; ++i) {
            Box box = this.getChild(start);
            box.detach(c);
        }
    }

    protected void detachChildren(LayoutContext c) {
        int remaining = this.getChildCount();
        while (remaining-- > 0) {
            Box box = this.getChild(0);
            box.detach(c);
        }
    }

    public abstract void calcCanvasLocation();

    public void calcChildLocations() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            child.calcCanvasLocation();
            child.calcChildLocations();
        }
    }

    public int moveToNextPage(LayoutContext c) {
        if (c.isLayingOutTable()) {
            return 0;
        }
        PageBox page = c.getRootLayer().getFirstPage(c, this);
        if (page == null) {
            XRLog.layout(Level.WARNING, "Box has no page");
            return 0;
        }
        if (page.getTop() == this.getAbsY()) {
            return 0;
        }
        int delta = page.getBottom() - this.getAbsY();
        this.y += delta;
        if (page == c.getRootLayer().getLastPage()) {
            c.getRootLayer().addPage(c);
        }
        return delta;
    }

    public void expandToPageBottom(LayoutContext c) {
        if (c.isLayingOutTable()) {
            return;
        }
        PageBox page = c.getRootLayer().getLastPage(c, this);
        int delta = page.getBottom() - (this.getAbsY() + this.getStyle().getMarginBorderPadding(c, 3) + this.height);
        this.height += delta;
        if (page == c.getRootLayer().getLastPage()) {
            c.getRootLayer().addPage(c);
        }
    }

    public boolean crossesPageBreak(LayoutContext c) {
        if (c.isLayingOutTable()) {
            return false;
        }
        PageBox pageBox = c.getRootLayer().getFirstPage(c, this);
        if (pageBox == null) {
            return false;
        }
        return this.getAbsY() + this.getHeight() >= pageBox.getBottom();
    }

    public Dimension getRelativeOffset() {
        return this.relativeOffset;
    }

    public void setRelativeOffset(Dimension relativeOffset) {
        this.relativeOffset = relativeOffset;
    }

    public Box find(CssContext cssCtx, int absX, int absY) {
        Box result = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            result = child.find(cssCtx, absX, absY);
            if (result == null) continue;
            return result;
        }
        Rectangle edge = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), cssCtx);
        return edge.contains(absX, absY) ? this : null;
    }
}

