/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.BoxCollector;
import org.xhtmlrenderer.layout.InlineBoxing;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.AnonymousBlockBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.Style;
import org.xhtmlrenderer.render.TextDecoration;

public class InlineBox
extends Box
implements InlinePaintable {
    private int baseline;
    private boolean startsHere;
    private boolean endsHere;
    private List inlineChildren;
    private boolean pending;
    private int inlineWidth;
    private TextDecoration textDecoration;

    public InlineBox(Element elem, CalculatedStyle style, int cbWidth) {
        this();
        this.element = elem;
        this.setStyle(new Style(style, cbWidth));
        this.getStyle().setMarginTopOverride(0.0f);
        this.getStyle().setMarginBottomOverride(0.0f);
        this.markPending();
    }

    private InlineBox() {
        this.setState(3);
    }

    public InlineBox copyOf() {
        InlineBox result = new InlineBox();
        result.element = this.element;
        result.setStyle(this.getStyle());
        result.setHeight(this.getHeight());
        result.pending = this.pending;
        result.setContainingLayer(this.getContainingLayer());
        return result;
    }

    public void calculateHeight(LayoutContext c) {
        BorderPropertySet border = this.getStyle().getCalculatedStyle().getBorder(c);
        RectPropertySet padding = this.getStyle().getPaddingWidth(c);
        FSFontMetrics metrics = this.getStyle().getFSFontMetrics(c);
        this.setHeight((int)Math.ceil(border.top() + padding.top() + metrics.getAscent() + metrics.getDescent() + padding.bottom() + border.bottom()));
    }

    public int getBaseline() {
        return this.baseline;
    }

    public void setBaseline(int baseline) {
        this.baseline = baseline;
    }

    public int getInlineChildCount() {
        return this.inlineChildren == null ? 0 : this.inlineChildren.size();
    }

    public void addInlineChild(LayoutContext c, Object child) {
        this.addInlineChild(c, child, true);
    }

    public void addInlineChild(LayoutContext c, Object child, boolean callUnmarkPending) {
        if (this.inlineChildren == null) {
            this.inlineChildren = new ArrayList();
        }
        this.inlineChildren.add(child);
        if (callUnmarkPending && this.isPending()) {
            this.unmarkPending(c);
        }
        if (child instanceof Box) {
            Box b = (Box)child;
            b.setParent(this);
            b.initContainingLayer(c);
        } else if (child instanceof InlineText) {
            ((InlineText)child).setParent(this);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public List getInlineChildren() {
        return this.inlineChildren == null ? Collections.EMPTY_LIST : this.inlineChildren;
    }

    public Object getInlineChild(int i) {
        if (this.inlineChildren == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.inlineChildren.get(i);
    }

    public int getInlineWidth(CssContext cssCtx) {
        return this.inlineWidth;
    }

    public void prunePending() {
        if (this.getInlineChildCount() > 0) {
            Object child;
            for (int i = this.getInlineChildCount() - 1; i >= 0 && (child = this.getInlineChild(i)) instanceof InlineBox; --i) {
                InlineBox iB = (InlineBox)child;
                iB.prunePending();
                if (!iB.isPending()) break;
                this.removeChild(i);
            }
        }
    }

    public boolean isEndsHere() {
        return this.endsHere;
    }

    public void setEndsHere(boolean endsHere) {
        this.endsHere = endsHere;
    }

    public boolean isStartsHere() {
        return this.startsHere;
    }

    public void setStartsHere(boolean startsHere) {
        this.startsHere = startsHere;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void markPending() {
        this.pending = true;
    }

    private void unmarkPending(LayoutContext c) {
        InlineBox iB;
        this.pending = false;
        if (this.getParent() instanceof InlineBox && (iB = (InlineBox)this.getParent()).isPending()) {
            iB.unmarkPending(c);
        }
        this.setStartsHere(true);
        if (this.getStyle().requiresLayer()) {
            c.pushLayer(this);
            this.getLayer().setInline(true);
            this.connectChildrenToCurrentLayer(c);
        }
    }

    public void connectChildrenToCurrentLayer(LayoutContext c) {
        if (this.getInlineChildCount() > 0) {
            for (int i = 0; i < this.getInlineChildCount(); ++i) {
                Object obj = this.getInlineChild(i);
                if (!(obj instanceof Box)) continue;
                Box box = (Box)obj;
                box.setContainingLayer(c.getLayer());
                box.connectChildrenToCurrentLayer(c);
            }
        }
    }

    public void paintInline(RenderingContext c) {
        IdentValue val;
        if (!this.getStyle().isVisible()) {
            return;
        }
        this.paintBackground(c);
        this.paintBorder(c);
        if (c.debugDrawInlineBoxes()) {
            this.paintDebugOutline(c);
        }
        if (this.textDecoration != null && ((val = this.getStyle().getCalculatedStyle().getIdent(CSSName.TEXT_DECORATION)) == IdentValue.UNDERLINE || val == IdentValue.OVERLINE)) {
            c.getOutputDevice().drawTextDecoration(c, this);
        }
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (!(child instanceof InlineText)) continue;
            ((InlineText)child).paint(c);
        }
        if (this.textDecoration != null && (val = this.getStyle().getCalculatedStyle().getIdent(CSSName.TEXT_DECORATION)) == IdentValue.LINE_THROUGH) {
            c.getOutputDevice().drawTextDecoration(c, this);
        }
    }

    public int getBorderSides() {
        int result = 5;
        if (this.startsHere) {
            result += 2;
        }
        if (this.endsHere) {
            result += 8;
        }
        return result;
    }

    protected Rectangle getBorderEdge(int left, int top, CssContext cssCtx) {
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        if (this.startsHere || this.endsHere) {
            RectPropertySet margin = this.getStyle().getMarginWidth(cssCtx);
            if (this.startsHere) {
                marginLeft = margin.left();
            }
            if (this.endsHere) {
                marginRight = margin.right();
            }
        }
        BorderPropertySet border = this.getStyle().getCalculatedStyle().getBorder(cssCtx);
        RectPropertySet padding = this.getStyle().getPaddingWidth(cssCtx);
        Rectangle result = new Rectangle((int)((float)left + marginLeft), (int)((float)top - border.top() - padding.top()), (int)((float)this.getInlineWidth(cssCtx) - marginLeft - marginRight), this.getHeight());
        return result;
    }

    public Rectangle getBounds(int left, int top, CssContext cssCtx, int tx, int ty) {
        Rectangle result = this.getBorderEdge(left, top, cssCtx);
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        if (this.startsHere || this.endsHere) {
            RectPropertySet margin = this.getStyle().getMarginWidth(cssCtx);
            if (this.startsHere) {
                marginLeft = margin.left();
            }
            if (this.endsHere) {
                marginRight = margin.right();
            }
        }
        if (marginRight > 0.0f) {
            result.width = (int)((float)result.width + marginRight);
        }
        if (marginLeft > 0.0f) {
            result.x = (int)((float)result.x - marginLeft);
            result.width = (int)((float)result.width + marginLeft);
        }
        result.translate(tx, ty);
        return result;
    }

    public Rectangle getContentAreaEdge(int left, int top, CssContext cssCtx) {
        BorderPropertySet border = this.getStyle().getCalculatedStyle().getBorder(cssCtx);
        RectPropertySet padding = this.getStyle().getPaddingWidth(cssCtx);
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        float borderLeft = 0.0f;
        float borderRight = 0.0f;
        float paddingLeft = 0.0f;
        float paddingRight = 0.0f;
        if (this.startsHere || this.endsHere) {
            RectPropertySet margin = this.getStyle().getMarginWidth(cssCtx);
            if (this.startsHere) {
                marginLeft = margin.left();
                borderLeft = border.left();
                paddingLeft = padding.left();
            }
            if (this.endsHere) {
                marginRight = margin.right();
                borderRight = border.right();
                paddingRight = padding.right();
            }
        }
        Rectangle result = new Rectangle((int)((float)left + marginLeft + borderLeft + paddingLeft), (int)((float)top - border.top() - padding.top()), (int)((float)this.getInlineWidth(cssCtx) - marginLeft - borderLeft - paddingLeft - paddingRight - borderRight - marginRight), this.getHeight());
        return result;
    }

    public int getLeftMarginBorderPadding(CssContext cssCtx) {
        if (this.startsHere) {
            return this.getStyle().getMarginBorderPadding(cssCtx, 1);
        }
        return 0;
    }

    public int getRightMarginPaddingBorder(CssContext cssCtx) {
        if (this.endsHere) {
            return this.getStyle().getMarginBorderPadding(cssCtx, 2);
        }
        return 0;
    }

    public int getInlineWidth() {
        return this.inlineWidth;
    }

    public void setInlineWidth(int inlineWidth) {
        this.inlineWidth = inlineWidth;
    }

    public boolean containsContent() {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (child instanceof InlineText) {
                InlineText iT = (InlineText)child;
                if (iT.isEmpty()) continue;
                return true;
            }
            if (child instanceof InlineBox) {
                InlineBox iB = (InlineBox)child;
                if (!iB.containsContent()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean intersectsInlineBlocks(CssContext cssCtx, Shape clip) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            BoxCollector collector;
            boolean possibleResult;
            Object obj = this.getInlineChild(i);
            if (!(obj instanceof InlineBox ? (possibleResult = ((InlineBox)obj).intersectsInlineBlocks(cssCtx, clip)) : obj instanceof Box && (collector = new BoxCollector()).intersectsAny(cssCtx, clip, (Box)obj))) continue;
            return true;
        }
        return false;
    }

    public TextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(TextDecoration textDecoration) {
        this.textDecoration = textDecoration;
    }

    private void addToContentList(List list) {
        list.add(this);
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (child instanceof InlineBox) {
                ((InlineBox)child).addToContentList(list);
                continue;
            }
            if (!(child instanceof Box)) continue;
            list.add(child);
        }
    }

    public LineBox getLineBox() {
        Box b = this.getParent();
        while (!(b instanceof LineBox)) {
            b = b.getParent();
        }
        return (LineBox)b;
    }

    public List getElementWithContent() {
        ArrayList result = new ArrayList();
        BlockBox container = (BlockBox)this.getLineBox().getParent();
        do {
            List elementBoxes = container.getElementBoxes(this.element);
            for (int i = 0; i < elementBoxes.size(); ++i) {
                InlineBox iB = (InlineBox)elementBoxes.get(i);
                iB.addToContentList(result);
            }
        } while (container instanceof AnonymousBlockBox && !this.containsEnd(result) && (container = this.addFollowingBlockBoxes(container, result)) != null);
        return result;
    }

    private AnonymousBlockBox addFollowingBlockBoxes(BlockBox container, List result) {
        int current;
        Box parent = container.getParent();
        for (current = 0; current < parent.getChildCount(); ++current) {
            if (parent.getChild(current) != container) continue;
            ++current;
            break;
        }
        while (current < parent.getChildCount() && !(parent.getChild(current) instanceof AnonymousBlockBox)) {
            result.add(parent.getChild(current));
            ++current;
        }
        return current == parent.getChildCount() ? null : (AnonymousBlockBox)parent.getChild(current);
    }

    private boolean containsEnd(List result) {
        for (int i = 0; i < result.size(); ++i) {
            Box b = (Box)result.get(i);
            if (!(b instanceof InlineBox)) continue;
            InlineBox iB = (InlineBox)b;
            if (this.element != iB.element || !iB.isEndsHere()) continue;
            return true;
        }
        return false;
    }

    public List getElementBoxes(Element elem) {
        ArrayList<Box> result = new ArrayList<Box>();
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (!(child instanceof Box)) continue;
            Box b = (Box)child;
            if (b.element == elem) {
                result.add(b);
            }
            result.addAll(b.getElementBoxes(elem));
        }
        return result;
    }

    public Dimension positionRelative(CssContext cssCtx) {
        Dimension delta = super.positionRelative(cssCtx);
        this.x -= delta.width;
        this.y -= delta.height;
        List toTranslate = this.getElementWithContent();
        for (int i = 0; i < toTranslate.size(); ++i) {
            Box b = (Box)toTranslate.get(i);
            b.x += delta.width;
            b.y += delta.height;
            b.calcCanvasLocation();
            b.calcChildLocations();
        }
        return delta;
    }

    public void addAllChildren(List list, Layer layer) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (!(child instanceof Box) || ((Box)child).getContainingLayer() != layer) continue;
            list.add(child);
            if (!(child instanceof InlineBox)) continue;
            ((InlineBox)child).addAllChildren(list, layer);
        }
    }

    public void paintDebugOutline(RenderingContext c) {
        c.getOutputDevice().drawDebugOutline(c, this, Color.BLUE);
    }

    protected void detachChildren(LayoutContext c) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object object = this.getInlineChild(i);
            if (!(object instanceof Box)) continue;
            ((Box)object).detach(c);
            --i;
        }
    }

    public void removeChild(Box child) {
        if (this.inlineChildren != null) {
            this.inlineChildren.remove(child);
        }
    }

    public void removeChild(int i) {
        if (this.inlineChildren != null) {
            this.inlineChildren.remove(i);
        }
    }

    public void calcCanvasLocation() {
        LineBox lineBox = this.getLineBox();
        this.setAbsX(lineBox.getAbsX() + this.x);
        this.setAbsY(lineBox.getAbsY() + this.y);
    }

    public void calcChildLocations() {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object obj = this.getInlineChild(i);
            if (!(obj instanceof Box)) continue;
            Box child = (Box)obj;
            child.calcCanvasLocation();
            child.calcChildLocations();
        }
    }

    public void lookForDynamicFunctions(RenderingContext c) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object obj = this.getInlineChild(i);
            if (obj instanceof InlineText) {
                InlineText iT = (InlineText)obj;
                if (!iT.isDynamicFunction()) continue;
                iT.updateDynamicValue(c);
                continue;
            }
            if (!(obj instanceof InlineBox)) continue;
            ((InlineBox)obj).lookForDynamicFunctions(c);
        }
    }

    public InlineText findTrailingText() {
        if (this.getInlineChildCount() == 0) {
            return null;
        }
        InlineText result = null;
        for (int offset = this.getInlineChildCount() - 1; offset >= 0; --offset) {
            Object child = this.getInlineChild(offset);
            if (child instanceof InlineText) {
                result = (InlineText)child;
                if (result.isEmpty()) continue;
                return result;
            }
            if (child instanceof InlineBox) {
                result = ((InlineBox)child).findTrailingText();
                if (result != null && result.isEmpty()) continue;
                return result;
            }
            return null;
        }
        return result;
    }

    public void calculateTextDecoration(LayoutContext c) {
        TextDecoration tD = InlineBoxing.calculateTextDecoration(this, this.getBaseline(), this.getStyle().getFSFontMetrics(c));
        this.setTextDecoration(tD);
    }

    public Box find(CssContext cssCtx, int absX, int absY) {
        Box result = null;
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (!(child instanceof Box) || (result = ((Box)child).find(cssCtx, absX, absY)) == null) continue;
            return result;
        }
        Rectangle edge = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), cssCtx);
        Box box = result = edge.contains(absX, absY) ? this : null;
        if (result != null && this.element == null) {
            return this.getParent().getParent();
        }
        return result;
    }
}

