/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import org.xhtmlrenderer.layout.FunctionData;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.util.Uu;

public class InlineText {
    private InlineBox parent;
    private int x;
    private String masterText;
    private int start;
    private int end;
    private int width;
    private FunctionData functionData;

    public void maybeTrimTrailingSpace(LayoutContext c) {
        if (!this.isEmpty() && this.masterText.charAt(this.end - 1) == ' ') {
            --this.end;
            this.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), this.getParent().getStyle().getCalculatedStyle().getFSFont(c), this.getSubstring()));
        }
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public String getSubstring() {
        if (this.getMasterText() != null) {
            if (this.start == -1 || this.end == -1) {
                throw new RuntimeException("negative index in InlineBox");
            }
            if (this.end < this.start) {
                throw new RuntimeException("end is less than setStartStyle");
            }
            return this.getMasterText().substring(this.start, this.end);
        }
        throw new RuntimeException("No master text set!");
    }

    public void setSubstring(int start, int end) {
        if (end < start) {
            Uu.p("setting substring to: " + start + " " + end);
            throw new RuntimeException("set substring length too long: " + this);
        }
        if (end < 0 || start < 0) {
            throw new RuntimeException("Trying to set negative index to inline box");
        }
        this.start = start;
        this.end = end;
    }

    public String getMasterText() {
        return this.masterText;
    }

    public void setMasterText(String masterText) {
        this.masterText = masterText;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void paint(RenderingContext c) {
        c.getOutputDevice().drawText(c, this);
    }

    public InlineBox getParent() {
        return this.parent;
    }

    public void setParent(InlineBox parent) {
        this.parent = parent;
    }

    public boolean isDynamicFunction() {
        return this.functionData != null;
    }

    public FunctionData getFunctionData() {
        return this.functionData;
    }

    public void setFunctionData(FunctionData functionData) {
        this.functionData = functionData;
    }

    public void updateDynamicValue(RenderingContext c) {
        String value = this.functionData.getContentFunction().calculate(c, this.functionData.getDeclaration(), this);
        this.start = 0;
        this.end = value.length();
        this.masterText = value;
        this.width = c.getTextRenderer().getWidth(c.getFontContext(), this.getParent().getStyle().getCalculatedStyle().getFSFont(c), value);
    }
}

