/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import org.sektor37.minium.TextRenderer;
import org.sektor37.minium.TextRendererFactory;
import org.sektor37.minium.TextRenderingHints;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.render.AWTFSFont;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.Java2DFontContext;
import org.xhtmlrenderer.render.LineMetricsAdapter;
import org.xhtmlrenderer.swing.Java2DOutputDevice;

public class MiniumTextRenderer
implements org.xhtmlrenderer.extend.TextRenderer {
    public TextRenderer renderer;
    protected float scale = 1.0f;
    protected int level = 3;

    public MiniumTextRenderer() {
        TextRendererFactory text_renderer_factory = TextRendererFactory.newOversamplingInstance();
        this.renderer = text_renderer_factory.newTextRenderer();
        String text_renderer_quality = null;
        try {
            System.getProperty("org.xhtmlrenderer.minium.quality");
        }
        catch (SecurityException e) {
            System.err.println(e.getLocalizedMessage());
        }
        if (null == text_renderer_quality) {
            text_renderer_quality = "lowest";
        }
        Map defaultHints = "low".equals(text_renderer_quality) ? TextRenderingHints.DEFAULT_HINTS_QUALITY_LOW : ("medium".equals(text_renderer_quality) ? TextRenderingHints.DEFAULT_HINTS_QUALITY_MEDIUM : ("high".equals(text_renderer_quality) ? TextRenderingHints.DEFAULT_HINTS_QUALITY_HIGH : ("highest".equals(text_renderer_quality) ? TextRenderingHints.DEFAULT_HINTS_QUALITY_HIGHEST : TextRenderingHints.DEFAULT_HINTS_FASTEST)));
        this.renderer.setTextRenderingHints(defaultHints);
    }

    public void drawString(OutputDevice outputDevice, String string, float x, float y) {
        this.renderer.drawString((Graphics)((Java2DOutputDevice)outputDevice).getGraphics(), string, x, y);
    }

    public void setup(FontContext context) {
    }

    public void setFontScale(float scale) {
        this.scale = scale;
    }

    public void setSmoothingThreshold(float fontsize) {
        this.renderer.setTextRenderingHint(TextRenderingHints.KEY_OVERSAMPLING_MIN_FONTSIZE, (Object)new Integer((int)fontsize));
    }

    public void setSmoothingLevel(int level) {
        this.level = level;
        Map defaultHints = TextRenderingHints.DEFAULT_HINTS_FASTEST;
        if (level == 0) {
            defaultHints = TextRenderingHints.DEFAULT_HINTS_FASTEST;
        }
        if (level == 1) {
            defaultHints = TextRenderingHints.DEFAULT_HINTS_QUALITY_LOW;
        }
        if (level == 2) {
            defaultHints = TextRenderingHints.DEFAULT_HINTS_QUALITY_MEDIUM;
        }
        if (level == 3) {
            defaultHints = TextRenderingHints.DEFAULT_HINTS_QUALITY_HIGHEST;
        }
        this.renderer.setTextRenderingHints(defaultHints);
    }

    public FSFontMetrics getFSFontMetrics(FontContext fontContext, FSFont font, String string) {
        Java2DFontContext fc = (Java2DFontContext)fontContext;
        Font awtFont = ((AWTFSFont)font).getAWTFont();
        return new LineMetricsAdapter(this.renderer.getLineMetrics((Graphics)fc.getGraphics(), awtFont, string));
    }

    public int getWidth(FontContext fontContext, FSFont font, String string) {
        Java2DFontContext fc = (Java2DFontContext)fontContext;
        Graphics2D graphics = fc.getGraphics();
        Font awtFont = ((AWTFSFont)font).getAWTFont();
        return (int)Math.ceil(this.renderer.getLogicalBounds((Graphics)graphics, awtFont, string).getWidth());
    }

    public float getFontScale() {
        return this.scale;
    }

    public int getSmoothingLevel() {
        return this.level;
    }
}

