/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Rectangle;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.Style;

public class PageBox {
    private Style _style;
    private int _top;
    private int _bottom;
    private int _paintingTop;
    private int _paintingBottom;
    private int _pageNo;

    public int getWidth(CssContext cssCtx) {
        return (int)this.getStyle().getCalculatedStyle().getFloatPropertyProportionalTo(CSSName.FS_PAGE_WIDTH, 0.0f, cssCtx);
    }

    public int getHeight(CssContext cssCtx) {
        return (int)this.getStyle().getCalculatedStyle().getFloatPropertyProportionalTo(CSSName.FS_PAGE_HEIGHT, 0.0f, cssCtx);
    }

    public int getContentHeight(CssContext cssCtx) {
        return this.getHeight(cssCtx) - this.getStyle().getMarginBorderPadding(cssCtx, 3) - this.getStyle().getMarginBorderPadding(cssCtx, 4);
    }

    public int getContentWidth(CssContext cssCtx) {
        return this.getWidth(cssCtx) - this.getStyle().getMarginBorderPadding(cssCtx, 1) - this.getStyle().getMarginBorderPadding(cssCtx, 2);
    }

    public Style getStyle() {
        return this._style;
    }

    public void setStyle(Style style) {
        this._style = style;
    }

    public int getBottom() {
        return this._bottom;
    }

    public int getTop() {
        return this._top;
    }

    public void setTopAndBottom(CssContext cssCtx, int top) {
        this._top = top;
        this._bottom = top + this.getContentHeight(cssCtx);
    }

    public int getPaintingBottom() {
        return this._paintingBottom;
    }

    public void setPaintingBottom(int paintingBottom) {
        this._paintingBottom = paintingBottom;
    }

    public int getPaintingTop() {
        return this._paintingTop;
    }

    public void setPaintingTop(int paintingTop) {
        this._paintingTop = paintingTop;
    }

    public Rectangle getOverallPaintingBounds(CssContext cssCtx, int additionalClearance) {
        return new Rectangle(additionalClearance, this.getPaintingTop(), this.getWidth(cssCtx), this.getPaintingBottom() - this.getPaintingTop());
    }

    public Rectangle getPagedViewClippingBounds(CssContext cssCtx, int additionalClearance) {
        Rectangle result = new Rectangle(additionalClearance + this.getStyle().getMarginBorderPadding(cssCtx, 1), this.getPaintingTop() + this.getStyle().getMarginBorderPadding(cssCtx, 3), this.getContentWidth(cssCtx), this.getContentHeight(cssCtx));
        return result;
    }

    public Rectangle getPrintingClippingBounds(CssContext cssCtx) {
        Rectangle result = new Rectangle(this.getStyle().getMarginBorderPadding(cssCtx, 1), this.getStyle().getMarginBorderPadding(cssCtx, 3), this.getContentWidth(cssCtx), this.getContentHeight(cssCtx));
        --result.height;
        return result;
    }

    public Rectangle getFlowBounds(CssContext cssCtx, String name) {
        CalculatedStyle style = this.getStyle().getCalculatedStyle();
        String flow = null;
        if (!style.getStringProperty(CSSName.FS_FLOW_TOP).equals("none") && name.equals(flow = style.getStringProperty(CSSName.FS_FLOW_TOP))) {
            return new Rectangle(0, 0, this.getWidth(cssCtx) - (int)this.getStyle().getMarginWidth(cssCtx).width(), (int)this.getStyle().getMarginWidth(cssCtx).top());
        }
        if (!style.getStringProperty(CSSName.FS_FLOW_RIGHT).equals("none") && name.equals(flow = style.getStringProperty(CSSName.FS_FLOW_RIGHT))) {
            return new Rectangle(0, 0, (int)this.getStyle().getMarginWidth(cssCtx).right(), this.getHeight(cssCtx) - (int)this.getStyle().getMarginWidth(cssCtx).height());
        }
        if (!style.getStringProperty(CSSName.FS_FLOW_BOTTOM).equals("none") && name.equals(flow = style.getStringProperty(CSSName.FS_FLOW_BOTTOM))) {
            return new Rectangle(0, 0, this.getWidth(cssCtx) - (int)this.getStyle().getMarginWidth(cssCtx).width(), (int)this.getStyle().getMarginWidth(cssCtx).bottom());
        }
        if (!style.getStringProperty(CSSName.FS_FLOW_LEFT).equals("none") && name.equals(flow = style.getStringProperty(CSSName.FS_FLOW_LEFT))) {
            return new Rectangle(0, 0, (int)this.getStyle().getMarginWidth(cssCtx).left(), this.getHeight(cssCtx) - (int)this.getStyle().getMarginWidth(cssCtx).height());
        }
        return null;
    }

    public void paintAlternateFlows(RenderingContext c, Layer root, short mode) {
        this.paintAlternateFlows(c, root, mode, 0);
    }

    public void paintAlternateFlows(RenderingContext c, Layer root, short mode, int additionalClearance) {
        this.paintTopFlow(c, root, mode, additionalClearance);
        this.paintBottomFlow(c, root, mode, additionalClearance);
        this.paintLeftFlow(c, root, mode, additionalClearance);
        this.paintRightFlow(c, root, mode, additionalClearance);
    }

    private void paintTopFlow(RenderingContext c, Layer root, short mode, int additionalClearance) {
        CalculatedStyle style = this.getStyle().getCalculatedStyle();
        String flowName = style.getStringProperty(CSSName.FS_FLOW_TOP);
        if (!flowName.equals("none")) {
            int top;
            int left = additionalClearance + (int)this.getStyle().getMarginWidth(c).left();
            if (mode == 1) {
                top = this.getPaintingTop();
            } else if (mode == 2) {
                top = 0;
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            this.paintFlow(c, root, flowName, left, top);
        }
    }

    private void paintBottomFlow(RenderingContext c, Layer root, short mode, int additionalClearance) {
        CalculatedStyle style = this.getStyle().getCalculatedStyle();
        String flowName = style.getStringProperty(CSSName.FS_FLOW_BOTTOM);
        if (!flowName.equals("none")) {
            int top;
            int left = additionalClearance + (int)this.getStyle().getMarginWidth(c).left();
            if (mode == 1) {
                top = this.getPaintingBottom() - (int)this.getStyle().getMarginWidth(c).bottom();
            } else if (mode == 2) {
                top = this.getHeight(c) - (int)this.getStyle().getMarginWidth(c).bottom();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            this.paintFlow(c, root, flowName, left, top);
        }
    }

    private void paintLeftFlow(RenderingContext c, Layer root, short mode, int additionalClearance) {
        CalculatedStyle style = this.getStyle().getCalculatedStyle();
        String flowName = style.getStringProperty(CSSName.FS_FLOW_LEFT);
        if (!flowName.equals("none")) {
            int top;
            int left = additionalClearance;
            if (mode == 1) {
                top = this.getPaintingTop() + (int)this.getStyle().getMarginWidth(c).top();
            } else if (mode == 2) {
                top = (int)this.getStyle().getMarginWidth(c).top();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            this.paintFlow(c, root, flowName, left, top);
        }
    }

    private void paintRightFlow(RenderingContext c, Layer root, short mode, int additionalClearance) {
        CalculatedStyle style = this.getStyle().getCalculatedStyle();
        String flowName = style.getStringProperty(CSSName.FS_FLOW_RIGHT);
        if (!flowName.equals("none")) {
            int top;
            int left = additionalClearance + this.getWidth(c) - (int)this.getStyle().getMarginWidth(c).right();
            if (mode == 1) {
                top = this.getPaintingTop() + (int)this.getStyle().getMarginWidth(c).top();
            } else if (mode == 2) {
                top = (int)this.getStyle().getMarginWidth(c).top();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            this.paintFlow(c, root, flowName, left, top);
        }
    }

    private void paintFlow(RenderingContext c, Layer root, String flowName, int left, int top) {
        Layer flow = root.getAlternateFlow(flowName);
        if (flow != null) {
            c.getOutputDevice().translate(left, top);
            flow.paint(c, 0, 0, true);
            c.getOutputDevice().translate(-left, -top);
        }
    }

    private Rectangle getBorderEdge(int left, int top, CssContext cssCtx) {
        RectPropertySet margin = this.getStyle().getMarginWidth(cssCtx);
        Rectangle result = new Rectangle(left + (int)margin.left(), top + (int)margin.top(), this.getWidth(cssCtx) - (int)margin.left() - (int)margin.right(), this.getHeight(cssCtx) - (int)margin.top() - (int)margin.bottom());
        return result;
    }

    public void paintBorder(RenderingContext c, int additionalClearance, short mode) {
        int top = 0;
        if (mode == 1) {
            top = this.getPaintingTop();
        }
        c.getOutputDevice().paintBorder(c, this.getStyle().getCalculatedStyle(), this.getBorderEdge(additionalClearance, top, c), 15);
    }

    public int getPageNo() {
        return this._pageNo;
    }

    public void setPageNo(int pageNo) {
        this._pageNo = pageNo;
    }
}

