/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.xhtmlrenderer.render.VerticalExtent;

public class VerticalExtentList {
    List children = new ArrayList();

    public void addChild(VerticalExtent b) {
        int l = this.findFirstBottomAfterTop(b.getAbsTop());
        if (l >= this.children.size()) {
            this.children.add(b);
            return;
        }
        VerticalExtent c = (VerticalExtent)this.children.get(l);
        if (c.getAbsTop() >= b.getAbsBottom()) {
            this.children.add(l, b);
        } else if (b.getAbsTop() >= c.getAbsTop() && b.getAbsBottom() <= c.getAbsBottom()) {
            if (c instanceof ParentVerticalExtent) {
                ((ParentVerticalExtent)c).addChild(b);
            } else {
                ParentVerticalExtent p = new ParentVerticalExtent(c);
                p.addChild(b);
                this.children.set(l, p);
            }
        } else if (b.getAbsTop() <= c.getAbsTop() && b.getAbsBottom() >= c.getAbsBottom()) {
            ParentVerticalExtent p = new ParentVerticalExtent(b);
            while (c != null && p.getAbsBottom() >= c.getAbsBottom()) {
                p.addChild(c);
                this.children.remove(l);
                if (l < this.children.size()) {
                    c = (VerticalExtent)this.children.get(l);
                    continue;
                }
                c = null;
            }
            if (c != null && c.getAbsTop() < p.getAbsBottom()) {
                this.children.set(l, p);
                this.addChild(c);
            } else {
                this.children.add(l, p);
            }
        } else if (b.getAbsTop() > c.getAbsTop()) {
            PartialVerticalExtent p1 = new PartialVerticalExtent(c, c.getAbsTop(), b.getAbsTop());
            OverlapVerticalExtent p2 = new OverlapVerticalExtent(b, c, b.getAbsTop(), c.getAbsBottom());
            PartialVerticalExtent p3 = new PartialVerticalExtent(b, c.getAbsBottom(), b.getAbsBottom());
            this.children.set(l, p2);
            this.children.add(l, p1);
            this.addChild(p3);
        } else {
            PartialVerticalExtent p1 = new PartialVerticalExtent(b, b.getAbsTop(), c.getAbsTop());
            OverlapVerticalExtent p2 = new OverlapVerticalExtent(c, b, c.getAbsTop(), b.getAbsBottom());
            PartialVerticalExtent p3 = new PartialVerticalExtent(c, b.getAbsBottom(), c.getAbsBottom());
            this.children.set(l, p2);
            this.children.add(l, p1);
            this.addChild(p3);
        }
    }

    public void getIntersectingChildSet(Set intersectingChildren, double t, double b) {
        for (int l = this.findFirstBottomAfterTop(t); l < this.children.size(); ++l) {
            VerticalExtent verticalExtent;
            VerticalExtent c = (VerticalExtent)this.children.get(l);
            if (!(verticalExtent.getAbsTop() < b)) break;
            if (c instanceof VirtualVerticalExtent) {
                ((VirtualVerticalExtent)c).getIntersectingChildren(intersectingChildren, t, b);
                continue;
            }
            intersectingChildren.add(c);
        }
    }

    private int findFirstBottomAfterTop(double t) {
        int l = 0;
        int r = this.children.size();
        while (l < r) {
            int m = (l + r) / 2;
            VerticalExtent c = (VerticalExtent)this.children.get(m);
            if (c.getAbsBottom() > t) {
                r = m;
                continue;
            }
            l = m + 1;
        }
        return l;
    }

    private class OverlapVerticalExtent
    implements VirtualVerticalExtent {
        private VerticalExtent v1;
        private VerticalExtent v2;
        private double top;
        private double bottom;

        OverlapVerticalExtent(VerticalExtent c1, VerticalExtent c2, double t, double b) {
            this.v1 = c1;
            this.v2 = c2;
            this.top = t;
            this.bottom = b;
        }

        public double getAbsTop() {
            return this.top;
        }

        public double getAbsBottom() {
            return this.bottom;
        }

        public void getIntersectingChildren(Set intersectingChildren, double t, double b) {
            double itop = Math.max(this.getAbsTop(), t);
            double ibot = Math.min(this.getAbsBottom(), b);
            if (ibot <= itop) {
                return;
            }
            if (this.v1 instanceof VirtualVerticalExtent) {
                ((VirtualVerticalExtent)this.v1).getIntersectingChildren(intersectingChildren, itop, ibot);
            } else {
                intersectingChildren.add(this.v1);
            }
            if (this.v2 instanceof VirtualVerticalExtent) {
                ((VirtualVerticalExtent)this.v2).getIntersectingChildren(intersectingChildren, itop, ibot);
            } else {
                intersectingChildren.add(this.v2);
            }
        }
    }

    private class PartialVerticalExtent
    implements VirtualVerticalExtent {
        private double top;
        private double bottom;
        private VerticalExtent parent;

        PartialVerticalExtent(VerticalExtent p, double t, double b) {
            this.parent = p;
            this.top = t;
            this.bottom = b;
        }

        public double getAbsTop() {
            return this.top;
        }

        public double getAbsBottom() {
            return this.bottom;
        }

        public void getIntersectingChildren(Set intersectingChildren, double t, double b) {
            double itop = Math.max(this.getAbsTop(), t);
            double ibot = Math.min(this.getAbsBottom(), b);
            if (ibot <= itop) {
                return;
            }
            if (this.parent instanceof VirtualVerticalExtent) {
                ((VirtualVerticalExtent)this.parent).getIntersectingChildren(intersectingChildren, itop, ibot);
            } else {
                intersectingChildren.add(this.parent);
            }
        }
    }

    private class ParentVerticalExtent
    implements VirtualVerticalExtent {
        private VerticalExtent parent;
        private VerticalExtentList vel = new VerticalExtentList();

        ParentVerticalExtent(VerticalExtent p) {
            this.parent = p;
        }

        public double getAbsTop() {
            return this.parent.getAbsTop();
        }

        public double getAbsBottom() {
            return this.parent.getAbsBottom();
        }

        public void addChild(VerticalExtent b) {
            this.vel.addChild(b);
        }

        public void getIntersectingChildren(Set intersectingChildren, double t, double b) {
            double itop = Math.max(this.getAbsTop(), t);
            double ibot = Math.min(this.getAbsBottom(), b);
            if (ibot <= itop) {
                return;
            }
            if (this.parent instanceof VirtualVerticalExtent) {
                ((VirtualVerticalExtent)this.parent).getIntersectingChildren(intersectingChildren, itop, ibot);
            } else {
                intersectingChildren.add(this.parent);
            }
            this.vel.getIntersectingChildSet(intersectingChildren, itop, ibot);
        }
    }

    private static interface VirtualVerticalExtent
    extends VerticalExtent {
        public void getIntersectingChildren(Set var1, double var2, double var4);
    }
}

