/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.Restyling;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.swing.BasicPanel;

public class HoverListener
extends MouseInputAdapter {
    private BasicPanel panel;
    private Box prev;

    public HoverListener(BasicPanel panel) {
        this.panel = panel;
    }

    private Box find(MouseEvent evt) {
        Box result = this.panel.find(evt);
        return result;
    }

    public void mouseMoved(MouseEvent evt) {
        Box ib = this.find(evt);
        this.restyle(ib);
    }

    public void mouseEntered(MouseEvent evt) {
        Box ib = this.find(evt);
        this.restyle(ib);
    }

    public void mouseExited(MouseEvent evt) {
        Box ib = this.find(evt);
        this.restyle(ib);
    }

    private void restyle(Box ib) {
        boolean needRepaint = false;
        Element hovered_element = this.getHoveredElement(ib);
        if (hovered_element == this.panel.hovered_element) {
            return;
        }
        Element previousHoveredElement = this.panel.hovered_element;
        this.panel.hovered_element = hovered_element;
        if (this.prev != null) {
            needRepaint = true;
            this.restyleElementChildBoxes(previousHoveredElement, this.prev);
            this.prev = null;
        }
        if (hovered_element != null) {
            needRepaint = true;
            this.restyleElementChildBoxes(hovered_element, ib);
            this.prev = ib;
        }
        if (needRepaint) {
            this.panel.repaint();
        }
    }

    private LayoutContext newLayoutContextInstance() {
        LayoutContext result = this.panel.getSharedContext().newLayoutContextInstance(this.panel.getScreenExtents());
        result.setFontContext(this.panel.layout_context.getFontContext());
        return result;
    }

    private void restyleElementChildBoxes(Element e, Box ib) {
        Box p = ib;
        while (true) {
            if (!(p == null || p instanceof BlockBox && p.element != null)) {
                p = p.getParent();
                continue;
            }
            if (p == null) {
                Restyling.restyleAll(this.newLayoutContextInstance(), (BlockBox)this.panel.getRootBox());
                return;
            }
            Element pe = p.element;
            Element ie = e;
            while (ie != null && ie != pe) {
                Node n = ie.getParentNode();
                if (n.getNodeType() == 1) {
                    ie = (Element)n;
                    continue;
                }
                ie = null;
            }
            if (ie == pe) break;
        }
        Restyling.restyleAll(this.newLayoutContextInstance(), (BlockBox)p);
    }

    private Element getHoveredElement(Box ib) {
        if (ib == null) {
            return null;
        }
        Element e = ib.element;
        while (e != null && !this.panel.getSharedContext().getCss().isHoverStyled(e)) {
            Node n = e.getParentNode();
            if (n.getNodeType() == 1) {
                e = (Element)n;
                continue;
            }
            e = null;
        }
        return e;
    }

    public void reset() {
        this.prev = null;
    }
}

