/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.Uu;

public class LayoutThread
implements Runnable {
    private boolean done;
    private Graphics graphics;
    private BasicPanel panel;
    private boolean threaded;
    private LayoutContext context;
    protected boolean second_set = false;
    protected Dimension last_size;

    public LayoutThread(BasicPanel panel) {
        this.panel = panel;
        this.done = true;
        this.graphics = null;
        this.threaded = true;
    }

    public void setThreadedLayout(boolean threaded) {
        this.threaded = threaded;
    }

    public void startLayout(Graphics g, Dimension d) {
        if (this.shouldLayout()) {
            this.graphics = g;
            if (this.threaded) {
                new Thread(this).start();
            } else {
                this.run();
            }
        } else if (Configuration.isTrue("xr.layout.bad-sizing-hack", false)) {
            this.requestReLayout(d);
        }
    }

    public synchronized void waitForLayoutStopped() throws InterruptedException {
        this.wait();
    }

    protected void requestReLayout(final Dimension d) {
        if (this.last_size == null || d.equals(this.last_size)) {
            // empty if block
        }
        if (this.second_set) {
            return;
        }
        this.second_set = true;
        this.last_size = d;
        new Thread(new Runnable(){

            public void run() {
                try {
                    LayoutThread.this.waitForLayoutStopped();
                }
                catch (Exception ex) {
                    Uu.p(ex);
                }
                LayoutThread.this.second_set = false;
                if (LayoutThread.this.panel.getPreferredSize() != null && LayoutThread.this.panel.getPreferredSize().equals(d)) {
                    return;
                }
                LayoutThread.this.panel.repaint();
            }
        }).start();
    }

    public void stopLayout() {
        this.context.stopRendering();
    }

    public void run() {
        this.completeLayout();
    }

    private synchronized void completeLayout() {
        this.done = true;
        this.graphics = null;
        this.panel.repaint();
        this.notifyAll();
    }

    public synchronized boolean isLayoutDone() {
        return this.done;
    }

    public synchronized boolean shouldLayout() {
        if (this.done) {
            this.done = false;
            return true;
        }
        return false;
    }
}

